/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;

public class Brenderer {
    static BufferedImage imageOut;
    int w;
    int h;
    static volatile int y;
    static ColorCalculator ccc;
    boolean showCompleteRows = false;
    CountDownLatch latch = new CountDownLatch(0);

    static {
        y = 0;
    }

    public BufferedImage renderImage(ColorCalculator c) {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        y = 0;
        this.w = c.getWidth();
        this.h = c.getHeight();
        ccc = c;
        imageOut = new BufferedImage(this.w, this.h, 6);
        int threadNum = Runtime.getRuntime().availableProcessors();
        this.latch = new CountDownLatch(threadNum);
        int i = 0;
        while (i < threadNum) {
            renderThread rt = new renderThread();
            rt.start();
            ++i;
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.toCompatibleImage(imageOut);
    }

    public void saveImage(BufferedImage image, String name) {
        try {
            File outputfile;
            String imageType;
            int dotIndex = name.length() - 4;
            if (name.charAt(dotIndex) == '.') {
                imageType = name.substring(dotIndex + 1).toUpperCase();
                outputfile = new File(name);
            } else {
                imageType = "PNG";
                outputfile = new File(String.valueOf(name) + "." + imageType.toLowerCase());
            }
            ImageIO.write((RenderedImage)image, imageType, outputfile);
        }
        catch (IOException e) {
            System.out.println("Brenderer: saveImage function has failed. Bug 1");
        }
    }

    private BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration gfx_config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (image.getColorModel().equals(gfx_config.getColorModel())) {
            return image;
        }
        BufferedImage new_image = gfx_config.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics2D g2d = (Graphics2D)new_image.getGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return new_image;
    }

    private class renderThread
    extends Thread {
        private renderThread() {
        }

        @Override
        public synchronized void run() {
            ColorCalculator ccc = (ColorCalculator)Brenderer.ccc.clone();
            int antiAliasing = ccc.getAntiAliasing();
            int[] rgb_line = new int[Brenderer.this.w];
            if (antiAliasing < 2) {
                while (y < Brenderer.this.h) {
                    int y = Brenderer.y++;
                    int x = 0;
                    while (x < Brenderer.this.w) {
                        rgb_line[x] = ccc.getColor(x, y).getRGB();
                        ++x;
                    }
                    if (y >= Brenderer.this.h) continue;
                    imageOut.setRGB(0, y, Brenderer.this.w, 1, rgb_line, 0, Brenderer.this.w);
                }
            } else {
                int averagingDivisor;
                double[] subCoordinates = new double[antiAliasing];
                int k = 0;
                while (k < antiAliasing) {
                    subCoordinates[k] = 1.0 * (double)k / (double)antiAliasing;
                    ++k;
                }
                int normalAveragingDivisor = averagingDivisor = antiAliasing * antiAliasing;
                Color cc = null;
                while (y < Brenderer.this.h) {
                    int y = Brenderer.y++;
                    int x = 0;
                    while (x < Brenderer.this.w) {
                        Color c1 = ccc.getColor((double)x + subCoordinates[antiAliasing - 1], (double)y + subCoordinates[antiAliasing - 1]);
                        Color c2 = ccc.getColor((double)x + subCoordinates[antiAliasing - 1], y);
                        if (x > 0 && ccc.optimize && c1.getRGB() == rgb_line[x - 1] && c2.getRGB() == rgb_line[x - 1]) {
                            rgb_line[x] = ccc.getColor(x, y).getRGB();
                        } else {
                            int red = 0;
                            int green = 0;
                            int blue = 0;
                            int alpha = 0;
                            averagingDivisor = 0;
                            int xx = antiAliasing - 1;
                            int yy = 1;
                            while (yy < antiAliasing - 1) {
                                cc = ccc.getColor((double)x + subCoordinates[xx], (double)y + subCoordinates[yy]);
                                red += cc.getRed() * cc.getAlpha();
                                green += cc.getGreen() * cc.getAlpha();
                                blue += cc.getBlue() * cc.getAlpha();
                                alpha += cc.getAlpha();
                                averagingDivisor += cc.getAlpha();
                                ++yy;
                            }
                            cc = c1;
                            red += cc.getRed() * cc.getAlpha();
                            green += cc.getGreen() * cc.getAlpha();
                            blue += cc.getBlue() * cc.getAlpha();
                            alpha += cc.getAlpha();
                            averagingDivisor += cc.getAlpha();
                            cc = c2;
                            red += cc.getRed() * cc.getAlpha();
                            green += cc.getGreen() * cc.getAlpha();
                            blue += cc.getBlue() * cc.getAlpha();
                            alpha += cc.getAlpha();
                            averagingDivisor += cc.getAlpha();
                            xx = 0;
                            while (xx < antiAliasing - 1) {
                                yy = 0;
                                while (yy < antiAliasing) {
                                    cc = ccc.getColor((double)x + subCoordinates[xx], (double)y + subCoordinates[yy]);
                                    red += cc.getRed() * cc.getAlpha();
                                    green += cc.getGreen() * cc.getAlpha();
                                    blue += cc.getBlue() * cc.getAlpha();
                                    alpha += cc.getAlpha();
                                    averagingDivisor += cc.getAlpha();
                                    ++yy;
                                }
                                ++xx;
                            }
                            if (averagingDivisor != 0) {
                                red /= averagingDivisor;
                                green /= averagingDivisor;
                                blue /= averagingDivisor;
                                alpha /= normalAveragingDivisor;
                            }
                            cc = new Color(red, green, blue, alpha);
                            rgb_line[x] = cc.getRGB();
                        }
                        ++x;
                    }
                    if (y >= Brenderer.this.h) continue;
                    imageOut.setRGB(0, y, Brenderer.this.w, 1, rgb_line, 0, Brenderer.this.w);
                }
            }
            Brenderer.this.latch.countDown();
        }
    }
}

