/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Random;

public class BryceMath {
    Random random = new Random();
    public final long mySeed = (long)this.random(Integer.MAX_VALUE);
    final double pi = Math.PI;
    final double e = Math.E;

    public double degToRad(double degrees) {
        return Math.toRadians(degrees);
    }

    public double radToDeg(double radians) {
        return Math.toDegrees(radians);
    }

    public double cos(double input) {
        return Math.cos(input);
    }

    public double arcCos(double input) {
        return Math.acos(input);
    }

    public double sin(double input) {
        return Math.sin(input);
    }

    public double arcSin(double input) {
        return Math.asin(input);
    }

    public double tan(double input) {
        return Math.tan(input);
    }

    public double arcTan(double input) {
        return Math.atan(input);
    }

    public double ln(double input) {
        return Math.log(input);
    }

    public double log10(double input) {
        return Math.log10(input);
    }

    public double logA(double input, int base) {
        return this.ln(input) / this.ln(base);
    }

    public double sqrt(double input) {
        return Math.sqrt(input);
    }

    public double sqr(double input) {
        return input * input;
    }

    public double pow(double number, double p) {
        return Math.pow(number, p);
    }

    public double pow(double number, int p) {
        double output = number;
        int i = 0;
        while (i < p) {
            output *= number;
            ++i;
        }
        return output;
    }

    public int pow(int number, int p) {
        int output = number;
        int i = 0;
        while (i < p) {
            output *= number;
            ++i;
        }
        return output;
    }

    public double random() {
        return this.random.nextDouble();
    }

    public double random(int n) {
        return (double)n * this.random.nextDouble();
    }

    public double random(double n) {
        return n * this.random.nextDouble();
    }

    public double random(int f, int l) {
        return (double)(l - f) * this.random.nextDouble() + (double)f;
    }

    public void random_set_seed() {
        this.random.setSeed(this.mySeed);
    }

    public void random_set_seed(int seed) {
        this.random.setSeed(seed);
    }

    public int round(double n) {
        return (int)Math.round(n);
    }

    public int ceil(double n) {
        return (int)Math.ceil(n);
    }

    public int floor(double n) {
        return (int)Math.floor(n);
    }

    public double max(double n1, double n2) {
        return Math.max(n1, n2);
    }

    public double min(double n1, double n2) {
        return Math.min(n1, n2);
    }

    public int max(int n1, int n2) {
        return Math.max(n1, n2);
    }

    public int min(int n1, int n2) {
        return Math.min(n1, n2);
    }

    public double bound(double in, double min, double max) {
        return this.max(min, this.min(in, max));
    }

    public int sign(double in) {
        if (in < 0.0) {
            return -1;
        }
        if (in > 0.0) {
            return 1;
        }
        return 0;
    }

    public double sqrDistance(double x1, double y1, double x2, double y2) {
        return this.sqr(x1 - x2) + this.sqr(y1 - y2);
    }

    public double distance(double x1, double y1, double x2, double y2) {
        return this.sqrt(this.sqrDistance(x1, y1, x2, y2));
    }

    double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.sqrt(this.sqr(x1 - x2) + this.sqr(y1 - y2) + this.sqr(z1 - z2));
    }

    double sqrDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.sqr(x1 - x2) + this.sqr(y1 - y2) + this.sqr(z1 - z2);
    }

    public int abs(int n) {
        if (n < 0) {
            n *= -1;
        }
        return n;
    }

    public double abs(double n) {
        if (n < 0.0) {
            n *= -1.0;
        }
        return n;
    }

    public Color weightedAverageColor(Color c1, Color c2, double pC2) {
        double pC1 = 1.0 - pC2;
        double red = (double)c1.getRed() * pC1 + (double)c2.getRed() * pC2;
        double green = (double)c1.getGreen() * pC1 + (double)c2.getGreen() * pC2;
        double blue = (double)c1.getBlue() * pC1 + (double)c2.getBlue() * pC2;
        return new Color((int)red, (int)green, (int)blue);
    }

    public Color Color_rgb(double r, double g, double b, double alpha) {
        Color temp = this.Color_rgb(r, g, b);
        return new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), (int)alpha);
    }

    public Color Color_rgb(double red, double green, double blue) {
        if ((red %= 256.0) < 0.0) {
            red += 256.0;
        }
        if ((green %= 256.0) < 0.0) {
            green += 256.0;
        }
        if ((blue %= 256.0) < 0.0) {
            blue += 256.0;
        }
        return new Color((int)red, (int)green, (int)blue);
    }

    public Color Color_hsv(double h, double s, double v, double alpha) {
        Color temp = this.Color_hsv(h, s, v);
        return new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), (int)alpha);
    }

    public Color Color_hsv(double h, double s, double v) {
        double b;
        double g;
        double r;
        if ((h %= 360.0) < 0.0) {
            h += 360.0;
        }
        if ((s %= 101.0) < 0.0) {
            s += 101.0;
        }
        if ((v %= 101.0) < 0.0) {
            v += 101.0;
        }
        h = this.min(h, 360.0);
        s = this.min(s, 100.0);
        v = this.min(v, 100.0);
        v /= 100.0;
        if ((s /= 100.0) == 0.0) {
            double b2;
            double g2 = b2 = v;
            double r2 = b2;
            return new Color(this.round(r2 * 255.0), this.round(g2 * 255.0), this.round(b2 * 255.0));
        }
        int i = this.floor(h /= 60.0);
        double f = h - (double)i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - s * f);
        double t = v * (1.0 - s * (1.0 - f));
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new Color(this.round(r * 255.0), this.round(g * 255.0), this.round(b * 255.0));
    }

    public boolean circleOutline(double x, double y, double cX, double cY, double radius, double thickness) {
        if (this.abs(cX - x) > radius || this.abs(cY - y) > radius) {
            return false;
        }
        double tempDist = this.distance(x, y, cX, cY);
        return tempDist < radius && tempDist > radius - thickness;
    }

    public boolean circle(double x, double y, double cX, double cY, double radius) {
        if (this.abs(cX - x) > radius || this.abs(cY - y) > radius) {
            return false;
        }
        double tempDist = this.sqrDistance(x, y, cX, cY);
        return tempDist < radius * radius;
    }

    public boolean ellipse(double x, double y, double cX, double cY, double width, double height) {
        return this.circle((x - cX) / width * height + cX, y, cX, cY, height);
    }

    public boolean sector(double x, double y, double cX, double cY, double radius, double thickness, double angleMin, double angleMax) {
        if (this.circleOutline(x, y, cX, cY, radius, thickness)) {
            double tAngle = this.lineAngle(x, y, cX, cY);
            if (angleMin < 0.0) {
                tAngle -= angleMin;
                tAngle %= 360.0;
                angleMax -= angleMin;
                angleMin = 0.0;
            }
            if (tAngle >= angleMin && tAngle <= angleMax) {
                return true;
            }
        }
        return false;
    }

    public double lineAngle(double x, double y, double focusX, double focusY) {
        return (this.radToDeg(Math.atan2(x - focusX, y - focusY)) + 270.0) % 360.0;
    }

    public double lineAngle2(double x, double y, double focusX, double focusY) {
        return this.radToDeg(Math.atan2(y - focusY, x - focusX));
    }

    public boolean line(double x, double y, double a, double b, double thickness) {
        return y > a * x + b - thickness && y < a * x + b + thickness;
    }

    public boolean rectangle(double x, double y, double x1, double x2, double y1, double y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public boolean rectangle2(double x, double y, double x1, double y1, double width, double height) {
        double x2 = x1 + width;
        double y2 = y1 + height;
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public boolean inTile(double x, double y, double tW, double tH, double cS, double oS) {
        double tileW = tW;
        double offSet = oS;
        double tempX = x % (tileW + offSet);
        double tileH = tH;
        double tempY = y % (tileH + offSet);
        double curveSize = cS;
        return this.rectangle(tempX, tempY, 0.0, tileW, curveSize, tileH - curveSize) || this.rectangle(tempX, tempY, curveSize, tileW - curveSize, 0.0, tileH) || this.circle(tempX, tempY, curveSize, curveSize, curveSize) || this.circle(tempX, tempY, tileW - curveSize, curveSize, curveSize) || this.circle(tempX, tempY, tileW - curveSize, tileH - curveSize, curveSize) || this.circle(tempX, tempY, curveSize, tileH - curveSize, curveSize);
    }
}

