/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GamePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    BufferedImage screen;
    int fps = 60;
    Timer t;
    Graphics g;
    boolean start = false;
    LinkedList<Obj> objs;

    public GamePane(Dimension dim) {
        Global.screen_width = (int)dim.getWidth();
        Global.screen_height = (int)dim.getHeight();
        Global.room_width = Global.screen_width;
        Global.room_height = Global.screen_height;
        this.setupTimers();
    }

    public void startGame() {
        this.screen = new BufferedImage(Global.screen_width, Global.screen_height, 2);
        Global.views = new LinkedList();
        Global.g = this.g = this.getGraphics();
        Global.scale = Global.getMaxScale();
        Global.OldScale = Global.scale - 1;
        Global.spriteLoader = new SpriteLoader();
        Global.spriteLoader.loadMenuSprites();
        Global.spriteLoader.loadExample();
        this.objs = new LinkedList();
        Global.objs = this.objs;
        this.objs.add(new room_mainMenu());
    }

    public void setupTimers() {
        this.t = new Timer(1000 / Global.fps, new Stepy());
        this.t.start();
        this.setFocusable(true);
        this.addKeyListener(new KeyInput());
        this.requestFocus();
        mouseInput mIn = new mouseInput();
        this.addMouseListener(mIn);
        this.addMouseMotionListener(mIn);
    }

    private class KeyInput
    extends KeyAdapter {
        private KeyInput() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                System.exit(0);
            }
            for (Obj o : GamePane.this.objs) {
                o.keyPressed(e.getKeyCode());
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            for (Obj o : GamePane.this.objs) {
                o.keyReleased(e.getKeyCode());
            }
        }
    }

    private class Stepy
    implements ActionListener {
        private Stepy() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GamePane.this.start) {
                GamePane.this.startGame();
                GamePane.this.start = true;
            } else {
                Collections.reverse(GamePane.this.objs);
                Collections.sort(GamePane.this.objs);
                Collections.reverse(GamePane.this.objs);
                int k = GamePane.this.objs.size() - 1;
                while (k >= 0) {
                    if (Global.nextStep) {
                        Global.nextStep = false;
                        return;
                    }
                    Obj o = GamePane.this.objs.get(k);
                    if (o.isAlive()) {
                        o.update();
                    } else {
                        GamePane.this.objs.remove(k);
                    }
                    --k;
                }
                if (GamePane.this.fps != Global.fps) {
                    GamePane.this.t.setDelay(1000 / Global.fps);
                    GamePane.this.fps = Global.fps;
                }
                int threadNum = Global.views.size();
                Global.finalLatch = new CountDownLatch(threadNum);
                int k2 = Global.views.size() - 1;
                while (k2 >= 0) {
                    if (Global.nextStep) {
                        Global.nextStep = false;
                        return;
                    }
                    obj_view v = Global.views.get(k2);
                    if (v.isAlive()) {
                        v.update();
                        v.draw((Graphics2D)GamePane.this.screen.getGraphics());
                    } else {
                        Global.views.remove(k2);
                    }
                    --k2;
                }
                Global.nextStep = false;
                try {
                    Global.finalLatch.await();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                GamePane.this.getGraphics().drawImage(GamePane.this.screen, 0, 0, null);
            }
        }
    }

    private class mouseInput
    extends MouseAdapter
    implements MouseMotionListener {
        private mouseInput() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int eX = e.getX();
            int eY = e.getY();
            boolean viewHit = false;
            if (!Global.views.isEmpty()) {
                for (obj_view v : Global.views) {
                    if (eX < v.screenX || eX >= v.screenX + v.screenW || eY < v.screenY || eY >= v.screenY + v.screenH) continue;
                    eX = (int)(v.x + (double)((eX - v.screenX) * v.myImage.getWidth() / v.screenW));
                    eY = (int)(v.y + (double)((eY - v.screenY) * v.myImage.getHeight() / v.screenH));
                    viewHit = true;
                    break;
                }
            }
            if (!viewHit) {
                return;
            }
            Global.mouseX = eX;
            Global.mouseY = eY;
            Global.mouseButton = e.getButton();
            for (Obj o : GamePane.this.objs) {
                if (!o.mouseCollision(eX, eY)) continue;
                o.mouseAction();
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Global.mouseButton = e.getButton();
            int eX = e.getX();
            int eY = e.getY();
            boolean viewHit = false;
            if (!Global.views.isEmpty()) {
                for (obj_view v : Global.views) {
                    if (eX < v.screenX || eX >= v.screenX + v.screenW || eY < v.screenY || eY >= v.screenY + v.screenH) continue;
                    eX = (int)(v.x + (double)((eX - v.screenX) * v.myImage.getWidth() / v.screenW));
                    eY = (int)(v.y + (double)((eY - v.screenY) * v.myImage.getHeight() / v.screenH));
                    viewHit = true;
                    break;
                }
            }
            if (!viewHit) {
                return;
            }
            for (Obj o : GamePane.this.objs) {
                if (!o.mouseCollision(eX, eY)) continue;
                o.mouseReleaseAction();
                return;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int eX = e.getX();
            int eY = e.getY();
            boolean viewHit = false;
            if (!Global.views.isEmpty()) {
                for (obj_view v : Global.views) {
                    if (eX < v.screenX || eX >= v.screenX + v.screenW || eY < v.screenY || eY >= v.screenY + v.screenH) continue;
                    eX = (int)(v.x + (double)((eX - v.screenX) * v.myImage.getWidth() / v.screenW));
                    eY = (int)(v.y + (double)((eY - v.screenY) * v.myImage.getHeight() / v.screenH));
                    viewHit = true;
                    break;
                }
            }
            if (!viewHit) {
                return;
            }
            for (Obj o : GamePane.this.objs) {
                o.setMouseInRegion(o.mouseCollision(eX, eY));
            }
            Global.mouseX = eX;
            Global.mouseY = eY;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int eX = e.getX();
            int eY = e.getY();
            boolean viewHit = false;
            if (!Global.views.isEmpty()) {
                for (obj_view v : Global.views) {
                    if (eX < v.screenX || eX >= v.screenX + v.screenW || eY < v.screenY || eY >= v.screenY + v.screenH) continue;
                    eX = (int)(v.x + (double)((eX - v.screenX) * v.myImage.getWidth() / v.screenW));
                    eY = (int)(v.y + (double)((eY - v.screenY) * v.myImage.getHeight() / v.screenH));
                    viewHit = true;
                    break;
                }
            }
            if (!viewHit) {
                return;
            }
            Global.mouseX = eX;
            Global.mouseY = eY;
            for (Obj o : GamePane.this.objs) {
                if (!o.mouseCollision(eX, eY)) continue;
                o.mouseDraggedAction();
                return;
            }
        }
    }
}

