/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.StringCharacterIterator;
import java.util.LinkedList;

public abstract class Obj
extends BryceMath
implements Comparable<Obj> {
    double x;
    double y;
    double startX;
    double startY;
    int scale;
    BufferedImage sprite;
    int orginX = 0;
    int orginY = 0;
    int room_width;
    int room_height;
    int subImage;
    double image_angle = 0.0;
    int depth;
    boolean draw = true;
    boolean alive = true;
    obj_view myView;
    public boolean collidable = true;
    public int alphaCollisionthreshold = 0;
    static LinkedList<Obj> objs;
    boolean mouseInRegion;

    public Obj(double x, double y) {
        this.setupVariables(x, y);
        objs = Global.objs;
    }

    public abstract void update();

    public void mouseAction() {
    }

    public void mouseReleaseAction() {
    }

    public void keyReleased(int e) {
    }

    public void keyPressed(int e) {
    }

    public void mouseDraggedAction() {
    }

    public void destroy() {
        this.alive = false;
    }

    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public int compareTo(Obj o) {
        return o.getDepth() - this.depth;
    }

    public void setupVariables(double x, double y) {
        this.x = x;
        this.y = y;
        this.startX = x;
        this.startY = y;
        this.depth = 0;
        this.sprite = Global.spr_null;
        this.room_width = Global.room_width;
        this.room_height = Global.room_height;
        this.scale = Global.scale;
    }

    public void addObj(Obj o) {
        Global.objs.add(o);
    }

    public void addView(obj_view v) {
        Global.views.add(v);
    }

    public void room_restart() {
        Global.room.room_restart();
    }

    public void draw(Graphics2D g, AffineTransform affineTransform) {
        if (!this.draw) {
            return;
        }
        this.drawImage(g, affineTransform, this.x, this.y, this.sprite, this.image_angle);
    }

    public void drawImage(Graphics2D g, AffineTransform affineTransform, double x, double y, BufferedImage image, double pivotX, double pivotY, double angle) {
        AffineTransform newTransform = new AffineTransform();
        newTransform.setToTranslation(x - pivotX + affineTransform.getTranslateX(), y - pivotY + affineTransform.getTranslateY());
        if (angle != 0.0) {
            newTransform.rotate(Math.toRadians(-angle), pivotX, pivotY);
        }
        g.drawImage(image, newTransform, null);
    }

    public void drawImage(Graphics2D g, AffineTransform affineTransform, double x, double y, BufferedImage image, double angle) {
        this.drawImage(g, affineTransform, x, y, image, this.orginX, this.orginY, angle);
    }

    public void drawImage(Graphics2D g, AffineTransform affineTransform, double x, double y, BufferedImage image) {
        g.drawImage((Image)image, (int)(x + affineTransform.getTranslateX()), (int)(y + affineTransform.getTranslateY()), null);
    }

    public void drawText(Graphics2D g, AffineTransform affineTransform, double x, double y, BufferedImage textImage, String str) {
        str = str.toLowerCase();
        StringCharacterIterator it = new StringCharacterIterator(str);
        BufferedImage txt = textImage;
        int len = txt.getHeight();
        double xinc = this.ceil(1.125 * (double)len);
        char ch = it.first();
        while (ch != '\uffff') {
            if (ch == ' ') {
                x += xinc;
            } else {
                int index;
                switch (ch) {
                    case '.': {
                        index = 36;
                        break;
                    }
                    case '!': {
                        index = 37;
                        break;
                    }
                    case '?': {
                        index = 38;
                        break;
                    }
                    case ':': {
                        index = 39;
                        break;
                    }
                    case '}': {
                        index = 40;
                        break;
                    }
                    case '{': {
                        index = 41;
                        break;
                    }
                    case ')': {
                        index = 42;
                        break;
                    }
                    case '(': {
                        index = 43;
                        break;
                    }
                    case '=': {
                        index = 44;
                        break;
                    }
                    case '+': {
                        index = 45;
                        break;
                    }
                    case '-': {
                        index = 46;
                        break;
                    }
                    case '/': {
                        index = 47;
                        break;
                    }
                    case '\\': {
                        index = 48;
                        break;
                    }
                    case '*': {
                        index = 49;
                        break;
                    }
                    case '<': {
                        index = 50;
                        break;
                    }
                    case '>': {
                        index = 51;
                        break;
                    }
                    case '_': {
                        index = 52;
                        break;
                    }
                    case ';': {
                        index = 53;
                        break;
                    }
                    case ',': {
                        index = 54;
                        break;
                    }
                    case '\'': {
                        index = 55;
                        break;
                    }
                    case '\"': {
                        index = 56;
                        break;
                    }
                    default: {
                        index = Character.getNumericValue(ch);
                    }
                }
                int tempX = (int)(x + affineTransform.getTranslateX());
                int tempY = (int)(y + affineTransform.getTranslateY());
                g.drawImage(txt, tempX, tempY, tempX + len, tempY + len, index * len, 0, index * len + len, len, null);
                x += xinc;
            }
            ch = it.next();
        }
    }

    public void fillRect(Graphics2D g, AffineTransform affineTransform, double x, double y, int w, int h) {
        g.fillRect((int)(x + affineTransform.getTranslateX()), (int)(y + affineTransform.getTranslateY()), w, h);
    }

    public boolean mouseCollision(int mouseX, int mouseY) {
        if (!this.draw || !this.collidable) {
            return false;
        }
        mouseX = (int)((double)mouseX - (this.x - (double)this.orginX));
        mouseY = (int)((double)mouseY - (this.y - (double)this.orginY));
        return mouseX >= 0 && mouseY >= 0 && mouseX < this.sprite.getWidth() && mouseY < this.sprite.getHeight() && this.sprite.getRGB(mouseX, mouseY) >>> 24 > this.alphaCollisionthreshold;
    }

    public Obj instance_place(double x, double y, Class<?> class1) {
        for (Obj o : Global.objs) {
            if (!class1.isAssignableFrom(o.getClass()) || o == this || !o.collidable || !(o.x - (double)o.orginX < x - (double)this.orginX + (double)this.sprite.getWidth()) || !(o.x - (double)o.orginX + (double)o.sprite.getWidth() > x - (double)this.orginX) || !(o.y - (double)o.orginY < y - (double)this.orginY + (double)this.sprite.getHeight()) || !(o.y - (double)o.orginY + (double)o.sprite.getHeight() > y - (double)this.orginY)) continue;
            return o;
        }
        return null;
    }

    public void playSound(AudioClip sound) {
        sound.play();
    }

    public void playSoundLoop(AudioClip sound) {
        sound.loop();
    }

    public void stopSound(AudioClip sound) {
        sound.stop();
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean isVisible() {
        return this.draw;
    }

    public void setMouseInRegion(boolean in) {
        this.mouseInRegion = in;
    }
}

