/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class obj_npcTank
extends obj_tank {
    int[][] checkMap;
    LinkedList<Integer> directions;
    LinkedList<Integer> dirList;
    int maxDepth = Global.AILevel;
    int delay;
    BufferedImage bulletCollider;
    int oldHealth;

    public obj_npcTank(double x, double y, int player) {
        super(x, y, player);
        this.delay = player;
        this.oldHealth = this.myHealth;
        this.checkMap = new int[Global.mapW][Global.mapH];
        int c = 0;
        while (c < this.checkMap.length) {
            int r = 0;
            while (r < this.checkMap[0].length) {
                this.checkMap[c][r] = 0;
                ++r;
            }
            ++c;
        }
        this.directions = new LinkedList();
        this.dirList = new LinkedList();
        int i = 0;
        while (i < 4) {
            this.dirList.add(i);
            ++i;
        }
        this.bulletCollider = new BufferedImage(Global.scale * 3, Global.scale * 3, 6);
    }

    @Override
    public void update() {
        if (this.oldHealth > this.myHealth) {
            this.setCheckMap(this.x, this.y, -4);
        }
        if (this.oldHealth != this.myHealth) {
            this.oldHealth = this.myHealth;
        }
        if (this.delay > 0) {
            --this.delay;
        }
        if (this.dx == 0.0 && this.dy == 0.0 && this.delay == 0) {
            if (this.directions.isEmpty()) {
                this.addLowestNeighbor();
            }
            switch (this.directions.pop()) {
                case -1: {
                    break;
                }
                case 0: {
                    this.right = true;
                    break;
                }
                case 1: {
                    this.up = true;
                    break;
                }
                case 2: {
                    this.left = true;
                    break;
                }
                case 3: {
                    this.down = true;
                }
            }
        }
        if (this.lollygag > 190 * Global.fpsMult) {
            this.right = true;
            this.up = true;
            this.left = true;
            this.down = true;
        }
        super.update();
        this.right = false;
        this.up = false;
        this.left = false;
        this.down = false;
    }

    public void setCheckMap(double x, double y, int val) {
        int c = (int)x / Global.scale;
        c = (c + Global.scale * Global.mapW) % Global.mapW;
        int r = (int)y / Global.scale;
        r = (r + Global.scale * Global.mapH) % Global.mapH;
        this.checkMap[c][r] = val;
    }

    public int getCheckMap(double x, double y) {
        int c = (int)x / Global.scale;
        c = (c + Global.scale * Global.mapW) % Global.mapW;
        int r = (int)y / Global.scale;
        r = (r + Global.scale * Global.mapH) % Global.mapH;
        return this.checkMap[c][r];
    }

    public void addLowestNeighbor() {
        int dir = -1;
        int low = 0;
        boolean lowFound = false;
        if (this.random(8) < 1.0) {
            Collections.shuffle(this.dirList);
        }
        int c = 0;
        while (c < this.checkMap.length) {
            int r = 0;
            while (r < this.checkMap[0].length) {
                if (this.checkMap[c][r] >= 0) {
                    this.checkMap[c][r] = 0;
                } else {
                    int[] nArray = this.checkMap[c];
                    int n = r;
                    nArray[n] = nArray[n] + 1;
                }
                ++r;
            }
            ++c;
        }
        this.setCheckMap(this.x, this.y, 1);
        Iterator iterator = this.dirList.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            double dx = (double)Global.scale * this.cos((double)i * Math.PI / 2.0);
            double dy = (double)(-Global.scale) * this.sin((double)i * Math.PI / 2.0);
            this.setCheckMap(this.x + dx + 2.0, this.y + dy + 2.0, this.maxDepth + 1);
            int val = this.getValue(this.x + dx + 2.0, this.y + dy + 2.0, this.maxDepth - 1, (i + 2) % 4);
            if (val >= low && lowFound) continue;
            dir = i;
            low = val;
            lowFound = true;
        }
        this.directions.add(dir);
    }

    public int getValue(double x, double y, int depth, int dir) {
        switch (this.getMap(x, y)) {
            case 1: {
                return 1000000 + depth;
            }
            case 2: {
                return -100 - depth;
            }
        }
        int low = 10000;
        obj_tank t = (obj_tank)this.instance_place(x, y, obj_tank.class);
        if (t != null && this.invincibleTime <= 0 && (this.myDamage > 20 || this.maxDepth - depth < 2) && t.image_angle % 90.0 != (double)dir) {
            if (t.myDamage < this.myDamage || t.myDamage == this.myDamage && t.myHealth < this.myHealth) {
                return -300 - depth;
            }
            return -30 - depth;
        }
        obj_bullet b = (obj_bullet)this.instance_place(x, y, obj_bullet.class);
        if (b != null && b.myShooter == this) {
            b = (obj_bullet)b.instance_place(x, y, obj_bullet.class);
        }
        if (b != null && b.myShooter != this) {
            this.setCheckMap(x, y, -5);
            return 10000000 + depth;
        }
        if (depth > 0) {
            Iterator iterator = this.dirList.iterator();
            while (iterator.hasNext()) {
                double dy;
                int i = (Integer)iterator.next();
                double dx = (double)this.scale * this.cos((double)i * Math.PI / 2.0);
                int check = this.getCheckMap(x + dx, y + (dy = (double)(-this.scale) * this.sin((double)i * Math.PI / 2.0)));
                if (check >= depth || check < 0) continue;
                this.setCheckMap(x + dx, y + dy, depth);
                low = this.min(this.getValue(x + dx, y + dy, depth - 1, dir), low);
            }
        }
        return low;
    }
}

