/*
 * Decompiled with CFR 0.152.
 */
package BryceGraphs.Algorithms;

import BryceGraphs.ADTs.Serials.SerialAdjacencyNode;
import BryceGraphs.Algorithms.GraphSearch;
import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.UBA;
import java.io.PrintStream;
import java.util.Iterator;
import util.interfaces.Consumer1;
import util.interfaces.Consumer2;
import util.interfaces.Function;

public class GraphSerial {
    public static <Node extends SerialAdjacencyNode<Node>> void serialize(PrintStream stream, Node root) {
        GraphSerial.serialize(stream, root, null);
    }

    public static <Node extends SerialAdjacencyNode<Node>> void serialize(PrintStream stream, Node root, Consumer2<Node, PrintStream> continuation) {
        Serialize writing = new Serialize(stream, continuation);
        GraphSearch.BFS(root, writing);
        stream.println("GRAPH END");
    }

    public static <Node extends SerialAdjacencyNode<Node>> Node deserialize(Iterator<String> data_iter, Function<Iterator<String>, Node> producer) {
        if (!data_iter.hasNext()) {
            throw new Error("Input Data has ended. Check for blank input.");
        }
        UBA vertices = new UBA();
        UBA<int[]> edges = new UBA<int[]>();
        GraphSerial.populateAbstractGraph(data_iter, producer, vertices, edges);
        return (Node)GraphSerial.linkNodes(vertices, edges);
    }

    private static <Node extends SerialAdjacencyNode<Node>> void populateAbstractGraph(Iterator<String> iter2, Function<Iterator<String>, Node> producer, UBA<Node> vertices, UBA<int[]> edges) {
        while (iter2.hasNext()) {
            String s = iter2.next();
            if (s.equals("GRAPH END")) break;
            int index = new Integer(s);
            vertices.fillToIndex(index);
            edges.fillToIndex(index);
            int edge_num = new Integer(iter2.next());
            int[] edge_indices = new int[edge_num];
            int i = 0;
            while (i < edge_num) {
                edge_indices[i] = new Integer(iter2.next());
                ++i;
            }
            edges.set(index, edge_indices);
            SerialAdjacencyNode node = (SerialAdjacencyNode)producer.eval(iter2);
            vertices.set(index, node);
        }
    }

    private static <Node extends SerialAdjacencyNode<Node>> Node linkNodes(UBA<Node> vertices, UBA<int[]> edges) {
        int len = vertices.size();
        int i = 0;
        while (i < len) {
            SerialAdjacencyNode node = (SerialAdjacencyNode)vertices.get(i);
            int[] neighbor_indices = edges.get(i);
            int num_neighbors = neighbor_indices.length;
            if (num_neighbors != 0) {
                UBA<SerialAdjacencyNode> neighbors = new UBA<SerialAdjacencyNode>(num_neighbors);
                int n = 0;
                while (n < num_neighbors) {
                    neighbors.add((SerialAdjacencyNode)vertices.get(neighbor_indices[n]));
                    ++n;
                }
                node.setNeighbors(neighbors);
            }
            ++i;
        }
        return (Node)((SerialAdjacencyNode)vertices.get(0));
    }

    private static class Serialize<Node extends SerialAdjacencyNode<Node>>
    implements Consumer1<Node> {
        int next_index = 0;
        final AArray<Node, Integer> indices = new AArray(10);
        final PrintStream outputStream;
        final Consumer2<Node, PrintStream> continuation;

        private Serialize(PrintStream stream, Consumer2<Node, PrintStream> cont) {
            this.outputStream = stream;
            this.continuation = cont;
        }

        @Override
        public void eval(Node input) {
            this.ensureIndex(input);
            int index = this.indices.lookup(input);
            this.write(index);
            this.write(input.getNeighborSize());
            Iterable neighbors = input.getNeighbors();
            for (SerialAdjacencyNode node : neighbors) {
                this.ensureIndex(node);
                index = this.indices.lookup(node);
                this.write(index);
            }
            input.serializeTo(this.outputStream);
            if (this.continuation != null) {
                this.continuation.eval(input, this.outputStream);
            }
        }

        private void ensureIndex(Node node) {
            if (this.indices.contains_key(node)) {
                return;
            }
            this.indices.insert(node, this.next_index);
            ++this.next_index;
        }

        private void write(Object o) {
            this.outputStream.println(o.toString());
        }
    }
}

