/*
 * Decompiled with CFR 0.152.
 */
package BryceGraphs.gui_components;

import BryceGraphs.ADTs.GNode;
import BryceGraphs.ADTs.Serials.SerialAdjacencyNode;
import BryceMath.Geometry.Rectangle;
import Data_Structures.ADTs.Bunch2;
import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.HashingClasses.Dict;
import Data_Structures.Structures.InDevelopment.Trees.AVL;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.Components.Input.gui_booleanInput;
import Game_Engine.GUI.Components.large.gui_dragWindow;
import Game_Engine.GUI.Components.small.gui_label;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.PrintStream;

public class gui_GNode
extends gui_dragWindow
implements SerialAdjacencyNode<gui_GNode>,
Comparable<Obj> {
    GNode myGNode;
    final int ROW_H = 48;
    AArray<GNode, gui_GNode> children = new AArray();
    AVL<Obj> children_ordered = new AVL();
    protected int Y_MAX = 0;
    protected int X_MAX = 0;

    public gui_GNode(double x, double y, int w, int h) {
        super(x, y, w, h);
    }

    public gui_GNode(Rectangle screen) {
        super(screen);
    }

    public void setNode(GNode node) {
        this.myGNode = node;
        this.children.clear();
        this.children_ordered = new AVL();
        this.populateField(node);
        this.window.scrollH(this.X_MAX);
        this.window.scrollV(this.Y_MAX);
        this.setHandleText(node.getGNodeName());
        this.handle.setCollidable(false);
        this.handle.setDrawBorders(true);
    }

    protected void populateField(GNode node) {
        Dict<Object> map = new Dict<Object>();
        node.getGNodeData(map);
        this.createRows(map.getPairs());
    }

    private void createRows(List<Bunch2<String, Object>> data) {
        this.X_MAX = 0;
        this.Y_MAX = 0;
        for (Bunch2<String, Object> p : data) {
            gui_label key = new gui_label(0.0, this.Y_MAX, 0, 48);
            key.setText(p.getKey());
            key.fitToContents();
            this.add(key);
            Rectangle val_label_bounds = new Rectangle((int)key.getX2(), this.Y_MAX, 0, 48);
            Object val = p.getVal();
            gui_label val_label = this.chooseProperLabel(val, val_label_bounds);
            val_label.fitToContents();
            this.add(val_label);
            this.X_MAX = (int)Math.max((double)this.X_MAX, val_label.getX2());
            this.Y_MAX += 48;
        }
    }

    protected gui_label chooseProperLabel(Object val, Rectangle val_label_bounds) {
        gui_label val_label;
        String val_str;
        if (val instanceof GNode) {
            GNode node = (GNode)val;
            val_str = node.getGNodeName();
            this.children.insert(node, null);
            val_label = new expandButton(val_label_bounds, node);
        } else {
            val_label = new gui_label(val_label_bounds);
            val_str = val.toString();
        }
        val_label.setText(val_str);
        return val_label;
    }

    public void propogateNodes() {
        this.expandNode();
        for (Obj node_o : this.children_ordered) {
            if (node_o == null) continue;
            gui_GNode node = (gui_GNode)node_o;
            node.propogateNodes();
        }
    }

    public void expandNode() {
        List<GNode> nodes = this.children.getKeys();
        for (GNode n : nodes) {
            this.expandNode(n);
        }
    }

    public void contractNode() {
        List<GNode> nodes = this.children.getKeys();
        this.contractNode(nodes);
    }

    public void contractNode(List<GNode> nodes) {
        for (GNode n : nodes) {
            this.contractNode(n);
        }
    }

    private void expandNode(GNode node) {
        gui_GNode val = this.children.lookup(node);
        if (val != null) {
            return;
        }
        val = this.I_CHILD_NODE(node);
        this.children.insert(node, val);
        this.children_ordered.add(val);
    }

    private void contractNode(GNode node) {
        gui_GNode val = this.children.lookup(node);
        if (val == null) {
            return;
        }
        val.contractNode();
        this.children_ordered.remove(val);
        val.kill();
        this.children.remove_key(node);
    }

    public void fixHeight() {
        List L = new List();
        IterB<gui_GNode> iter2 = L.getIter();
        iter2.insertAfter(null);
        this.horizontalAlign(iter2, 0.0);
    }

    private void horizontalAlign(IterB<gui_GNode> iter2, double min_y) {
        boolean hasChildren;
        Obj o = iter2.current();
        if (o == null) {
            this.setY(min_y);
        } else {
            this.setY(Math.max(o.getY2(), min_y));
        }
        iter2.replace(this);
        int child_num = this.children_ordered.size();
        boolean bl = hasChildren = child_num != 0;
        if (hasChildren) {
            if (!iter2.hasNext()) {
                iter2.insertAfter(null);
            } else {
                iter2.next();
            }
            int h = this.getH();
            min_y = this.getY() + (double)(h / 2) - (double)(h * child_num / 2);
            min_y = Math.max(0.0, min_y);
            for (Obj child_o : this.children_ordered) {
                gui_GNode child = (gui_GNode)child_o;
                if (child == null) continue;
                child.horizontalAlign(iter2, min_y);
            }
            Obj first_child = (Obj)this.children_ordered.getFirst();
            this.setY((first_child.getY() + iter2.current().getY()) / 2.0);
            iter2.previous();
        }
    }

    private gui_GNode I_CHILD_NODE(GNode node) {
        int w = this.getW();
        int h = this.getH();
        double x = this.getX2() + 64.0;
        double y = -h;
        gui_GNode output = this.I_NODE_TYPE(x, y, w, h);
        this.myContainer.obj_create((Obj)output);
        output.setNode(node);
        return output;
    }

    protected gui_GNode I_NODE_TYPE(double x, double y, int w, int h) {
        return new gui_GNode(x, y, w, h);
    }

    @Override
    public int compareTo(Obj o) {
        if (this.getY() < o.getY()) {
            return -1;
        }
        if (this.getY() > o.getY()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void draw(ImageB image, AffineTransform AT) {
        super.draw(image, AT);
        double x = this.getX2();
        double y = (this.getY() + this.getY2()) / 2.0;
        List<gui_GNode> childs = this.children.getValues();
        Graphics2D g = image.getGraphics();
        g.setColor(Color.BLACK);
        for (gui_GNode child : childs) {
            if (child == null) continue;
            double x2 = child.getX();
            double y2 = (child.getY() + child.getY2()) / 2.0;
            this.drawLine(g, AT, x, y, x2, y2);
        }
        g.dispose();
    }

    @Override
    public Iterable<gui_GNode> getNeighbors() {
        List<gui_GNode> output = this.children.getValues().removeNulls();
        return output;
    }

    @Override
    public int getNeighborSize() {
        return this.children.size();
    }

    @Override
    public void setNeighbors(Iterable<gui_GNode> neighbors) {
        this.children.clear();
        this.children_ordered = new AVL();
        for (gui_GNode node : neighbors) {
            this.children.insert(node.getGNode(), node);
            this.children_ordered.add(node);
        }
    }

    public GNode getGNode() {
        return this.myGNode;
    }

    @Override
    public void serializeTo(PrintStream stream) {
        this.myGNode.serializeTo(stream);
    }

    @Override
    public String getSerialName() {
        return "gui_GNode";
    }

    protected class expandButton
    extends gui_booleanInput {
        private GNode child;

        public expandButton(Rectangle r, GNode node) {
            super(r);
            this.child = node;
        }

        @Override
        public void update() {
            super.update();
            this.setText(this.child.getGNodeName());
            this.fitToContents();
            if (this.input_changed()) {
                if (this.query()) {
                    gui_GNode.this.expandNode(this.child);
                } else {
                    gui_GNode.this.contractNode(this.child);
                }
                return;
            }
        }
    }
}

