/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching;

import BryceImages.ColorCalculators.RayMarching.Vector;
import java.awt.Color;
import java.util.Random;

public class BryceMath {
    Random random = new Random();
    public final long mySeed = (long)this.random(Integer.MAX_VALUE);
    public static final double pi = Math.PI;
    static final double e = Math.E;

    public static Vector v(double x, double y, double z) {
        return new Vector(x, y, z);
    }

    public static Vector v(double x, double y) {
        return new Vector(x, y);
    }

    public static double degToRad(double degrees) {
        return Math.toRadians(degrees);
    }

    public static double radToDeg(double radians) {
        return Math.toDegrees(radians);
    }

    public static double cos(double input) {
        return Math.cos(input);
    }

    public static double arcCos(double input) {
        return Math.acos(input);
    }

    public static double sin(double input) {
        return Math.sin(input);
    }

    public static double arcSin(double input) {
        return Math.asin(input);
    }

    public static double tan(double input) {
        return Math.tan(input);
    }

    public static double arcTan(double input) {
        return Math.atan(input);
    }

    public static double ln(double input) {
        return Math.log(input);
    }

    public double log10(double input) {
        return Math.log10(input);
    }

    public static double logA(double input, int base) {
        return BryceMath.ln(input) / BryceMath.ln(base);
    }

    public static double sqrt(double input) {
        return Math.sqrt(input);
    }

    public static double sqr(double input) {
        return input * input;
    }

    public static double pow(double number, double p) {
        return Math.pow(number, p);
    }

    public static double pow(double number, int p) {
        double output = number;
        int i = 0;
        while (i < p) {
            output *= number;
            ++i;
        }
        return output;
    }

    public static int pow(int number, int p) {
        int output = number;
        int i = 0;
        while (i < p) {
            output *= number;
            ++i;
        }
        return output;
    }

    public double random() {
        return this.random.nextDouble();
    }

    public double random(int n) {
        return (double)n * this.random.nextDouble();
    }

    public double random(double n) {
        return n * this.random.nextDouble();
    }

    public double random(int f, int l) {
        return (double)(l - f) * this.random.nextDouble() + (double)f;
    }

    public void random_set_seed() {
        this.random.setSeed(this.mySeed);
    }

    public void random_set_seed(int seed) {
        this.random.setSeed(seed);
    }

    public static int round(double n) {
        return (int)Math.round(n);
    }

    public static int ceil(double n) {
        return (int)Math.ceil(n);
    }

    public static int floor(double n) {
        return (int)Math.floor(n);
    }

    public static double max(double n1, double n2) {
        return Math.max(n1, n2);
    }

    public static double min(double n1, double n2) {
        return Math.min(n1, n2);
    }

    public static int max(int n1, int n2) {
        return Math.max(n1, n2);
    }

    public static int min(int n1, int n2) {
        return Math.min(n1, n2);
    }

    public static double bound(double in, double min, double max) {
        return BryceMath.max(min, BryceMath.min(in, max));
    }

    public static int sign(double in) {
        if (in < 0.0) {
            return -1;
        }
        if (in > 0.0) {
            return 1;
        }
        return 0;
    }

    public static double sqrDistance(double x1, double y1, double x2, double y2) {
        return BryceMath.sqr(x1 - x2) + BryceMath.sqr(y1 - y2);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return BryceMath.sqrt(BryceMath.sqrDistance(x1, y1, x2, y2));
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BryceMath.sqrt(BryceMath.sqr(x1 - x2) + BryceMath.sqr(y1 - y2) + BryceMath.sqr(z1 - z2));
    }

    public static double sqrDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BryceMath.sqr(x1 - x2) + BryceMath.sqr(y1 - y2) + BryceMath.sqr(z1 - z2);
    }

    public static int abs(int n) {
        if (n < 0) {
            n *= -1;
        }
        return n;
    }

    public static double abs(double n) {
        if (n < 0.0) {
            n *= -1.0;
        }
        return n;
    }

    public static Color weightedAverageColor(Color c1, Color c2, double pC2) {
        double pC1 = 1.0 - pC2;
        double red = (double)c1.getRed() * pC1 + (double)c2.getRed() * pC2;
        double green = (double)c1.getGreen() * pC1 + (double)c2.getGreen() * pC2;
        double blue = (double)c1.getBlue() * pC1 + (double)c2.getBlue() * pC2;
        double alpha = (double)c1.getAlpha() * pC1 + (double)c2.getAlpha() * pC2;
        return new Color((int)red, (int)green, (int)blue, (int)alpha);
    }

    public static Color Color_rgb(double r, double g, double b, double alpha) {
        Color temp = BryceMath.Color_rgb(r, g, b);
        return new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), (int)alpha);
    }

    public static Color Color_rgb(double red, double green, double blue) {
        if ((red %= 256.0) < 0.0) {
            red += 256.0;
        }
        if ((green %= 256.0) < 0.0) {
            green += 256.0;
        }
        if ((blue %= 256.0) < 0.0) {
            blue += 256.0;
        }
        return new Color((int)red, (int)green, (int)blue);
    }

    public static Color Color_hsv(double h, double s, double v, double alpha) {
        Color temp = BryceMath.Color_hsv(h, s, v);
        return new Color(temp.getRed(), temp.getGreen(), temp.getBlue(), (int)alpha);
    }

    public static Color Color_hsv(double h, double s, double v) {
        double b;
        double g;
        double r;
        if ((h %= 360.0) < 0.0) {
            h += 360.0;
        }
        if ((s %= 101.0) < 0.0) {
            s += 101.0;
        }
        if ((v %= 101.0) < 0.0) {
            v += 101.0;
        }
        h = BryceMath.min(h, 360.0);
        s = BryceMath.min(s, 100.0);
        v = BryceMath.min(v, 100.0);
        v /= 100.0;
        if ((s /= 100.0) == 0.0) {
            double b2;
            double g2 = b2 = v;
            double r2 = b2;
            return new Color(BryceMath.round(r2 * 255.0), BryceMath.round(g2 * 255.0), BryceMath.round(b2 * 255.0));
        }
        int i = BryceMath.floor(h /= 60.0);
        double f = h - (double)i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - s * f);
        double t = v * (1.0 - s * (1.0 - f));
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new Color(BryceMath.round(r * 255.0), BryceMath.round(g * 255.0), BryceMath.round(b * 255.0));
    }

    public static boolean circleOutline(double x, double y, double cX, double cY, double radius, double thickness) {
        if (BryceMath.abs(cX - x) > radius || BryceMath.abs(cY - y) > radius) {
            return false;
        }
        double tempDist = BryceMath.distance(x, y, cX, cY);
        return tempDist < radius && tempDist > radius - thickness;
    }

    public static boolean circle(double x, double y, double cX, double cY, double radius) {
        if (BryceMath.abs(cX - x) > radius || BryceMath.abs(cY - y) > radius) {
            return false;
        }
        double tempDist = BryceMath.sqrDistance(x, y, cX, cY);
        return tempDist < radius * radius;
    }

    public static boolean ellipse(double x, double y, double cX, double cY, double width, double height) {
        return BryceMath.circle((x - cX) / width * height + cX, y, cX, cY, height);
    }

    public static boolean sector(double x, double y, double cX, double cY, double radius, double thickness, double angleMin, double angleMax) {
        if (BryceMath.circleOutline(x, y, cX, cY, radius, thickness)) {
            double tAngle = BryceMath.lineAngle(x, y, cX, cY);
            if (angleMin < 0.0) {
                tAngle -= angleMin;
                tAngle %= 360.0;
                angleMax -= angleMin;
                angleMin = 0.0;
            }
            if (tAngle >= angleMin && tAngle <= angleMax) {
                return true;
            }
        }
        return false;
    }

    public static double lineAngle(double x, double y, double focusX, double focusY) {
        return (BryceMath.radToDeg(Math.atan2(x - focusX, y - focusY)) + 270.0) % 360.0;
    }

    public static double lineAngle2(double x, double y, double focusX, double focusY) {
        return BryceMath.radToDeg(Math.atan2(y - focusY, x - focusX));
    }

    public static boolean line(double x, double y, double a, double b, double thickness) {
        return y > a * x + b - thickness && y < a * x + b + thickness;
    }

    public static boolean rectangle(double x, double y, double x1, double x2, double y1, double y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static boolean rectangle2(double x, double y, double x1, double y1, double width, double height) {
        double x2 = x1 + width;
        double y2 = y1 + height;
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static boolean inTile(double x, double y, double tW, double tH, double cS, double oS) {
        double tileW = tW;
        double offSet = oS;
        double tempX = x % (tileW + offSet);
        double tileH = tH;
        double tempY = y % (tileH + offSet);
        double curveSize = cS;
        return BryceMath.rectangle(tempX, tempY, 0.0, tileW, curveSize, tileH - curveSize) || BryceMath.rectangle(tempX, tempY, curveSize, tileW - curveSize, 0.0, tileH) || BryceMath.circle(tempX, tempY, curveSize, curveSize, curveSize) || BryceMath.circle(tempX, tempY, tileW - curveSize, curveSize, curveSize) || BryceMath.circle(tempX, tempY, tileW - curveSize, tileH - curveSize, curveSize) || BryceMath.circle(tempX, tempY, curveSize, tileH - curveSize, curveSize);
    }
}

