/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching.Geometries;

import BryceImages.ColorCalculators.RayMarching.Geometry;
import BryceImages.ColorCalculators.RayMarching.Vector;

public class geom_simpleCurve
extends Geometry {
    Vector z;
    double radius;
    double thickness;
    double angle1;
    double angle2;
    int axis = 2;

    public geom_simpleCurve(Vector z, double r, double thickness, Vector normal, double angle1, double angle2) {
        this.z = z;
        this.radius = r;
        this.thickness = thickness;
        this.createCoordinateSystem(normal);
        this.angle1 = geom_simpleCurve.degToRad(angle1);
        this.angle2 = geom_simpleCurve.degToRad(angle2);
    }

    public geom_simpleCurve(Vector z, double r, double thickness, Vector normal, Vector u, double angle1, double angle2) {
        this.z = z;
        this.radius = r;
        this.thickness = thickness;
        this.n = this.n.norm();
        this.u = u.norm();
        this.v = this.u.cross(this.n);
        this.angle1 = geom_simpleCurve.degToRad(angle1);
        this.angle2 = geom_simpleCurve.degToRad(angle2);
    }

    @Override
    public double DE(Vector zz) {
        boolean check;
        double vComp;
        Vector diff = zz.sub(this.z);
        double uComp = this.getComponent(diff, this.u);
        double angle = geom_simpleCurve.lineAngle2(uComp, vComp = this.getComponent(diff, this.v), 0.0, 0.0);
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (this.angle1 < 0.0 && angle > 180.0) {
            angle -= 360.0;
        }
        boolean bl = check = (angle = geom_simpleCurve.degToRad(angle)) >= this.angle2 || angle <= this.angle1;
        if (check) {
            return geom_simpleCurve.min(this.torus(zz, this.angle1), this.torus(zz, this.angle2));
        }
        return this.torus(zz, angle);
    }

    private double torus(Vector zz, double angle) {
        Vector nearest = this.z.add(this.u.mult(this.radius * geom_simpleCurve.cos(angle))).add(this.v.mult(this.radius * geom_simpleCurve.sin(angle)));
        return geom_simpleCurve.abs(nearest.sub(zz).mag() - this.thickness);
    }
}

