/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching;

import BryceImages.ColorCalculators.RayMarching.BryceMath;
import BryceImages.ColorCalculators.RayMarching.Geometry;
import BryceImages.ColorCalculators.RayMarching.Vector;
import BryceImages.Rendering.ColorCalculator;
import Data_Structures.Structures.List;
import java.awt.Color;
import java.awt.Dimension;
import java.util.LinkedList;

public abstract class PhongLighted3dPicture
extends ColorCalculator {
    public static double prescision = 1.0E-4;
    protected Vector CameraZ = new Vector(0.0, 0.0, -15.0);
    protected Vector CameraFocus = new Vector(0.0, 0.0, 0.0);
    protected double CameraDepth = 3.0;
    protected int reflectionDepth = 3;
    protected Vector up = new Vector(0.0, 0.0, -1.0);
    protected Vector[] lights;
    protected List<Geometry> geoms = new List();
    protected List<Geometry> geoms_start = new List();
    LinkedList<Geometry> antigeoms = new LinkedList();
    protected double defaultRefelectivity = 0.5;
    Geometry tempGeomPointer;
    Vector i;
    Vector j;
    Vector k;

    public PhongLighted3dPicture(Dimension tempDim) {
        super(tempDim);
        this.lights = new Vector[2];
        this.lights[0] = new Vector(5.0, 5.0, 3.0);
        this.lights[1] = new Vector(-5.0, -5.0, 3.0);
        this.loadGeoms();
        this.createCoordinateSystem();
    }

    @Override
    public Object clone() {
        PhongLighted3dPicture p = (PhongLighted3dPicture)super.clone();
        p.geoms = new List();
        p.geoms_start = new List();
        p.antigeoms = new LinkedList();
        p.loadGeoms();
        p.createCoordinateSystem();
        return p;
    }

    public void createCoordinateSystem() {
        this.k = this.CameraFocus.sub(this.CameraZ);
        this.k = this.k.norm();
        this.j = this.up;
        this.j = this.j.sub(this.k.mult(this.j.dot(this.k)));
        this.j = this.j.norm();
        this.i = this.j.cross(this.k);
    }

    @Override
    public Color getColor(double x, double y) {
        int factor = BryceMath.min(this.room_width, this.room_height);
        Vector dz = this.i.mult((x -= (double)(this.room_width / 2)) / (double)factor).add(this.j.mult((y -= (double)(this.room_height / 2)) / (double)factor)).add(this.k.mult(this.CameraDepth));
        dz = dz.norm();
        Vector z = this.CameraZ;
        if ((z = this.pick(z, dz)) == null) {
            return PhongLighted3dPicture.Color_hsv(0.0, 0.0, 0.0, 0.0);
        }
        return this.calculateColor(z, dz, this.reflectionDepth);
    }

    public Color calculateColor(Vector z, Vector dz, int recursion) {
        double finalLighting = 0.0;
        double finalPhong = 0.0;
        Geometry geomPointer = null;
        if (this.tempGeomPointer != null) {
            geomPointer = this.tempGeomPointer;
        }
        Vector normal = this.computeNormal(z, 1.0E-7);
        dz = dz.reflection(normal);
        Vector zi = z;
        Vector dzi = dz;
        Vector[] vectorArray = this.lights;
        int n = this.lights.length;
        int n2 = 0;
        while (n2 < n) {
            Vector Light1 = vectorArray[n2];
            z = zi;
            dz = dzi;
            double lighting = this.light(z, Light1);
            double phong = 0.0;
            if (lighting != 0.0) {
                double phongThresh;
                Vector lightToSurface = Light1.sub(z);
                Vector lightToSurface_norm = lightToSurface.norm();
                phong = dz.dot(lightToSurface_norm);
                phong = (phong /= Math.max(1.0, lightToSurface.mag() / 10.0)) > (phongThresh = 0.95) ? (phong - phongThresh) * 1.0 / (1.0 - phongThresh) : 0.0;
            }
            lighting = BryceMath.min(lighting + 0.2, 1.0);
            finalLighting = BryceMath.min(1.0, lighting + finalLighting);
            finalPhong = BryceMath.max(finalPhong, phong);
            ++n2;
        }
        Color output = geomPointer != null ? this.weightedAverageColor(geomPointer.getColor(z, finalLighting), Color.white, finalPhong) : this.weightedAverageColor(this.getColor(z, finalLighting), Color.white, finalPhong);
        if (BryceMath.sign(dz.dot(normal)) >= 0) {
            z = this.deCollide(z, dz);
        }
        if ((z = this.pick(z, dz)) != null && recursion > 0) {
            if (geomPointer != null) {
                if (geomPointer.reflectivity() > 0.0) {
                    output = this.weightedAverageColor(output, this.calculateColor(z, dz, recursion - 1), geomPointer.reflectivity());
                }
            } else {
                output = this.weightedAverageColor(output, this.calculateColor(z, dz, recursion - 1), this.defaultRefelectivity);
            }
        }
        return output;
    }

    @Override
    public Color weightedAverageColor(Color c1, Color c2, double pC2) {
        double pC1 = 1.0 - pC2;
        double red = (double)c1.getRed() * pC1 + (double)c2.getRed() * pC2;
        double green = (double)c1.getGreen() * pC1 + (double)c2.getGreen() * pC2;
        double blue = (double)c1.getBlue() * pC1 + (double)c2.getBlue() * pC2;
        return new Color((int)red, (int)green, (int)blue);
    }

    public abstract Color getColor(Vector var1, double var2);

    public abstract boolean withinBounds(Vector var1);

    private double light(Vector z, Vector l) {
        double e = 1.0E-9;
        Vector normal = this.computeNormal(z, e);
        Vector dz = l.sub(z).norm();
        double distToLight = z.sub(l).mag();
        Vector previousZ = z;
        if (BryceMath.sign(dz.dot(normal)) < 0) {
            return 0.0;
        }
        z = this.deCollide(z, dz);
        z = this.pick(z, dz);
        double dotProduct = z == null || z.sub(previousZ).mag() > distToLight ? BryceMath.abs(dz.dot(normal)) : 0.0;
        return dotProduct * l.val;
    }

    private Vector deCollide(Vector z, Vector dz) {
        double temp;
        while (!((temp = this.DE(z)) > prescision)) {
            z = this.march(z, dz, Math.max(temp, prescision));
        }
        return z;
    }

    private Vector pick(Vector z, Vector dz) {
        this.optimizeGeomList(z);
        double distGone = 0.0;
        while (this.withinBounds(z)) {
            double minStepSize;
            double minDist = Double.MAX_VALUE;
            this.tempGeomPointer = this.geoms.getFirst();
            this.geoms.sort();
            boolean flag = false;
            for (Geometry i : this.geoms) {
                if (i.minDist > distGone + 3.0 * minDist) {
                    if (flag) continue;
                    flag = true;
                    continue;
                }
                double tempDist = i.DE(z, dz);
                i.minDist = tempDist + distGone;
                i.distChanged = true;
                if (!(tempDist < minDist)) continue;
                minDist = tempDist;
                this.tempGeomPointer = i;
            }
            if (this.geoms.getFirst() == null) {
                minDist = this.DE(z, dz);
            }
            if ((minStepSize = minDist) < prescision) {
                if (minStepSize < 1.0E-6) {
                    z = this.march(z, dz, -1.0E-5);
                }
                return z;
            }
            z = this.march(z, dz, minStepSize);
            distGone += minStepSize + 1.0E-5;
        }
        return null;
    }

    public void optimizeGeomList(Vector z) {
        if (this.geoms.getFirst() == null) {
            return;
        }
        if (z.equals(this.CameraZ)) {
            if (this.geoms.getFirst().startDist < 0.0) {
                for (Geometry g : this.geoms) {
                    g.minDist = g.startDist = g.DE(z);
                }
                this.geoms.sort();
            }
            for (Geometry g : this.geoms) {
                g.minDist = g.startDist;
            }
            return;
        }
        for (Geometry g : this.geoms) {
            g.minDist = g.DE(z);
        }
    }

    private Vector march(Vector z, Vector dz, double distance) {
        return z.add(dz.mult(distance));
    }

    protected Vector computeNormal(Vector z, double e) {
        Vector out = new Vector(0.0, 0.0, 0.0);
        if (this.tempGeomPointer != null) {
            double d1 = this.DE(new Vector(z.x + e, z.y, z.z));
            double d2 = this.tempGeomPointer.DE(new Vector(z.x - e, z.y, z.z));
            out.x = (d1 - d2) / (2.0 * e);
            d1 = this.tempGeomPointer.DE(new Vector(z.x, z.y + e, z.z));
            d2 = this.tempGeomPointer.DE(new Vector(z.x, z.y - e, z.z));
            out.y = (d1 - d2) / (2.0 * e);
            d1 = this.tempGeomPointer.DE(new Vector(z.x, z.y, z.z + e));
            d2 = this.tempGeomPointer.DE(new Vector(z.x, z.y, z.z - e));
            out.z = (d1 - d2) / (2.0 * e);
        } else {
            double d1 = this.DE(new Vector(z.x + e, z.y, z.z));
            double d2 = this.DE(new Vector(z.x - e, z.y, z.z));
            out.x = (d1 - d2) / (2.0 * e);
            d1 = this.DE(new Vector(z.x, z.y + e, z.z));
            d2 = this.DE(new Vector(z.x, z.y - e, z.z));
            out.y = (d1 - d2) / (2.0 * e);
            d1 = this.DE(new Vector(z.x, z.y, z.z + e));
            d2 = this.DE(new Vector(z.x, z.y, z.z - e));
            out.z = (d1 - d2) / (2.0 * e);
        }
        return out.norm();
    }

    public abstract void loadGeoms();

    public double DE(Vector z) {
        double minDist = Double.MAX_VALUE;
        this.tempGeomPointer = this.geoms.getFirst();
        for (Geometry i : this.geoms) {
            double tempDist = i.DE(z);
            if (!(tempDist < minDist)) continue;
            minDist = tempDist;
            this.tempGeomPointer = i;
        }
        return minDist;
    }

    public double DE(Vector z, Vector dz) {
        double tempDist;
        double minDist = Double.MAX_VALUE;
        this.tempGeomPointer = this.geoms.getFirst();
        for (Geometry i : this.geoms) {
            tempDist = i.DE(z, dz);
            if (!(tempDist < minDist)) continue;
            minDist = tempDist;
            this.tempGeomPointer = i;
        }
        if (!this.antigeoms.isEmpty()) {
            for (Geometry i : this.antigeoms) {
                tempDist = i.DE(z, dz);
                minDist = BryceMath.max(minDist, tempDist);
            }
        }
        return minDist;
    }
}

