/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators;

import BryceImages.ColorCalculators.RayMarching.BryceMath;
import BryceImages.Rendering.ColorCalculator;
import java.awt.Color;
import java.awt.Dimension;

public class ccMandelbrot
extends ColorCalculator {
    Dimension dim;
    public long mySeed;
    int P = 2;
    int max_iteration = 20272;
    double startX;
    double startY;
    double endX;
    double endY;
    public static int minIterations = 300;

    public ccMandelbrot(Dimension tempDim) {
        super(tempDim);
        this.setupCamera();
        this.antiAliasing = 3;
    }

    public void setupCamera() {
        this.startX = -2.0;
        this.startY = -1.15;
        this.endX = 0.5;
        this.endY = 1.15;
    }

    @Override
    public Color getColor(double c, double r) {
        double x0 = this.startX + c / (double)(this.room_width - 1) * (this.endX - this.startX);
        double y0 = this.startY + r / (double)(this.room_height - 1) * (this.endY - this.startY);
        double x = 0.0;
        double y = 0.0;
        int iteration = 0;
        boolean escaped = false;
        int exInter = 0;
        while (exInter < 6) {
            double xtemp = x * x - y * y + x0;
            y = (double)this.P * x * y + y0;
            x = xtemp;
            if (!(escaped || x * x + y * y <= 4.0 && ++iteration < this.max_iteration)) {
                escaped = true;
                continue;
            }
            if (!escaped) continue;
            ++exInter;
        }
        if (iteration >= this.max_iteration) {
            return Color.white;
        }
        int n = iteration;
        double v = (double)(n + 1) - Math.log10(Math.log10(BryceMath.distance(0.0, 0.0, x, y))) / Math.log10(2.0);
        double hue = -100.0 * Math.log(8.0 + v - 0.0);
        double val = BryceMath.bound(100.0 - (400.0 + hue), 0.0, 100.0);
        return ccMandelbrot.Color_hsv(0.0, 0.0, 100.0, val);
    }
}

