/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.Engines;

import BryceImages.Rendering.ColorCalculator;
import BryceMath.Calculations.Geometry;
import BryceMath.Calculations.MathB;
import BryceMath.DoubleMath.Matrix;
import BryceMath.DoubleMath.Vector;
import BryceMath.Geometry.Circle;
import BryceMath.Geometry.Polygon;
import BryceMath.Geometry.Shape;
import Data_Structures.Structures.Box;
import Data_Structures.Structures.List;
import Data_Structures.Structures.UBA;
import java.awt.Color;
import java.awt.Dimension;

public abstract class Image_vectorGeometry
extends ColorCalculator {
    UBA<Vector> data = new UBA();
    List<Shape> shapes = new List();
    private Vector color_primary = this.v(0.0, 0.0, 0.0, 1.0);
    double thickness_current = 1.0;
    final int CIRCLE = 0;
    final int RECTANGLE = 1;
    final int RECTANGLE_R2 = 2;
    final int TRIANGLE = 3;
    final int CURVE = 4;
    final int CIRCLE_OUTLINE = 5;
    final int POLYGON = 6;
    final double SMALL = 1.0E-7;

    public Image_vectorGeometry(Dimension dim) {
        super(dim);
        this.i_geoms();
    }

    public Image_vectorGeometry(int w, int h) {
        super(w, h);
        this.i_geoms();
    }

    public void clear() {
        this.data.clear();
        this.shapes.clear();
    }

    public Image_vectorGeometry(int w, int h, boolean wait_to_i_geoms) {
        super(w, h);
    }

    public abstract void i_geoms();

    public void i_circle(Vector center) {
        this.i_circle(center, this.thickness_current);
    }

    public void i_circle(Vector center, double radius) {
        if (center.length != 2) {
            throw new Error("Invalid 2D circle coordinates!");
        }
        this.data.add(this.v(0.0));
        this.data.add(center);
        this.data.add(this.v(radius * radius));
        this.data.add(this.color_primary);
        this.shapes.add(new Circle(center, radius));
    }

    public void i_circle_outline(Vector center, double radius) {
        this.i_circle_outline(center, radius, this.thickness_current);
    }

    public void i_circle_outline(Vector center, double radius, double thickness) {
        if (center.length != 2) {
            throw new Error("Invalid 2D circle coordinates!");
        }
        this.data.add(this.v(5.0));
        this.data.add(center);
        this.data.add(this.v(radius * radius));
        thickness = radius - thickness;
        thickness = Math.max(thickness, 0.0);
        this.data.add(this.v(thickness * thickness));
        this.data.add(this.color_primary);
        this.shapes.add(new Circle(center, radius));
    }

    public void i_rect(Vector v1, Vector v2) {
        this.i_rect(v1, v2, this.thickness_current);
    }

    public void i_rect(Vector v1, Vector v2, double radius) {
        Vector mid_point = v1.add(v2).div(2.0);
        this.data.add(this.v(1.0));
        this.data.add(mid_point);
        Vector par_norm = v2.sub(v1).norm();
        this.data.add(par_norm);
        this.data.add(this.v(v2.sub(mid_point).sqr_mag()));
        this.data.add(this.v(radius * radius));
        this.data.add(this.color_primary);
        Vector perp = par_norm.getPerp().mult(radius);
        Vector s1 = v1.sub(perp);
        Vector s2 = v1.add(perp);
        Vector s3 = v1.add(perp);
        Vector s4 = v1.sub(perp);
        this.shapes.add(new Polygon(s1, s2, s3, s4));
    }

    public void i_inclined_rect(Vector v1, Vector v2, double radius1, double radius2) {
        Vector mid_point = v1.add(v2).div(2.0);
        this.data.add(this.v(2.0));
        this.data.add(mid_point);
        this.data.add(v1);
        this.data.add(v2);
        this.data.add(v2.sub(v1).norm());
        this.data.add(this.v(v2.sub(mid_point).sqr_mag()));
        this.data.add(this.v(radius1));
        this.data.add(this.v(radius2));
        this.data.add(this.color_primary);
    }

    public void i_triangle(Vector v1, Vector v2, Vector v3) {
        this.data.add(this.v(3.0));
        this.data.add(v1);
        this.data.add(v2);
        this.data.add(v3);
        this.data.add(this.color_primary);
        this.shapes.add(new Polygon(v1, v2, v3));
    }

    public void i_curve(Vector v1, Vector v2, Vector v3) {
        this.i_curve(v1, v2, v3, this.thickness_current);
    }

    public void i_curve(Vector v1, Vector v2, Vector v3, double radius) {
        Vector side2;
        if (v1.sub(v2).mag() < 1.0E-7) {
            if (v1.sub(v3).mag() < 1.0E-7) {
                this.i_circle(v1, radius);
                return;
            }
            this.i_rect(v1, v3, radius);
            return;
        }
        if (v1.sub(v3).mag() < 1.0E-7) {
            this.i_rect(v1, v2, radius);
            return;
        }
        if (v2.sub(v3).mag() < 1.0E-7) {
            this.i_rect(v1, v2, radius);
            return;
        }
        Vector side1 = v2.sub(v1).norm();
        if (Math.abs(side1.dot(side2 = v3.sub(v2).norm())) > 0.9999) {
            Vector side3 = v1.sub(v3);
            double l1 = side1.mag();
            double l2 = side2.mag();
            double l3 = side3.mag();
            if (l1 > l2 && l1 > l3) {
                this.i_rect(v2, v1, radius);
                return;
            }
            if (l2 > l1 && l2 > l3) {
                this.i_rect(v3, v2, radius);
                return;
            }
            this.i_rect(v1, v3, radius);
            return;
        }
        Vector mid1 = v1.add(v2).div(2.0);
        Vector mid2 = v2.add(v3).div(2.0);
        Vector mid1_perp = side2.sub(side2.proj(side1));
        Vector mid2_perp = side1.sub(side1.proj(side2));
        Matrix A = new Matrix(this.v(mid1_perp.get(0), -mid2_perp.get(0)), this.v(mid1_perp.get(1), -mid2_perp.get(1)));
        Vector b = this.v(mid2.get(0) - mid1.get(0), mid2.get(1) - mid1.get(1));
        Vector resultingScalars = A.solve(b);
        Vector center = mid1.add(mid1_perp.mult(resultingScalars.get(0)));
        v1 = v1.sub(center);
        v2 = v2.sub(center);
        v3 = v3.sub(center);
        double angle1 = MathB.lineAngle(v1.get(0), v1.get(1), 0.0, 0.0);
        double angle2 = MathB.lineAngle(v2.get(0), v2.get(1), 0.0, 0.0);
        double angle3 = MathB.lineAngle(v3.get(0), v3.get(1), 0.0, 0.0);
        if (angle3 < angle1) {
            angle3 += 360.0;
        }
        if (angle2 < angle1) {
            angle2 += 360.0;
        }
        if (angle2 > angle3) {
            Vector temp = v1;
            v1 = v3;
            v3 = temp;
            double temp2 = angle1;
            angle1 = angle3;
            angle3 = temp2;
            angle1 -= 360.0;
            angle2 -= 360.0;
        }
        double circle_radius = v1.mag();
        double minRadius = Math.max(circle_radius - radius, 0.0);
        double maxRadius = circle_radius + radius;
        boolean interior = true;
        if (angle3 - angle1 > 180.0) {
            interior = false;
            Vector temp = v3;
            v3 = v1;
            v1 = temp;
            double tempAngle = angle1;
            angle1 = angle3;
            angle3 = tempAngle;
            double anglev2 = angle1 + 1.0E-7;
            v2 = this.v(Math.cos(Math.toRadians(anglev2)), -Math.sin(Math.toRadians(anglev2)));
        }
        this.data.add(this.v(4.0));
        this.data.add(center);
        this.data.add(v1.norm());
        this.data.add(v3.norm());
        this.data.add(v2.cross(v1));
        this.data.add(v2.cross(v3));
        if (interior) {
            this.data.add(this.v(-1.0));
        } else {
            this.data.add(this.v(1.0));
        }
        this.data.add(this.v(minRadius * minRadius));
        this.data.add(this.v(maxRadius * maxRadius));
        this.data.add(this.color_primary);
    }

    public void i_polygon(Vector ... points) {
        this.data.add(this.v(6.0));
        this.data.add(this.color_primary);
        int len = points.length;
        this.data.add(this.v(len));
        int i = 0;
        while (i < len) {
            this.data.add(points[i]);
            ++i;
        }
        this.data.add(points[0]);
        this.shapes.add(new Polygon(points));
    }

    public void i_round_rect(Vector v1, Vector v2) {
        this.i_round_rect(v1, v2, this.thickness_current);
    }

    public void i_round_rect(Vector v1, Vector v2, double radius) {
        this.i_circle(v1, radius);
        this.i_circle(v2, radius);
        this.i_rect(v1, v2, radius);
    }

    public void i_line(Vector ... points) {
        this.i_line(this.thickness_current, points);
    }

    public void i_line(double radius, Vector ... points) {
        int end = points.length;
        int i = 1;
        while (i < end) {
            this.i_circle(points[i - 1], radius);
            this.i_rect(points[i - 1], points[i], radius);
            ++i;
        }
        if (end > 0) {
            this.i_circle(points[end - 1], radius);
        }
    }

    @Override
    public Color getColor(double x, double y) {
        Vector z = this.v(x, y);
        UBA<Vector> CS = new UBA<Vector>();
        this.parseGeometry(z, CS);
        return this.parseColor(CS);
    }

    private void parseGeometry(Vector z, UBA<Vector> CS) {
        int i = 0;
        int end = this.data.size();
        State_Info opaque = new State_Info(STATE.TRANSPARENT);
        while (i < end) {
            STATE state = (STATE)((Object)opaque.val);
            if (state == STATE.OPAQUE) break;
            int geometry_type = (int)this.data.get(i).get(0);
            ++i;
            switch (geometry_type) {
                case 0: {
                    i = this.c_circle(i, z, CS, opaque);
                    break;
                }
                case 5: {
                    i = this.c_circle_outline(i, z, CS, opaque);
                    break;
                }
                case 1: {
                    i = this.c_rectangle(i, z, CS, opaque);
                    break;
                }
                case 2: {
                    i = this.c_rectangle_r2(i, z, CS, opaque);
                    break;
                }
                case 3: {
                    i = this.c_triangle(i, z, CS, opaque);
                    break;
                }
                case 4: {
                    i = this.c_curve(i, z, CS, opaque);
                    break;
                }
                case 6: {
                    i = this.c_polygon(i, z, CS, opaque);
                    break;
                }
                default: {
                    throw new Error("Malformed Data list. Last code was : " + geometry_type);
                }
            }
        }
    }

    private Color parseColor(UBA<Vector> color_stack) {
        int end = color_stack.size();
        Vector output = this.v(0.0, 0.0, 0.0, 0.0);
        int i = 0;
        while (i < end) {
            Vector top = color_stack.pop();
            double vTop = top.get(3);
            double vBottom = 1.0 - vTop;
            output = top.mult(vTop).add(output.mult(vBottom));
            ++i;
        }
        return this.v_to_color(output);
    }

    private int c_circle(int i, Vector z, UBA<Vector> CS, State_Info opaque) {
        if (this.cutOutState(opaque, this.data.get(i + 2))) {
            return i + 3;
        }
        Vector center = this.data.get(i);
        double radius_squared = this.data.get(i + 1).get(0);
        if ((z = z.sub(center)).sqr_mag() <= radius_squared) {
            Vector color = this.data.get(i + 2);
            CS.push(color);
            opaque.val = this.getState(color);
        }
        return i + 3;
    }

    private int c_circle_outline(int i, Vector z, UBA<Vector> CS, State_Info opaque) {
        double z_mag_sqr;
        if (this.cutOutState(opaque, this.data.get(i + 3))) {
            return i + 4;
        }
        Vector center = this.data.get(i);
        double radius_squared = this.data.get(i + 1).get(0);
        double min_radius_squared = this.data.get(i + 2).get(0);
        if (min_radius_squared < (z_mag_sqr = (z = z.sub(center)).sqr_mag()) && z_mag_sqr <= radius_squared) {
            Vector color = this.data.get(i + 3);
            CS.push(color);
            opaque.val = this.getState(color);
        }
        return i + 4;
    }

    private int c_rectangle(int i, Vector z, UBA<Vector> CS, State_Info opaque) {
        if (this.cutOutState(opaque, this.data.get(i + 4))) {
            return i + 5;
        }
        Vector mid_point = this.data.get(i);
        Vector parrellel_direction = this.data.get(i + 1);
        double par_r_sqr = this.data.get(i + 2).get(0);
        double perp_r_sqr = this.data.get(i + 3).get(0);
        z = z.sub(mid_point);
        Vector parrellel_componant_vector = z.proj(parrellel_direction);
        double parrellel_componant_sqr = parrellel_componant_vector.sqr_mag();
        double perpendicular_componant_sqr = z.sub(parrellel_componant_vector).sqr_mag();
        if (parrellel_componant_sqr <= par_r_sqr && perpendicular_componant_sqr <= perp_r_sqr) {
            Vector color = this.data.get(i + 4);
            CS.push(color);
            opaque.val = this.getState(color);
        }
        return i + 5;
    }

    private int c_rectangle_r2(int i, Vector z, UBA<Vector> CS, State_Info opaque) {
        double mag2;
        if (this.cutOutState(opaque, this.data.get(i + 7))) {
            return i + 8;
        }
        Vector z_start = z;
        Vector mid_point = this.data.get(i);
        Vector v1 = this.data.get(i + 1);
        Vector v2 = this.data.get(i + 2);
        Vector parrellel_direction = this.data.get(i + 3);
        double par_r_sqr = this.data.get(i + 4).get(0);
        double perp_r1 = this.data.get(i + 5).get(0);
        double perp_r2 = this.data.get(i + 6).get(0);
        z = z.sub(mid_point);
        Vector parrellel_componant_vector = z.proj(parrellel_direction);
        double parrellel_componant_sqr = parrellel_componant_vector.sqr_mag();
        double perpendicular_componant = z.sub(parrellel_componant_vector).mag();
        double parralled_percentage = 0.5 * (Math.sqrt(parrellel_componant_sqr) / Math.sqrt(par_r_sqr));
        double mag1 = z_start.sub(v1).mag();
        parralled_percentage = mag1 < (mag2 = z_start.sub(v2).mag()) ? 0.5 - parralled_percentage : (parralled_percentage += 0.5);
        double perp_here = parralled_percentage * perp_r2 + (1.0 - parralled_percentage) * perp_r1;
        if (parrellel_componant_sqr <= par_r_sqr && perpendicular_componant <= perp_here) {
            Vector color = this.data.get(i + 7);
            CS.push(color);
            opaque.val = this.getState(color);
        }
        return i + 8;
    }

    private int c_triangle(int i, Vector z, UBA<Vector> CS, State_Info opaque) {
        if (this.cutOutState(opaque, this.data.get(i + 3))) {
            return i + 4;
        }
        Vector A = this.data.get(i);
        Vector B = this.data.get(i + 1);
        Vector C = this.data.get(i + 2);
        Vector P2 = z;
        double[] barycentric = Geometry.barycentric(P2, A, B, C);
        double u = barycentric[0];
        double v = barycentric[1];
        if (u >= 0.0 && v >= 0.0 && u + v < 1.0) {
            Vector color = this.data.get(i + 3);
            CS.push(color);
            opaque.val = this.getState(color);
        }
        return i + 4;
    }

    private int c_curve(int i, Vector z, UBA<Vector> CS, State_Info opaque) {
        boolean pred;
        if (this.cutOutState(opaque, this.data.get(i + 8))) {
            return i + 9;
        }
        Vector center = this.data.get(i);
        Vector end_point1 = this.data.get(i + 1);
        Vector end_point2 = this.data.get(i + 2);
        double cross1A = this.data.get(i + 3).get(2);
        double cross2A = this.data.get(i + 4).get(2);
        boolean exterior = this.data.get(i + 5).get(0) == 1.0;
        double min_radius_sqr = this.data.get(i + 6).get(0);
        double max_radius_sqr = this.data.get(i + 7).get(0);
        double dist_sqr = (z = z.sub(center)).sqr_mag();
        if (dist_sqr > max_radius_sqr || dist_sqr < min_radius_sqr) {
            return i + 9;
        }
        int sign1 = this.sign(z.cross(end_point1).get(2));
        int sign2 = this.sign(z.cross(end_point2).get(2));
        boolean bl = pred = sign1 == this.sign(cross1A) && sign2 == this.sign(cross2A);
        if (exterior) {
            boolean bl2 = pred = !pred;
        }
        if (pred) {
            Vector color = this.data.get(i + 8);
            CS.push(color);
            opaque.val = this.getState(color);
        }
        return i + 9;
    }

    private int c_polygon(int i, Vector z, UBA<Vector> CS, State_Info opaque) {
        Vector color = this.data.get(i);
        int sides = (int)this.data.get(i + 1).get(0);
        int output_index = i + sides + 3;
        if (this.cutOutState(opaque, color)) {
            return output_index;
        }
        boolean odd = false;
        Vector dZ = this.v(1.0, 0.0);
        int k = 0;
        while (k < sides) {
            Vector p2;
            Vector p1 = this.data.get(i + 2 + k);
            if (Geometry.ray_line_segment_intersect(z, dZ, p1, p2 = this.data.get(i + 2 + k + 1))) {
                odd = !odd;
            }
            ++k;
        }
        if (odd) {
            CS.push(color);
            opaque.val = this.getState(color);
        }
        return output_index;
    }

    private int sign(double input) {
        if (input == 0.0) {
            return 0;
        }
        if (input > 0.0) {
            return 1;
        }
        return -1;
    }

    protected void set_color(Color c1) {
        this.color_primary = this.color_to_v(c1);
    }

    protected void set_thickness(double val) {
        this.thickness_current = val;
    }

    public Vector v(double ... input) {
        return new Vector(input);
    }

    private STATE getState(Vector color) {
        double val = color.data[3];
        if (val == 1.0) {
            return STATE.OPAQUE;
        }
        if (val == 0.0) {
            return STATE.CUT_OUT;
        }
        return STATE.TRANSPARENT;
    }

    private boolean cutOutState(State_Info state, Vector color) {
        if (state.val == STATE.CUT_OUT) {
            if (this.getState(color) != STATE.CUT_OUT) {
                state.val = STATE.TRANSPARENT;
            }
            return true;
        }
        return false;
    }

    private Color v_to_color(Vector input) {
        assert (input.length == 4);
        return new Color((int)input.get(0), (int)input.get(1), (int)input.get(2), (int)(input.get(3) * 255.0));
    }

    private Vector color_to_v(Color input) {
        return this.v(input.getRed(), input.getGreen(), input.getBlue(), 1.0 * (double)input.getAlpha() / 255.0);
    }

    public Vector v_dir(double angle) {
        return this.v(Math.cos(Math.toRadians(angle)), -Math.sin(Math.toRadians(angle)));
    }

    private static enum STATE {
        TRANSPARENT,
        OPAQUE,
        CUT_OUT;

    }

    private class State_Info
    extends Box<STATE> {
        public State_Info(STATE val_input) {
            super(val_input);
        }
    }
}

