/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.GUI;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Timer;
import util.ImageUtil;

public class Display
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final int FPS = 30;
    private Dimension dim;
    private final Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
    BufferedImage image;
    BufferedImage screen;
    int w;
    int h;
    int time = 0;

    public Display(Dimension dim) {
        this.w = (int)Math.min(this.screenDim.getWidth(), dim.getWidth());
        this.h = (int)Math.min(this.screenDim.getHeight(), dim.getHeight());
        this.screen = new BufferedImage(this.w, this.h, 2);
        this.iTimers();
    }

    public void setImage(BufferedImage i) {
        this.image = i;
        this.dim = new Dimension(i.getWidth(), i.getHeight());
        this.w = (int)Math.min(this.screenDim.getWidth(), this.dim.getWidth());
        this.h = (int)Math.min(this.screenDim.getHeight(), this.dim.getHeight());
    }

    public void iTimers() {
        Timer t = new Timer(33, new Stepy());
        t.start();
        this.setFocusable(true);
        this.addKeyListener(new KeyInput());
        this.requestFocus();
        MouseInput mIn = new MouseInput();
        this.addMouseListener(mIn);
        this.addMouseMotionListener(mIn);
    }

    private class KeyInput
    extends KeyAdapter {
        private KeyInput() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                System.exit(0);
            } else if (e.getKeyCode() == 32) {
                ImageUtil.saveImage(Display.this.image, "BrendSave");
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class MouseInput
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseInput() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private class Stepy
    implements ActionListener {
        private Stepy() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Graphics g2 = Display.this.screen.getGraphics();
            g2.fillRect(0, 0, Display.this.w, Display.this.h);
            g2.drawImage(Display.this.image, 0, 0, Display.this.w, Display.this.h, 0, 0, Display.this.w, Display.this.h, null);
            Graphics g = Display.this.getGraphics();
            if (g != null) {
                g.drawImage(Display.this.screen, 0, 0, null);
            }
        }
    }
}

