/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.Rendering;

import BryceMath.Calculations.Colors;
import java.awt.Color;
import java.awt.Dimension;

public abstract class ColorCalculator
implements Cloneable {
    protected int room_width;
    protected int room_height;
    public Dimension dim;
    protected int antiAliasing = 1;

    public ColorCalculator(Dimension dim) {
        this.room_width = (int)dim.getWidth();
        this.room_height = (int)dim.getHeight();
        this.dim = dim;
    }

    public ColorCalculator(int width, int height) {
        this.room_width = width;
        this.room_height = height;
        this.dim = new Dimension(width, height);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public abstract Color getColor(double var1, double var3);

    public int getAntiAliasing() {
        return this.antiAliasing;
    }

    public int getWidth() {
        return this.room_width;
    }

    public int getHeight() {
        return this.room_height;
    }

    public Color weightedAverageColor(Color c1, Color c2, double percentage) {
        return Colors.weightedAverageColor(c1, c2, percentage);
    }

    public static Color Color_hsv(double h, double s, double v) {
        return Colors.Color_hsv(h, s, v);
    }

    public static Color Color_hsv(double h, double s, double v, double a) {
        return Colors.Color_hsv(h, s, v, a);
    }

    public int getAliasingThreshold() {
        return 30;
    }
}

