/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.Rendering;

import BryceImages.Operations.ImageFactory;
import BryceImages.Rendering.DynamicColorCalculator;
import BryceImages.Rendering.StartRender;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class LayerPlayer
extends Obj {
    private DynamicColorCalculator dcc;
    private double v_x = 0.0;
    private double v_y = 0.0;
    private double i_x = 0.0;
    private double i_y = 0.0;
    static StartRender rend = new StartRender(true);
    BufferedImage buffer;

    public LayerPlayer(double x, double y, DynamicColorCalculator dcc) {
        super(x, y);
        this.dcc = dcc;
        this.buffer = ImageFactory.blank(dcc.getWidth(), dcc.getHeight());
        this.renderAll();
    }

    @Override
    public void update() {
    }

    @Override
    public void draw(ImageB i, AffineTransform AT) {
        this.shiftPicture(this.v_x, this.v_y);
        super.draw(i, AT);
    }

    public void setImageV(double vx, double vy) {
        this.v_x = vx;
        this.v_y = vy;
    }

    public void setImagePosition(double x, double y) {
        this.shiftPicture(x - this.i_x, y - this.i_y);
        this.i_x = x;
        this.i_y = y;
    }

    private void shiftPicture(double x_offset, double y_offset) {
        BufferedImage row;
        BufferedImage col;
        double x_new = this.i_x + x_offset;
        double y_new = this.i_y + y_offset;
        int xshift = (int)x_new - (int)this.i_x;
        int yshift = (int)y_new - (int)this.i_y;
        this.i_x = x_new;
        this.i_y = y_new;
        this.dcc.incX(xshift);
        this.dcc.incY(yshift);
        int w = this.sprite.getWidth();
        int h = this.sprite.getHeight();
        if (xshift > w / 2 || yshift > h / 2) {
            this.renderAll();
            return;
        }
        Graphics g = this.buffer.getGraphics();
        g.drawImage(this.sprite, -xshift, -yshift, null);
        boolean bottom = yshift > 0;
        int y_start = bottom ? 0 : -yshift;
        int y_end = bottom ? h - yshift : h;
        int x = w - xshift;
        while (x < w) {
            col = this.dcc.getCol(x);
            g.drawImage(col, x, 0, null);
            ++x;
        }
        x = 0;
        while (x > xshift) {
            col = this.dcc.getCol(-x);
            g.drawImage(col, -x, 0, null);
            --x;
        }
        int y = h - yshift;
        while (y < h && y >= y_start && y <= y_end) {
            row = this.dcc.getRow(y);
            g.drawImage(row, 0, y, null);
            ++y;
        }
        y = 0;
        while (y > yshift && y >= y_start && y <= y_end) {
            row = this.dcc.getRow(y);
            g.drawImage(row, 0, -y, null);
            --y;
        }
        BufferedImage temp = this.sprite;
        this.sprite = this.buffer;
        this.buffer = temp;
    }

    private void renderAll() {
        this.sprite = rend.render(this.dcc);
    }
}

