/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Calculations;

import BryceMath.DoubleMath.Vector;

public class Geometry {
    public static boolean rectangle2(double x, double y, double x1, double y1, double width, double height) {
        double x2 = x1 + width;
        double y2 = y1 + height;
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static double[] barycentric(Vector P2, Vector A, Vector B, Vector C) {
        Vector v0 = C.sub(A);
        Vector v1 = B.sub(A);
        Vector v2 = P2.sub(A);
        double dot00 = v0.dot(v0);
        double dot01 = v0.dot(v1);
        double dot02 = v0.dot(v2);
        double dot11 = v1.dot(v1);
        double dot12 = v1.dot(v2);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        double w = 1.0 - u - v;
        double[] output = new double[]{u, v, w};
        return output;
    }

    public static boolean ray_line_segment_intersect(Vector ray_position, Vector ray_direction, Vector line_p1, Vector line_p2) {
        Vector denom_t;
        Vector line_dir = line_p2.sub(line_p1);
        Vector denom_u = denom_t = ray_direction.cross(line_dir);
        Vector ray_line_connection = line_p1.sub(ray_position);
        if (!denom_t.isZero() && !denom_u.isZero()) {
            double t = ray_line_connection.cross(line_dir).div(denom_t);
            double u = ray_line_connection.cross(ray_direction).div(denom_u);
            if (0.0 <= u && u <= 1.0 && t > 0.0) {
                return true;
            }
        }
        return false;
    }
}

