/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Factories;

import BryceMath.Numbers.Complex;
import BryceMath.Numbers.Equation;
import BryceMath.Numbers.Expression;
import BryceMath.Numbers.IntB;
import BryceMath.Numbers.Multinomial;
import BryceMath.Numbers.Number;
import BryceMath.Numbers.Rational;
import BryceMath.Structures.Matrix;
import BryceMath.Structures.Vector;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.List;
import util.SerialB;

public class MatrixFactory {
    public static Matrix<IntB> m_i_row(Vector<IntB> ... input) {
        return new Matrix<IntB>(input);
    }

    public static Matrix<Rational> m_r_row(Vector<Rational> ... input) {
        return new Matrix<Rational>(input);
    }

    public static Matrix<Complex> m_c_row(Vector<Complex> ... input) {
        return new Matrix<Complex>(input);
    }

    public static Matrix<Multinomial> m_e_row(Vector<Multinomial> ... input) {
        return new Matrix<Multinomial>(input);
    }

    public static Matrix<Expression> m_re_row(Vector<Expression> ... input) {
        return new Matrix<Expression>(input);
    }

    public static Matrix<IntB> m_i_col(Vector<IntB> ... input) {
        return new Matrix<IntB>(true, input);
    }

    public static Matrix<Rational> m_r_col(Vector<Rational> ... input) {
        return new Matrix<Rational>(true, input);
    }

    public static Matrix<Complex> m_c_col(Vector<Complex> ... input) {
        return new Matrix<Complex>(true, input);
    }

    public static Matrix<Multinomial> m_e_col(Vector<Multinomial> ... input) {
        return new Matrix<Multinomial>(true, input);
    }

    public static Matrix<Expression> m_re_col(Vector<Expression> ... input) {
        return new Matrix<Expression>(true, input);
    }

    public static Matrix<Equation> m_ex_col(Vector<Equation> ... input) {
        return new Matrix<Equation>(true, input);
    }

    public static Matrix<Expression> Exp_to_Matrix(Expression exp) {
        return MatrixFactory.m_re_col(new Vector((Number[])new Expression[]{exp}));
    }

    public static Matrix<Equation> Equation_to_Matrix(Equation exp) {
        return MatrixFactory.m_ex_col(new Vector((Number[])new Equation[]{exp}));
    }

    public static Matrix<Equation> evaluateExpression(List<Object> elems) throws Error {
        if ((elems = MatrixFactory.parseParens(elems)).isEmpty()) {
            throw new Error("Trivial Evaluation");
        }
        MatrixFactory.parseMult(elems);
        if (elems.isEmpty()) {
            throw new Error("Trivial Evaluation");
        }
        MatrixFactory.parseAdd(elems);
        if (elems.isEmpty()) {
            throw new Error("Trivial Evaluation");
        }
        if (elems.size() != 1) {
            throw new Error("Expression fails to reduce");
        }
        Object result = elems.getFirst();
        if (result instanceof Matrix) {
            return (Matrix)elems.getFirst();
        }
        if (result instanceof Equation) {
            return MatrixFactory.Equation_to_Matrix((Equation)elems.getFirst());
        }
        throw new Error("Type : " + result.getClass() + " is not supported");
    }

    private static List<Object> parseParens(List<Object> elems) {
        List<Object> result = new List<Object>();
        IterB<Object> iter2 = elems.getIter();
        int parens_depth = 0;
        List<Object> sub_list = new List<Object>();
        while (iter2.hasNext()) {
            Object o = iter2.next();
            if (o instanceof Character) {
                Character c = (Character)o;
                if (c.charValue() == '(') {
                    ++parens_depth;
                    continue;
                }
                if (c.charValue() == ')') {
                    if (parens_depth == 0 || --parens_depth != 0) continue;
                    MatrixFactory.handleEndP(result, sub_list);
                    continue;
                }
            }
            if (parens_depth > 0) {
                sub_list.add(o);
                continue;
            }
            result.add(o);
        }
        if (parens_depth > 0) {
            MatrixFactory.handleEndP(result, sub_list);
        }
        return result;
    }

    private static void parseMult(List<Object> elems) throws Error {
        IterB<Object> iter2 = elems.getIter();
        Object last = iter2.next();
        while (iter2.hasNext()) {
            Matrix m1;
            SerialB result;
            Equation scalar;
            Object o = iter2.next();
            if (o instanceof Matrix) {
                Matrix m2 = (Matrix)o;
                if (last instanceof Equation) {
                    scalar = (Equation)last;
                    result = m2.mult(scalar);
                    MatrixFactory.replaceLast2(iter2, result);
                    last = result;
                    continue;
                }
                if (last instanceof Matrix) {
                    m1 = (Matrix)last;
                    if (m1.getColNum() == m2.getRowNum()) {
                        result = m1.mult(m2);
                    } else if (m1.canVectorDotWith(m2)) {
                        result = m1.getRowNum() == 1 ? m1.mult(m2.transpose()) : m1.transpose().mult(m2);
                    } else {
                        throw new Error("Error : Improper dimensions for Matrix multiplication.");
                    }
                    MatrixFactory.replaceLast2(iter2, result);
                    last = result;
                    continue;
                }
                last = o;
                continue;
            }
            if (o instanceof Equation) {
                Equation exp = (Equation)o;
                if (last instanceof Equation) {
                    scalar = (Equation)last;
                    result = exp.mult(scalar);
                    MatrixFactory.replaceLast2(iter2, result);
                    last = result;
                    continue;
                }
                if (last instanceof Matrix) {
                    m1 = (Matrix)last;
                    result = m1.mult(exp);
                    MatrixFactory.replaceLast2(iter2, result);
                    last = result;
                    continue;
                }
                last = o;
                continue;
            }
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                if (c == '*') {
                    iter2.remove();
                    continue;
                }
                SerialB old_last = last;
                last = Character.valueOf(c);
                if (c != '/' || !iter2.hasNext()) continue;
                Object o2 = iter2.next();
                if (!(o2 instanceof Equation)) {
                    throw new Error("Can't divide by non scalars.");
                }
                Equation scalar2 = (Equation)o2;
                if (old_last instanceof Equation) {
                    Equation exp = (Equation)old_last;
                    last = MatrixFactory.replaceLast3(iter2, exp.div(scalar2));
                    continue;
                }
                if (old_last instanceof Matrix) {
                    SerialB m = old_last;
                    last = MatrixFactory.replaceLast3(iter2, ((Matrix)m).mult((Equation)scalar2.mult_inverse()));
                    continue;
                }
            }
            throw new Error("Type : " + o.getClass() + " is not supported");
        }
    }

    private static void parseAdd(List<Object> elems) throws Error {
        if (elems.getFirst().equals(Character.valueOf('-'))) {
            elems.prepend(Equation.ZERO);
        } else if (elems.getFirst().equals(Character.valueOf('+'))) {
            elems.prepend(Equation.ZERO);
        }
        IterB<Object> iter2 = elems.getIter();
        Object last = iter2.next();
        while (iter2.hasNext()) {
            SerialB result;
            Object o = iter2.next();
            if (!(o instanceof Character)) continue;
            char c = ((Character)o).charValue();
            if (c != '+' && c != '-') {
                iter2.remove();
                continue;
            }
            if (!iter2.hasNext()) continue;
            Object o2 = iter2.next();
            if (o2 instanceof Equation) {
                if (!(last instanceof Equation)) {
                    throw new Error("Cannot add Scalars and Matrices.");
                }
                Equation scalar1 = (Equation)last;
                Equation scalar2 = (Equation)o2;
                result = c == '+' ? scalar1.add(scalar2) : scalar1.sub(scalar2);
                last = MatrixFactory.replaceLast3(iter2, result);
                continue;
            }
            if (!(o2 instanceof Matrix)) continue;
            if (!(last instanceof Matrix)) {
                throw new Error("Cannot add Scalars and Matrices.");
            }
            Matrix matrix1 = (Matrix)last;
            Matrix matrix2 = (Matrix)o2;
            result = c == '+' ? matrix1.add(matrix2) : matrix1.sub(matrix2);
            last = MatrixFactory.replaceLast3(iter2, result);
        }
    }

    private static void handleEndP(List<Object> results, List<Object> sub_exp) {
        if (sub_exp.isEmpty()) {
            return;
        }
        Matrix<Equation> sub_result = MatrixFactory.evaluateExpression(sub_exp);
        if (sub_result.isTrivial()) {
            results.add(sub_result.get(0, 0));
        } else {
            results.add(sub_result);
        }
        sub_exp.clear();
    }

    private static void replaceLast2(IterB<Object> iter2, Object result) {
        iter2.remove();
        iter2.previous();
        iter2.replace(result);
    }

    private static Object replaceLast3(IterB<Object> iter2, Object result) {
        iter2.remove();
        iter2.previous();
        iter2.remove();
        iter2.previous();
        iter2.replace(result);
        return result;
    }
}

