/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Geometry;

import BryceMath.Calculations.MathB;
import Data_Structures.Structures.UBA;

public class Rectangle {
    private int x;
    private int y;
    private int w;
    private int h;
    private int x2;
    private int y2;

    public Rectangle(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.x2 = x + w;
        this.y2 = y + h;
    }

    public boolean containsPoint(int px, int py) {
        return px >= this.x && px <= this.x2 && py >= this.y && py <= this.y2;
    }

    public Rectangle intersection(Rectangle other) {
        int nx = MathB.max(this.x, other.x);
        int ny = MathB.max(this.y, other.y);
        int nx2 = MathB.min(this.x2, other.x2);
        int ny2 = MathB.min(this.y2, other.y2);
        int nw = nx2 - nx;
        int nh = ny2 - ny;
        return new Rectangle(nx, ny, nw, nh);
    }

    public Rectangle union(Rectangle other) {
        int nx = MathB.min(this.x, other.x);
        int ny = MathB.min(this.y, other.y);
        int nx2 = MathB.max(this.x2, other.x2);
        int ny2 = MathB.max(this.y2, other.y2);
        int nw = nx2 - nx;
        int nh = ny2 - ny;
        return new Rectangle(nx, ny, nw, nh);
    }

    public void setX(int x_new) {
        this.x = x_new;
        this.x2 = this.x + this.w;
    }

    public void setY(int y_new) {
        this.y = y_new;
        this.y2 = this.y + this.h;
    }

    public void setW(int w_new) {
        this.w = w_new;
        this.x2 = this.x + this.w;
    }

    public void setH(int h_new) {
        this.h = h_new;
        this.y2 = this.y + this.h;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public UBA<Integer> getBounds() {
        UBA<Integer> output = new UBA<Integer>(4);
        output.add(this.x);
        output.add(this.y);
        output.add(this.x2);
        output.add(this.x2);
        return output;
    }

    public Rectangle offset(int dx, int dy) {
        return new Rectangle(this.x + dx, this.y + dy, this.w, this.h);
    }

    public Rectangle offset(double dx, double dy) {
        return this.offset((int)dx, (int)dy);
    }

    public String toString() {
        return "Rectangle[ X = " + this.x + ", Y = " + this.y + ", W = " + this.w + ", H = " + this.h + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rectangle)) {
            return false;
        }
        Rectangle r = (Rectangle)o;
        return this.x == r.x && this.y == r.y && this.w == r.w && this.h == r.h;
    }

    public Rectangle clone() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public int hashCode() {
        return this.x + 193939 * this.y + this.w * this.w * 1193 + this.h * this.h * this.h * 23981;
    }
}

