/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Numbers.FiniteInteger;
import BryceMath.Numbers.IntB;
import Data_Structures.Structures.UBA;

public class BaseNumber {
    private UBA<FiniteInteger> data;
    final int base;
    boolean positive = true;

    public BaseNumber(int base_in) {
        this.base = base_in;
        this.data = new UBA(2);
    }

    public void neg() {
        this.positive = !this.positive;
    }

    public void add(int input) {
        if (Integer.MAX_VALUE - this.base < input) {
            throw new Error("ERROR: BaseNumber add: int is too large!");
        }
        if (input == 0) {
            return;
        }
        int digitNum = 0;
        int carry = input;
        while (carry != 0) {
            int digit = this.getDigit(digitNum).toInt() + carry;
            int newDigit = digit % this.base;
            carry = digit / this.base;
            this.setDigit(digitNum, this.i(newDigit));
            ++digitNum;
        }
    }

    public void mult(int input) {
        if (Integer.MAX_VALUE / this.base < input) {
            throw new Error("ERROR: BaseNumber add: int is too large!");
        }
        if (input == 0) {
            BaseNumber temp = new BaseNumber(this.base);
            this.data = temp.data;
            return;
        }
        int digitNum = 0;
        int carry = 0;
        int len = this.data.size();
        while (digitNum < len || carry != 0) {
            int digit = this.getDigit(digitNum).toInt() * input + carry;
            int newDigit = digit % this.base;
            carry = digit / this.base;
            this.setDigit(digitNum, this.i(newDigit));
            ++digitNum;
        }
    }

    private FiniteInteger i(int input) {
        return new FiniteInteger(input);
    }

    FiniteInteger getDigit(int digitNum) {
        if (digitNum < 0) {
            throw new Error("Error: Negative digits do not exist.");
        }
        int len = this.data.size();
        if (digitNum < len) {
            return this.data.get(digitNum);
        }
        return this.i(0);
    }

    /*
     * Unable to fully structure code
     */
    private void setDigit(int digitNum, FiniteInteger digit) {
        if (digitNum < 0) {
            throw new Error("Error: Negative digits do not exist, and therefore cannot be set.");
        }
        len = this.data.size();
        if (digitNum < len) {
            this.data.set(digitNum, digit);
            return;
        }
        if (!digit.eq(0)) ** GOTO lbl11
        return;
lbl-1000:
        // 1 sources

        {
            this.data.add(this.i(0));
            ++len;
lbl11:
            // 2 sources

            ** while (len < digitNum)
        }
lbl12:
        // 1 sources

        this.data.add(digit);
    }

    public String toString() {
        char[] output;
        int len = this.data.size();
        if (len == 0) {
            return "0";
        }
        if (!this.positive) {
            output = new char[len + 1];
            output[0] = 45;
        } else {
            output = new char[len];
        }
        int output_len = output.length;
        int i = 0;
        while (i < len) {
            int indice = output_len - 1 - i;
            int digit = this.getDigit(i).toInt();
            output[indice] = digit > 9 ? (char)(digit - 10 + 65) : (char)(digit + 48);
            ++i;
        }
        return new String(output);
    }

    public IntB toInteger() {
        return new IntB(this.toString());
    }
}

