/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Numbers.Expression;
import BryceMath.Numbers.IntB;
import BryceMath.Numbers.Number;
import java.io.PrintStream;
import util.Genarics;

public class Equation
extends Number<Equation> {
    public static Equation ONE = new Equation(1L);
    public static Equation ZERO = new Equation(0L);
    public static Equation ZERO_ZERO = new Equation(0L, 0L);
    public static Genarics<Expression> ge_e = new Genarics();
    Expression left;
    Expression right;

    public Equation(Expression e1, Expression e2) {
        this.left = e1;
        this.right = e2;
    }

    public Equation(Expression e) {
        this.left = e;
    }

    public Equation(long numerator, long denominator) {
        this.left = new Expression(numerator);
        this.right = new Expression(denominator);
    }

    public Equation(long numerator) {
        this.left = new Expression(numerator);
        this.right = null;
    }

    @Override
    Equation N(long n) {
        Expression e = new Expression(n);
        return new Equation(e);
    }

    @Override
    public Equation zero() {
        return ZERO;
    }

    @Override
    public Equation one() {
        return ONE;
    }

    @Override
    public Equation add(Equation input) {
        Equation e1 = this;
        Equation e2 = input;
        if (e1.eq(0)) {
            return e2;
        }
        if (e2.eq(0)) {
            return e1;
        }
        switch (Equation.get_case(e1, e2)) {
            case MONO: {
                Expression outL = e1.left.add(e2.left);
                return new Equation(outL);
            }
            case MONO_DUAL: {
                Expression outL = e1.left.add(e2.left);
                Expression outR = e1.left.add(e2.right);
                return new Equation(outL, outR);
            }
            case DUAL_MONO: {
                Expression outL = e1.left.add(e2.left);
                Expression outR = e1.right.add(e2.left);
                return new Equation(outL, outR);
            }
            case DUAL: {
                Expression outL = e1.left.add(e2.left);
                Expression outR = e1.right.add(e2.right);
                return new Equation(outL, outR);
            }
        }
        throw new Error("Should Never get here!");
    }

    @Override
    public Equation sub(Equation input) {
        Equation e1 = this;
        Equation e2 = input;
        if (e1.eq(0)) {
            return e2.neg();
        }
        if (e2.eq(0)) {
            return e1;
        }
        switch (Equation.get_case(e1, e2)) {
            case MONO: {
                Expression outL = e1.left.sub(e2.left);
                return new Equation(outL);
            }
            case MONO_DUAL: {
                Expression outL = e1.left.sub(e2.left);
                Expression outR = e1.left.sub(e2.right);
                return new Equation(outL, outR);
            }
            case DUAL_MONO: {
                Expression outL = e1.left.sub(e2.left);
                Expression outR = e1.right.sub(e2.left);
                return new Equation(outL, outR);
            }
            case DUAL: {
                Expression outL = e1.left.sub(e2.left);
                Expression outR = e1.right.sub(e2.right);
                return new Equation(outL, outR);
            }
        }
        throw new Error("Should Never get here!");
    }

    @Override
    public Equation mult(Equation input) {
        Equation e1 = this;
        Equation e2 = input;
        if (e1.eq(0)) {
            return e1;
        }
        if (e2.eq(0)) {
            return e2;
        }
        switch (Equation.get_case(e1, e2)) {
            case MONO: {
                Expression outL = e1.left.mult(e2.left);
                return new Equation(outL);
            }
            case MONO_DUAL: {
                Expression outL = e1.left.mult(e2.left);
                Expression outR = e1.left.mult(e2.right);
                return new Equation(outL, outR);
            }
            case DUAL_MONO: {
                Expression outL = e1.left.mult(e2.left);
                Expression outR = e1.right.mult(e2.left);
                return new Equation(outL, outR);
            }
            case DUAL: {
                Expression outL = e1.left.mult(e2.left);
                Expression outR = e1.right.mult(e2.right);
                return new Equation(outL, outR);
            }
        }
        throw new Error("Should Never get here!");
    }

    @Override
    public Equation div(Equation input) {
        Equation e1 = this;
        Equation e2 = input;
        if (e2.left.eq(0) || e2.right != null && e2.right.eq(0)) {
            throw new Error("Error : Cannot divide by zero!");
        }
        if (e2.eq(1)) {
            return e1;
        }
        switch (Equation.get_case(e1, e2)) {
            case MONO: {
                Expression outL = e1.left.div(e2.left);
                return new Equation(outL);
            }
            case MONO_DUAL: {
                Expression outL = e1.left.div(e2.left);
                Expression outR = e1.left.div(e2.right);
                return new Equation(outL, outR);
            }
            case DUAL_MONO: {
                Expression outL = e1.left.div(e2.left);
                Expression outR = e1.right.div(e2.left);
                return new Equation(outL, outR);
            }
            case DUAL: {
                Expression outL = e1.left.mult(e2.left);
                Expression outR = e1.right.mult(e2.right);
                return new Equation(outL, outR);
            }
        }
        throw new Error("Should Never get here!");
    }

    @Override
    public Equation conj() {
        Expression e1 = null;
        Expression e2 = null;
        if (this.left != null) {
            e1 = this.left.conj();
        }
        if (this.right != null) {
            e2 = this.right.conj();
        }
        if (e1 == this.left && e2 == this.right) {
            return this;
        }
        return new Equation(e1, e2);
    }

    @Override
    public Equation sqrt() {
        Expression e1 = null;
        Expression e2 = null;
        if (this.left != null) {
            e1 = this.left.sqrt();
        }
        if (this.right != null) {
            e2 = this.right.sqrt();
        }
        if (e1 == this.left && e2 == this.right) {
            return this;
        }
        return new Equation(e1, e2);
    }

    @Override
    public boolean eq(Equation other) {
        Equation e1 = this;
        Equation e2 = other;
        return ge_e.xequal(e1.left, e2.left) && ge_e.xequal(e1.right, e2.right);
    }

    @Override
    public int hashCode() {
        int i1 = this.left.hashCode();
        int i2 = this.right != null ? this.right.hashCode() : 0;
        return i1 * 0xFFDFFF + i2;
    }

    public String toSerialString() {
        if (this.right == null) {
            return this.left.toSerialString();
        }
        return String.valueOf(this.left.toSerialString()) + " = " + this.right.toSerialString();
    }

    @Override
    public String toString() {
        if (this.right == null) {
            return this.left.toString();
        }
        return this.left + " = " + this.right;
    }

    @Override
    public Equation neg() {
        Expression e1 = this.left.neg();
        Expression e2 = this.right != null ? this.right.neg() : null;
        return new Equation(e1, e2);
    }

    @Override
    public boolean isNegative() {
        return this.left.isNegative();
    }

    @Override
    public boolean isPositive() {
        return this.left.isPositive();
    }

    @Override
    public int sign() {
        return this.left.sign();
    }

    @Override
    public Equation abs() {
        boolean b1 = this.left.isPositive();
        if (this.isExpression()) {
            return b1 ? this : this.neg();
        }
        if (b1 && this.right.isPositive()) {
            return this;
        }
        Expression e1 = this.left.abs();
        Expression e2 = this.right.abs();
        return new Equation(e1, e2);
    }

    public boolean isExpression() {
        return this.right == null;
    }

    @Override
    public boolean isInt() {
        return this.isExpression() && this.left.isInt();
    }

    @Override
    public IntB toIntB() {
        return this.left.toIntB();
    }

    @Override
    public int toInt() {
        return this.left.toInt();
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        if (this.isExpression()) {
            throw new Error("Error : Equation only has 1 side.");
        }
        return this.right;
    }

    public Equation switch_sides() {
        return new Equation(this.right, this.left);
    }

    public Equation reduce_zero() {
        if (this.isExpression()) {
            throw new Error("Error : Equation has no right side!");
        }
        Expression e1 = this.left.sub(this.right);
        Expression e2 = Expression.ZERO;
        return new Equation(e1, e2);
    }

    private static op get_case(Equation e1, Equation e2) {
        boolean m_2;
        boolean m_1 = e1.right == null;
        boolean bl = m_2 = e2.right == null;
        if (m_1) {
            return m_2 ? op.MONO : op.MONO_DUAL;
        }
        return m_2 ? op.DUAL_MONO : op.DUAL;
    }

    public Equation mult_inverse() {
        Expression out_l = this.left.mult_inverse();
        Expression out_r = this.right != null ? this.right.mult_inverse() : null;
        return new Equation(out_l, out_r);
    }

    @Override
    public void serializeTo(PrintStream stream) {
        stream.println(this.toSerialString());
    }

    private static enum op {
        MONO,
        MONO_DUAL,
        DUAL_MONO,
        DUAL;

    }
}

