/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Calculations.MathB;
import BryceMath.Logic.Boolean_Logic;
import BryceMath.Numbers.BaseNumber;
import BryceMath.Numbers.ModularNumber;
import Data_Structures.ADTs.Pairable;
import Data_Structures.Structures.List;
import Data_Structures.Structures.UBA;
import java.util.Iterator;

public class IntB
extends ModularNumber<IntB>
implements Iterable<Boolean>,
Comparable<IntB> {
    private UBA<Boolean> data;
    private boolean positive = true;
    public static final IntB ZERO = new IntB(0);
    public static final IntB ONE = new IntB(1);
    public static final int MAX_FINITE_INT_VALUE = Integer.MAX_VALUE;
    public static final int MIN_FINITE_INT_VALUE = Integer.MIN_VALUE;

    public IntB(int input) {
        if (input == Integer.MIN_VALUE) {
            this.positive = false;
            this.data = new UBA(32);
            int i = 0;
            while (i < 31) {
                this.data.add(false);
                ++i;
            }
            this.data.add(true);
            return;
        }
        this.positive = input >= 0;
        input = Math.abs(input);
        int digit_num = (int)Math.max(MathB.logA(input, 2), 1.0);
        this.data = new UBA(digit_num);
        while (input > 0) {
            this.data.add(input % 2 == 1);
            input /= 2;
        }
    }

    public IntB(long input) {
        if (input == Long.MIN_VALUE) {
            this.positive = false;
            this.data = new UBA(64);
            int i = 0;
            while (i < 63) {
                this.data.add(false);
                ++i;
            }
            this.data.add(true);
            return;
        }
        this.positive = input >= 0L;
        input = Math.abs(input);
        int digit_num = (int)Math.max(MathB.logA(input, 2), 1.0);
        this.data = new UBA(digit_num);
        while (input > 0L) {
            this.data.add(input % 2L == 1L);
            input /= 2L;
        }
    }

    public IntB(String input) {
        char[] numbers = input.toCharArray();
        int len = numbers.length;
        if (len == 0) {
            this.data = new UBA();
            this.positive = true;
            return;
        }
        int i = 0;
        this.positive = true;
        if (numbers[0] == '-') {
            this.positive = false;
            ++i;
            if (len == 1) {
                throw new Error("Error : Invalid Number '-' ");
            }
        }
        BaseNumber binary = new BaseNumber(2);
        int k = i;
        while (k < len) {
            binary.mult(10);
            int digit = numbers[k] - 48;
            binary.add(digit);
            ++k;
        }
        char[] bits = binary.toString().toCharArray();
        len = bits.length;
        this.data = new UBA(len);
        int k2 = 0;
        while (k2 < len) {
            boolean bit = bits[len - 1 - k2] == '1';
            this.data.add(bit);
            ++k2;
        }
        this.compress();
    }

    private IntB(UBA<Boolean> input, boolean sign) {
        this.positive = sign;
        this.data = input;
    }

    @Override
    protected IntB N(long i) {
        if (i == 0L) {
            return ZERO;
        }
        if (i == 1L) {
            return ONE;
        }
        return new IntB(i);
    }

    public long toLong() {
        int len = this.num_digits();
        if (!this.positive && len == 64 && this.getNum1s() == 1) {
            return Long.MIN_VALUE;
        }
        if (len > 63) {
            throw new Error("ERROR: Longs can only hold 63 bits of information.");
        }
        long output = 0L;
        long mult = 1L;
        for (Boolean b : this.data) {
            if (b.booleanValue()) {
                output += mult;
            }
            mult *= 2L;
        }
        if (this.positive) {
            return output;
        }
        return -output;
    }

    @Override
    public int toInt() {
        int len = this.num_digits();
        if (!this.positive && len == 32 && this.getNum1s() == 1) {
            return Integer.MIN_VALUE;
        }
        if (len > 31) {
            throw new Error("ERROR: Ints can only hold 31 bits of information.");
        }
        int output = 0;
        int mult = 1;
        for (Boolean b : this.data) {
            if (b.booleanValue()) {
                output += mult;
            }
            mult *= 2;
        }
        if (this.positive) {
            return output;
        }
        return -output;
    }

    @Override
    public IntB neg() {
        if (this.eq(0)) {
            return ZERO;
        }
        return new IntB(this.data, !this.positive);
    }

    @Override
    public boolean isPositive() {
        return this.sign() == 1;
    }

    @Override
    public boolean isNegative() {
        return !this.positive;
    }

    @Override
    public boolean eq(IntB other) {
        if (this.positive != other.positive) {
            return false;
        }
        UBA<Boolean> data2 = other.data;
        int len = this.data.size();
        if (data2.size() != len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (this.data.get(i).booleanValue() != data2.get(i).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int compareTo(IntB other) {
        int len2;
        boolean s2;
        boolean s1 = this.sign() >= 0;
        boolean bl = s2 = other.sign() >= 0;
        if (s1 && !s2) {
            return 1;
        }
        if (!s1 && s2) {
            return -1;
        }
        if (!s1 && !s2) {
            return -1 * this.neg().compareTo(other.neg());
        }
        UBA<Boolean> data2 = other.data;
        int len1 = this.data.size();
        if (len1 < (len2 = data2.size())) {
            return -1;
        }
        if (len2 < len1) {
            return 1;
        }
        int len = len1;
        int i = len - 1;
        while (i >= 0) {
            boolean b2;
            boolean b1 = this.getDigit(i);
            if (b1 != (b2 = other.getDigit(i).booleanValue())) {
                if (b1) {
                    return 1;
                }
                return -1;
            }
            --i;
        }
        return 0;
    }

    @Override
    public IntB add(IntB other) {
        boolean positive2;
        int sign1 = this.sign();
        int sign2 = other.sign();
        if (sign1 == 0) {
            return other;
        }
        if (sign2 == 0) {
            return this;
        }
        boolean positive1 = sign1 == 1;
        boolean bl = positive2 = sign2 == 1;
        if (positive1 && !positive2) {
            return this.sub(other.neg());
        }
        if (!positive1 && positive2) {
            return other.sub(this.neg());
        }
        int len = Math.max(this.num_digits(), other.num_digits());
        UBA<Boolean> outputData = new UBA<Boolean>(len + 1);
        IntB output = new IntB(outputData, positive1);
        boolean carry = false;
        int d = 0;
        while (d < len) {
            int val = 0;
            if (carry) {
                val = (short)(val + 1);
            }
            if (this.getDigit(d).booleanValue()) {
                val = (short)(val + 1);
            }
            if (other.getDigit(d).booleanValue()) {
                val = (short)(val + 1);
            }
            output.setDigit(d, val % 2 == 1);
            carry = val > 1;
            ++d;
        }
        if (carry) {
            output.setDigit(len, true);
        }
        return output;
    }

    @Override
    public IntB sub(IntB other) {
        boolean output_positive;
        IntB smaller;
        IntB bigger;
        int sign1 = this.sign();
        int sign2 = other.sign();
        if (sign1 == 0) {
            return other.neg();
        }
        if (sign2 == 0) {
            return this;
        }
        if (sign1 != sign2) {
            return this.add(other.neg());
        }
        int comp = this.abs(this).compareTo(this.abs(other));
        if (comp == 0) {
            return ZERO;
        }
        if (comp < 0) {
            bigger = other.clone();
            smaller = this;
            output_positive = !bigger.positive;
        } else {
            bigger = this.clone();
            smaller = other;
            output_positive = bigger.positive;
        }
        int len = smaller.num_digits();
        int i = 0;
        while (i < len) {
            boolean b2 = smaller.getDigit(i);
            if (b2) {
                boolean b1 = bigger.getDigit(i);
                if (b1) {
                    bigger.setDigit(i, false);
                } else {
                    bigger.setDigit(i, true);
                    while (true) {
                        if (bigger.getDigit(i + 1).booleanValue()) {
                            bigger.setDigit(i + 1, false);
                            break;
                        }
                        boolean nDigit = smaller.getDigit(++i) == false;
                        bigger.setDigit(i, nDigit);
                    }
                }
            }
            ++i;
        }
        IntB output = bigger;
        output.compress();
        output.positive = output_positive;
        return output;
    }

    Boolean getDigit(int digitNum) {
        if (digitNum < 0) {
            throw new Error("Error: Negative digits do not exist.");
        }
        int len = this.data.size();
        if (digitNum < len) {
            return this.data.get(digitNum);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private void setDigit(int digitNum, Boolean digit) {
        if (digitNum < 0) {
            throw new Error("Error: Negative digits do not exist, and therefore cannot be set.");
        }
        len = this.data.size();
        if (digitNum < len) {
            this.data.set(digitNum, digit);
            this.compress();
            return;
        }
        if (digit.booleanValue()) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            this.data.add(false);
            ++len;
lbl12:
            // 2 sources

            ** while (len < digitNum)
        }
lbl13:
        // 1 sources

        this.data.add(true);
    }

    private void compress() {
        int len = this.data.size();
        int i = len - 1;
        while (i >= 0) {
            if (this.getDigit(i).booleanValue()) {
                return;
            }
            this.data.rem();
            --i;
        }
    }

    @Override
    public String toString() {
        return this.toBase(10);
    }

    public String toBase(int n) {
        BaseNumber output = new BaseNumber(n);
        if (!this.positive) {
            output.neg();
        }
        int len = this.data.size();
        int i = 0;
        while (i < len) {
            output.mult(2);
            if (this.getDigit(len - 1 - i).booleanValue()) {
                output.add(1);
            }
            ++i;
        }
        return output.toString();
    }

    @Override
    public IntB zero() {
        return ZERO;
    }

    @Override
    public IntB one() {
        return ONE;
    }

    @Override
    public IntB mult(IntB input) {
        IntB smaller;
        IntB bigger;
        boolean output_sign;
        IntB in1 = this;
        IntB in2 = input;
        int s1 = in1.sign();
        int s2 = in2.sign();
        if (s1 == 0 || s2 == 0) {
            return ZERO;
        }
        boolean b1 = s1 == 1;
        boolean b2 = s2 == 1;
        boolean bl = output_sign = !Boolean_Logic.xor(b1, b2);
        if (this.abs(in1).eq(ONE)) {
            IntB output = this.abs(in2);
            if (output_sign) {
                return output;
            }
            return output.neg();
        }
        if (this.abs(in2).eq(ONE)) {
            IntB output = this.abs(in1);
            if (output_sign) {
                return output;
            }
            return output.neg();
        }
        IntB output = ZERO;
        if (in1.getNum1s() < in2.getNum1s()) {
            bigger = in2;
            smaller = in1;
        } else {
            bigger = in1;
            smaller = in2;
        }
        IntB adder = this.abs(bigger).clone();
        for (boolean b : smaller) {
            if (b) {
                output = output.add(adder);
            }
            adder = adder.bitShiftL();
        }
        if (output_sign) {
            return output;
        }
        return output.neg();
    }

    public IntB clone() {
        return new IntB(this.data.copy(), this.positive);
    }

    public IntB bitShiftL() {
        IntB output = this.clone();
        output.mult2();
        return output;
    }

    public IntB bitShiftR() {
        IntB output = this.clone();
        output.div2();
        return output;
    }

    private void mult2() {
        this.data.prepend(false);
    }

    private void div2() {
        this.data.deq();
    }

    public IntB AND(IntB input) {
        int digits2;
        IntB i1 = this;
        IntB i2 = input;
        int digits1 = i1.num_digits();
        int len = Math.min(digits1, digits2 = i2.num_digits());
        if (len == 0) {
            return ZERO;
        }
        UBA<Boolean> output_data = new UBA<Boolean>(len);
        int i = 0;
        while (i < len) {
            output_data.add(i1.getDigit(i) != false && i2.getDigit(i) != false);
            ++i;
        }
        boolean output_sign = i1.positive && i2.positive;
        IntB output = new IntB(output_data, output_sign);
        output.compress();
        return output;
    }

    public IntB AND(int input) {
        return this.AND(this.N(input));
    }

    public IntB OR(IntB input) {
        int digits2;
        IntB i1 = this;
        IntB i2 = input;
        int digits1 = i1.num_digits();
        int len = Math.max(digits1, digits2 = i2.num_digits());
        if (len == 0) {
            return ZERO;
        }
        UBA<Boolean> output_data = new UBA<Boolean>(len);
        int i = 0;
        while (i < len) {
            output_data.add(i1.getDigit(i) != false || i2.getDigit(i) != false);
            ++i;
        }
        boolean output_sign = i1.positive || i2.positive;
        IntB output = new IntB(output_data, output_sign);
        output.compress();
        return output;
    }

    public IntB OR(int input) {
        return this.OR(this.N(input));
    }

    public IntB XOR(IntB input) {
        int digits2;
        IntB i1 = this;
        IntB i2 = input;
        int digits1 = i1.num_digits();
        int len = Math.max(digits1, digits2 = i2.num_digits());
        if (len == 0) {
            return ZERO;
        }
        UBA<Boolean> output_data = new UBA<Boolean>(len);
        int i = 0;
        while (i < len) {
            output_data.add(Boolean_Logic.xor(i1.getDigit(i), i2.getDigit(i)));
            ++i;
        }
        boolean output_sign = Boolean_Logic.xor(i1.positive, i2.positive);
        IntB output = new IntB(output_data, output_sign);
        output.compress();
        return output;
    }

    public IntB XOR(int input) {
        return this.XOR(this.N(input));
    }

    int getNum1s() {
        int output = 0;
        for (boolean b : this) {
            if (!b) continue;
            ++output;
        }
        return output;
    }

    public int num_digits() {
        return this.data.size();
    }

    @Override
    public Pairable<IntB> division(IntB input) {
        boolean quotient_sign;
        if (input.eq(ZERO)) {
            throw new Error("Cannot divide or modulo by zero");
        }
        if (input.eq(ONE)) {
            List<IntB> output = new List<IntB>();
            output.add(this);
            output.add(ZERO);
            return output;
        }
        IntB quotient = ZERO.clone();
        IntB remainder = ZERO.clone();
        IntB numerator = this.abs(this);
        IntB divisor = this.abs(input);
        int len = Math.max(numerator.num_digits(), divisor.num_digits());
        int i = len - 1;
        while (i >= 0) {
            remainder = remainder.bitShiftL();
            remainder.setDigit(0, numerator.getDigit(i));
            if (remainder.compareTo(divisor) >= 0) {
                remainder = remainder.sub(divisor);
                quotient.setDigit(i, true);
            }
            --i;
        }
        List<IntB> output = new List<IntB>();
        IntB signed_numerator = this;
        IntB signed_divisor = input;
        boolean bl = quotient_sign = !Boolean_Logic.xor(signed_numerator.positive, signed_divisor.positive);
        if (quotient_sign) {
            if (!signed_numerator.positive) {
                remainder = remainder.neg();
            }
        } else {
            quotient = quotient.neg();
            remainder = remainder.sub(divisor);
            if (signed_divisor.positive) {
                remainder = remainder.neg();
            }
        }
        output.add(quotient);
        output.add(remainder);
        return output;
    }

    @Override
    public IntB sqrt() {
        throw new Error("Square root not implemented");
    }

    private IntB abs(IntB input) {
        if (!input.positive) {
            return input.neg();
        }
        return input;
    }

    @Override
    public IntB abs() {
        if (this.positive) {
            return this;
        }
        return this.neg();
    }

    @Override
    public boolean eq(int other) {
        return this.eq(this.N(other));
    }

    @Override
    public int sign() {
        if (this.eq(0)) {
            return 0;
        }
        if (this.positive) {
            return 1;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        int add = 1;
        int output = 0;
        for (boolean b : this) {
            if (b) {
                output += add;
            }
            add *= 2;
        }
        return output;
    }

    @Override
    public Iterator<Boolean> iterator() {
        return this.data.iterator();
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    public IntB toIntB() {
        return this;
    }
}

