/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Numbers.IntB;
import java.io.PrintStream;
import util.SerialB;

public abstract class Number<T>
implements SerialB,
Comparable<T> {
    abstract T N(long var1);

    public abstract T zero();

    public abstract T one();

    public abstract T add(T var1);

    public T add(int input) {
        return this.add(this.N(input));
    }

    public abstract T sub(T var1);

    public T sub(int input) {
        return this.sub(this.N(input));
    }

    public abstract T mult(T var1);

    public T mult(int input) {
        return this.mult(this.N(input));
    }

    public abstract T div(T var1);

    public T div(int input) {
        return this.div(this.N(input));
    }

    public abstract T sqrt();

    public T sqr() {
        Number number = this;
        return (T)this.mult(number);
    }

    public T pow(int pow) {
        return this.pow(new IntB(pow));
    }

    public T pow(IntB pow) {
        if (pow.isNegative()) {
            throw new Error("Negative powers are not supported.");
        }
        if (pow.eq(0)) {
            return this.one();
        }
        if (pow.eq(1)) {
            return (T)this;
        }
        IntB binary = pow;
        int len = binary.num_digits() + 1;
        Number output_product = (Number)this.one();
        Number factor = this;
        int i = 0;
        while (i < len) {
            if (binary.getDigit(i).booleanValue()) {
                output_product = output_product.mult(factor);
            }
            if (i < len - 1) {
                factor = (Number)factor.sqr();
            }
            ++i;
        }
        return (T)output_product;
    }

    public abstract boolean eq(T var1);

    public boolean eq(int input) {
        return this.eq(this.N(input));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return this.equals(this.zero());
        }
        if (other instanceof Integer) {
            return this.eq((Integer)other);
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.eq(other);
    }

    public abstract int hashCode();

    public abstract String toString();

    public String toCoef() {
        String str = this.toString();
        if (str.equals("1")) {
            return "";
        }
        if (str.equals("-1")) {
            return "-";
        }
        if (str.contains("+") || str.substring(1).contains("-")) {
            return "(" + str + ")";
        }
        return String.valueOf(str);
    }

    public abstract T neg();

    public T conj() {
        return (T)this;
    }

    public abstract boolean isNegative();

    public abstract boolean isPositive();

    public abstract int sign();

    public abstract T abs();

    @Override
    public void serializeTo(PrintStream stream) {
        throw new Error("Serialization of " + this.getClass() + "is not yet supported!");
    }

    @Override
    public String getSerialName() {
        return this.getClass().toString();
    }

    @Override
    public int compareTo(T other) {
        throw new Error("Comparisons of " + this.getClass() + "is not yet supported!");
    }

    public abstract boolean isInt();

    public abstract IntB toIntB();

    public abstract int toInt();
}

