/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Numbers.IntB;
import BryceMath.Numbers.Number;
import util.testing;

public class Rational
extends Number<Rational>
implements Comparable<Rational> {
    private IntB num;
    private IntB denom;
    public static final Rational ZERO = new Rational(0L);
    public static final Rational ONE = new Rational(1L);

    public Rational(IntB numerator, IntB denominator) {
        this.num = numerator;
        this.denom = denominator;
        this.simplify();
    }

    public Rational(long numerator, long denominator) {
        this.num = this.I(numerator);
        this.denom = this.I(denominator);
        this.simplify();
    }

    public Rational(IntB numerator) {
        this.num = numerator;
        this.denom = IntB.ONE;
    }

    public Rational(long numerator) {
        this.num = this.I(numerator);
        this.denom = IntB.ONE;
    }

    public Rational(String str) {
        String[] parts = str.split("/");
        int len = parts.length;
        if (len > 1) {
            Rational r1 = new Rational(parts[0]);
            int i = 1;
            while (i < len) {
                r1 = r1.div(new Rational(parts[i]));
                ++i;
            }
            this.num = r1.num;
            this.denom = r1.denom;
            return;
        }
        testing.ASSERT(len == 1);
        str = parts[0];
        parts = str.split("\\.");
        if (parts.length == 0) {
            this.num = IntB.ZERO;
            this.denom = IntB.ONE;
            return;
        }
        IntB pi = new IntB(parts[0]);
        if (parts.length < 2) {
            this.num = pi;
            this.denom = IntB.ONE;
            return;
        }
        len = parts[1].length();
        StringBuilder sb = new StringBuilder();
        sb.append("1");
        int i = 0;
        while (i < len) {
            sb.append("0");
            ++i;
        }
        this.num = new IntB(String.valueOf(parts[0]) + parts[1]);
        this.denom = new IntB(sb.toString());
        this.simplify();
    }

    public Rational(double input) {
        String s = "" + input % 1.0;
        int len = s.length();
        this.denom = this.I(1L);
        this.num = this.I((long)input);
        input %= 1.0;
        int i = 1;
        while (i < len - 1) {
            this.num = (IntB)this.num.mult(10);
            this.denom = (IntB)this.denom.mult(10);
            this.num = this.num.add(this.I((long)(input *= 10.0)));
            input %= 1.0;
            ++i;
        }
        this.simplify();
    }

    @Override
    public Rational one() {
        return ONE;
    }

    @Override
    public Rational zero() {
        return ZERO;
    }

    @Override
    public Rational add(Rational input) {
        if (input.eq(ZERO)) {
            return this;
        }
        if (this.eq(ZERO)) {
            return input;
        }
        Rational r1 = this.clone();
        Rational r2 = input.clone();
        IntB denom_out = this.normilize_denominators(r1, r2);
        Rational output = new Rational(r1.getNum().add(r2.getNum()), denom_out);
        return output;
    }

    @Override
    public Rational sub(Rational input) {
        if (input.eq(ZERO)) {
            return this;
        }
        if (this.eq(ZERO)) {
            return input.neg();
        }
        Rational r1 = this.clone();
        Rational r2 = input.clone();
        IntB denom_out = this.normilize_denominators(r1, r2);
        Rational output = new Rational(r1.getNum().sub(r2.getNum()), denom_out);
        return output;
    }

    @Override
    public Rational neg() {
        return new Rational(this.num.neg(), this.denom);
    }

    @Override
    public Rational mult(Rational r) {
        Rational output = new Rational(this.num.mult(r.getNum()), this.denom.mult(r.getDenom()));
        return output.simplify();
    }

    @Override
    public Rational div(Rational r) {
        if (r.eq(ZERO)) {
            throw new Error("Cannot divide Rationals by 0");
        }
        Rational output = new Rational(this.num.mult(r.getDenom()), this.denom.mult(r.getNum()));
        return output.simplify();
    }

    public Rational mod(Rational input) {
        if (input.eq(ZERO)) {
            throw new Error("Cannot mod Rationals by 0");
        }
        Rational r1 = this.clone();
        Rational r2 = input.clone();
        IntB denom_out = this.normilize_denominators(r1, r2);
        Rational output = new Rational(r1.getNum().mod(r2.getNum()), denom_out);
        return output;
    }

    @Override
    public int compareTo(Rational input) {
        Rational r1 = this.clone();
        Rational r2 = input.clone();
        this.normilize_denominators(r1, r2);
        IntB n1 = r1.getNum();
        IntB n2 = r2.getNum();
        return n1.compareTo(n2);
    }

    @Override
    public Rational sqrt() {
        throw new Error("Unimplemented.");
    }

    @Override
    public boolean eq(Rational other) {
        return this.num.eq(other.num) && this.denom.eq(other.denom);
    }

    private Rational simplify() {
        if (this.denom.eq(0)) {
            throw new Error("Rationals cannot have denominators equal to 0!");
        }
        IntB gcd = Rational.Euclid(this.num, this.denom);
        this.num = this.num.div(gcd);
        this.denom = this.denom.div(gcd);
        if (this.denom.isNegative()) {
            this.num = this.num.neg();
            this.denom = this.denom.neg();
        }
        return this;
    }

    private IntB normilize_denominators(Rational r1, Rational r2) {
        IntB denom1 = r1.getDenom();
        IntB denom2 = r2.getDenom();
        IntB lcm = Rational.LCM(denom1, denom2);
        IntB scalar1 = lcm.div(denom1);
        IntB scalar2 = lcm.div(denom2);
        r1.scale(scalar1);
        r2.scale(scalar2);
        return lcm;
    }

    private void scale(IntB scale) {
        this.num = this.num.mult(scale);
        this.denom = this.denom.mult(scale);
    }

    private static IntB Euclid(IntB a, IntB b) {
        a = a.abs();
        b = b.abs();
        while (!b.eq(0)) {
            IntB c = b;
            b = a.mod(b);
            a = c;
        }
        return a;
    }

    public static IntB LCM(IntB a, IntB b) {
        return a.mult(b).div(Rational.Euclid(a, b));
    }

    @Override
    public boolean isInt() {
        return this.denom.equals(IntB.ONE);
    }

    public IntB getNum() {
        return this.num;
    }

    public IntB getDenom() {
        return this.denom;
    }

    @Override
    public int sign() {
        return this.num.sign();
    }

    public Rational mult_inverse() {
        return new Rational(this.denom, this.num);
    }

    public IntB part_int() {
        return this.num.div(this.denom);
    }

    public Rational part_frac() {
        Rational output = new Rational(this.num.abs().mod(this.denom), this.denom);
        if (this.num.isNegative()) {
            return output.neg();
        }
        return output;
    }

    @Override
    public boolean isPositive() {
        return this.num.isPositive();
    }

    @Override
    public boolean isNegative() {
        return this.num.isNegative();
    }

    @Override
    public Rational abs() {
        if (this.isNegative()) {
            return this.neg();
        }
        return this;
    }

    public Rational clone() {
        return new Rational(this.num, this.denom);
    }

    @Override
    public int hashCode() {
        return this.num.hashCode() + this.denom.hashCode();
    }

    public double toDouble() {
        return (double)this.num.toLong() * 1.0 / (double)this.denom.toLong();
    }

    @Override
    Rational N(long n) {
        if (n == 0L) {
            return ZERO;
        }
        if (n == 1L) {
            return ONE;
        }
        return new Rational(n);
    }

    private IntB I(long i) {
        return IntB.ONE.N(i);
    }

    @Override
    public IntB toIntB() {
        return this.num;
    }

    @Override
    public int toInt() {
        return this.num.toInt();
    }

    @Override
    public String toString() {
        if (this.denom.equals(IntB.ONE)) {
            return "" + this.num;
        }
        return "\\frac{" + this.num + "}{" + this.denom + "}";
    }

    public String toSerialString() {
        if (this.denom.eq(1)) {
            return this.num.toString();
        }
        return "(" + this.num + ")/(" + this.denom + ")";
    }
}

