/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Structures;

import BryceMath.Numbers.Number;
import BryceMath.Structures.Vector;
import Data_Structures.Structures.Pair;
import java.io.PrintStream;
import util.Genarics;
import util.SerialB;

public class Matrix<T extends Number<T>>
implements SerialB {
    private T[][] data;
    private final int m;
    private final int n;
    private boolean ge_form = false;
    private boolean ge1_form = false;
    private boolean echelon_form = false;
    private int rank = -1;
    private Genarics<T> ge_t = new Genarics();
    private Genarics<Vector<T>> ge_v = new Genarics();
    private Genarics<Matrix<T>> ge_m = new Genarics();

    public Matrix(Vector<T> ... rows) {
        this.m = rows.length;
        this.n = rows[0].length;
        this.data = (Number[][])this.ge_t.Array_2d(this.m, this.n, rows[0].get(0));
        int c = 0;
        while (c < this.n) {
            int r = 0;
            while (r < this.m) {
                this.data[r][c] = rows[r].get(c);
                ++r;
            }
            ++c;
        }
    }

    public Matrix(boolean want_cols, Vector<T> ... cols) {
        this.n = cols.length;
        this.m = cols[0].length;
        this.data = (Number[][])this.ge_t.Array_2d(this.m, this.n, cols[0].get(0));
        int c = 0;
        while (c < this.n) {
            int r = 0;
            while (r < this.m) {
                this.data[r][c] = cols[c].get(r);
                ++r;
            }
            ++c;
        }
    }

    public Matrix(T[][] data) {
        this.data = data;
        this.m = data.length;
        this.n = data[0].length;
    }

    public Matrix<T> transpose() {
        return new Matrix<T>(this.columns());
    }

    public Matrix<T> conjugate() {
        Object output = this.clone();
        int r = 0;
        while (r < this.m) {
            int c = 0;
            while (c < this.n) {
                ((Matrix)output).data[r][c] = (Number)((Number)((Matrix)output).data[r][c]).conj();
                ++c;
            }
            ++r;
        }
        return output;
    }

    public Matrix<T> conjugateTranspose() {
        throw new Error("Implement Me Please!");
    }

    public Matrix<T> clone() {
        return new Matrix<T>(this.rows());
    }

    public T det() {
        if (this.m != this.n) {
            throw new Error("ERROR: Determinant only defined for square matrices.");
        }
        Matrix<T> reduced = this.ge();
        Number result = (Number)((Number)this.data[0][0]).one();
        int c = 0;
        while (c < this.n) {
            result = (Number)result.mult(reduced.get(c, c));
            ++c;
        }
        return (T)result;
    }

    public T trace() {
        if (this.m != this.n) {
            throw new Error("ERROR: Trace only defined for square matrices.");
        }
        Number result = (Number)((Number)this.data[0][0]).zero();
        int c = 0;
        while (c < this.n) {
            result = (Number)result.add(this.get(c, c));
            ++c;
        }
        return (T)result;
    }

    public int getRank() {
        if (this.rank < 0) {
            this.rank = this.ge().rank;
        }
        return this.rank;
    }

    public Matrix<T> inverse() {
        if (this.m != this.n) {
            throw new Error("ERROR: Non-sqaure matrices have no inverse.");
        }
        if (((Number)this.det()).eq(0)) {
            return null;
        }
        Matrix<T> A = this.appendCol(this.identity(this.m).columns());
        A = A.echelon();
        Vector<T>[] output = this.ge_v.Array(this.m, this.getCol(0));
        int c = 0;
        while (c < this.n) {
            output[c] = A.getCol(this.n + c);
            ++c;
        }
        return new Matrix<T>(true, output);
    }

    public Vector<T> solve(Vector<T> b) {
        Matrix<T> A = this.appendCol(b);
        A = A.echelon();
        return A.getCol(this.n);
    }

    public Matrix<T>[] LDU() {
        Matrix<T> D;
        Matrix<T> L = this.identity(this.m);
        Matrix<T> U = this.ge2(L, D = this.identity(this.m));
        if (U == null) {
            return null;
        }
        Matrix[] output = this.ge_m.Array(3, this);
        output[0] = L;
        output[1] = D;
        output[2] = U;
        return output;
    }

    public Matrix<T>[] QR() {
        throw new Error("Not yet Implemented.");
    }

    public Matrix<T> mult(Matrix<T> other) {
        if (this.n != other.m) {
            throw new Error("Error : Invalid Matrix dimensions for proper multiplication");
        }
        Vector<T>[] rows = this.rows();
        Vector<T>[] cols = other.columns();
        int row_num = rows.length;
        int col_num = cols.length;
        Number[][] data = (Number[][])this.ge_t.Array_2d(row_num, col_num, this.data[0][0]);
        int r = 0;
        while (r < row_num) {
            int c = 0;
            while (c < col_num) {
                data[r][c] = rows[r].dot(cols[c]);
                ++c;
            }
            ++r;
        }
        return new Matrix(data);
    }

    public Matrix<T> add(Matrix<T> other) {
        if (this.m != other.m || this.n != other.n) {
            throw new Error("Error : Dimensions do not match");
        }
        Number[][] data_new = (Number[][])this.ge_t.Array_2d(this.m, this.n, this.get(0, 0));
        int r = 0;
        while (r < this.m) {
            int c = 0;
            while (c < this.n) {
                data_new[r][c] = (Number)((Number)this.data[r][c]).add(other.data[r][c]);
                ++c;
            }
            ++r;
        }
        return new Matrix(data_new);
    }

    public Matrix<T> sub(Matrix<T> other) {
        if (this.m != other.m || this.n != other.n) {
            throw new Error("Error : Dimensions do not match");
        }
        Number[][] data_new = (Number[][])this.ge_t.Array_2d(this.m, this.n, this.get(0, 0));
        int r = 0;
        while (r < this.m) {
            int c = 0;
            while (c < this.n) {
                data_new[r][c] = (Number)((Number)this.data[r][c]).sub(other.data[r][c]);
                ++c;
            }
            ++r;
        }
        return new Matrix(data_new);
    }

    public Matrix<T> div(T scalar) {
        Number[][] data_new = (Number[][])this.ge_t.Array_2d(this.m, this.n, this.get(0, 0));
        int r = 0;
        while (r < this.m) {
            int c = 0;
            while (c < this.n) {
                data_new[r][c] = (Number)((Number)this.data[r][c]).div(scalar);
                ++c;
            }
            ++r;
        }
        return new Matrix(data_new);
    }

    public Matrix<T> mult(T scalar) {
        Number[][] data_new = (Number[][])this.ge_t.Array_2d(this.m, this.n, this.get(0, 0));
        int r = 0;
        while (r < this.m) {
            int c = 0;
            while (c < this.n) {
                data_new[r][c] = (Number)((Number)this.data[r][c]).mult(scalar);
                ++c;
            }
            ++r;
        }
        return new Matrix(data_new);
    }

    public Matrix<T> echelon() {
        if (this.echelon_form) {
            return this;
        }
        Matrix<T> A = this.ge1();
        Vector<T>[] rows = A.rows();
        int r = this.m - 1;
        while (r > 0) {
            int c = 0;
            boolean found = true;
            while (((Number)rows[r].get(c)).eq(0)) {
                if (++c != this.n) continue;
                found = false;
                break;
            }
            if (!found) break;
            int r2 = r - 1;
            while (r2 >= 0) {
                rows[r2] = rows[r2].sub(rows[r].mult(rows[r2].get(c)));
                --r2;
            }
            --r;
        }
        Matrix<T> output = new Matrix<T>(rows);
        output.echelon_form = true;
        output.ge1_form = true;
        output.ge_form = true;
        this.rank = A.rank;
        return output;
    }

    public Matrix<T> ge() {
        if (this.ge_form) {
            return this;
        }
        Object[] rows = this.rows();
        int c = 0;
        int rank = 0;
        int r = 0;
        while (r < this.m && c < this.n) {
            int r2 = r + 1;
            boolean pivot_found = true;
            if (((Number)rows[r].get(c)).eq(0)) {
                pivot_found = false;
                while (r2 < this.m) {
                    if (!((Number)rows[r2].get(c)).eq(0)) {
                        Matrix.swap(rows, r, r2);
                        ++r2;
                        pivot_found = true;
                        break;
                    }
                    ++r2;
                }
            }
            if (!pivot_found) {
                --r;
                ++c;
            } else {
                T pivot = rows[r].get(c);
                ++rank;
                Vector temp = rows[r].div(pivot);
                while (r2 < this.m) {
                    rows[r2] = ((Vector)rows[r2]).sub(temp.mult(((Vector)rows[r2]).get(c)));
                    ++r2;
                }
                ++c;
            }
            ++r;
        }
        Matrix<T> output = new Matrix<T>((Vector<T>[])rows);
        output.ge_form = true;
        output.rank = rank;
        return output;
    }

    public Matrix<T> ge1() {
        if (this.ge1_form) {
            return this;
        }
        Object[] rows = this.rows();
        int c = 0;
        int rank = 0;
        int r = 0;
        while (r < this.m && c < this.n) {
            int r2 = r + 1;
            boolean pivot_found = true;
            if (((Number)rows[r].get(c)).eq(0)) {
                pivot_found = false;
                while (r2 < this.m) {
                    if (!((Number)rows[r2].get(c)).eq(0)) {
                        Matrix.swap(rows, r, r2);
                        ++r2;
                        pivot_found = true;
                        break;
                    }
                    ++r2;
                }
            }
            if (!pivot_found) {
                --r;
                ++c;
            } else {
                Vector temp;
                T pivot = rows[r].get(c);
                ++rank;
                rows[r] = temp = rows[r].div(pivot);
                while (r2 < this.m) {
                    rows[r2] = ((Vector)rows[r2]).sub(temp.mult(((Vector)rows[r2]).get(c)));
                    ++r2;
                }
                ++c;
            }
            ++r;
        }
        Matrix<T> output = new Matrix<T>((Vector<T>[])rows);
        output.ge1_form = true;
        output.ge_form = true;
        output.rank = rank;
        return output;
    }

    private Matrix<T> ge2(Matrix<T> L, Matrix<T> D) {
        if (this.ge1_form) {
            return this;
        }
        Vector<T>[] rows = this.rows();
        int c = 0;
        int rank = 0;
        int r = 0;
        while (r < this.m && c < this.n) {
            int r2 = r + 1;
            boolean pivot_found = true;
            if (((Number)rows[r].get(c)).eq(0)) {
                pivot_found = false;
                while (r2 < this.m) {
                    if (!((Number)rows[r2].get(c)).eq(0)) {
                        return null;
                    }
                    ++r2;
                }
            }
            if (!pivot_found) {
                --r;
                ++c;
            } else {
                T pivot = rows[r].get(c);
                D.data[r][r] = pivot;
                ++rank;
                Vector<T> temp = rows[r].div(pivot);
                rows[r] = temp;
                while (r2 < this.m) {
                    L.data[r2][r] = (Number)((Number)rows[r2].get(c)).div(pivot);
                    rows[r2] = rows[r2].sub(temp.mult(rows[r2].get(c)));
                    ++r2;
                }
                ++c;
            }
            ++r;
        }
        Matrix<T> output = new Matrix<T>(rows);
        output.ge1_form = true;
        output.ge_form = true;
        output.rank = rank;
        return output;
    }

    public Vector<T>[] columns() {
        Vector<T>[] output = this.ge_v.Array(this.n, this.getCol(0));
        int c = 0;
        while (c < this.n) {
            Number[] temp = (Number[])this.ge_t.Array(this.m, this.data[0][0]);
            int r = 0;
            while (r < this.m) {
                temp[r] = this.data[r][c];
                ++r;
            }
            output[c] = new Vector(temp);
            ++c;
        }
        return output;
    }

    public Vector<T>[] rows() {
        Vector<T>[] output = this.ge_v.Array(this.m, this.getCol(0));
        int r = 0;
        while (r < this.m) {
            Number[] temp = (Number[])this.ge_t.Array(this.n, this.data[0][0]);
            int c = 0;
            while (c < this.n) {
                temp[c] = this.data[r][c];
                ++c;
            }
            output[r] = new Vector(temp);
            ++r;
        }
        return output;
    }

    public Vector<T> getRow(int r) {
        Number[] output = (Number[])this.ge_t.Array(this.n, this.data[0][0]);
        int c = 0;
        while (c < this.n) {
            output[c] = this.data[r][c];
            ++c;
        }
        return new Vector(output);
    }

    public Vector<T> getCol(int c) {
        Number[] output = (Number[])this.ge_t.Array(this.m, this.data[0][0]);
        int r = 0;
        while (r < this.m) {
            output[r] = this.data[r][c];
            ++r;
        }
        return new Vector(output);
    }

    public Matrix<T> appendCol(Vector<T> ... new_c) {
        Vector<T>[] output = this.ge_v.Array(this.n + new_c.length, new_c[0]);
        int c = 0;
        while (c < this.n) {
            output[c] = this.getCol(c);
            ++c;
        }
        c = 0;
        while (c < new_c.length) {
            output[this.n + c] = new_c[c];
            ++c;
        }
        return new Matrix<T>(true, output);
    }

    public Matrix<T> appendRow(Vector<T> ... new_r) {
        Vector<T>[] output = this.ge_v.Array(this.m + new_r.length, this.getCol(0));
        int r = 0;
        while (r < this.m) {
            output[r] = this.getRow(r);
            ++r;
        }
        r = 0;
        while (r < new_r.length) {
            output[this.n + r] = new_r[r];
            ++r;
        }
        return new Matrix<T>(output);
    }

    public T get(int r, int c) {
        return this.data[r][c];
    }

    public Matrix<T> identity(int size) {
        Number[][] data = (Number[][])this.ge_t.Array_2d(size, size, this.data[0][0]);
        int r = 0;
        while (r < size) {
            int c = 0;
            while (c < size) {
                data[r][c] = (Number)((Number)this.data[0][0]).zero();
                ++c;
            }
            ++r;
        }
        int i = 0;
        while (i < size) {
            data[i][i] = (Number)((Number)this.data[0][0]).one();
            ++i;
        }
        Matrix output = new Matrix(data);
        output.ge_form = true;
        output.ge1_form = true;
        output.echelon_form = true;
        return output;
    }

    public boolean eq(Matrix<T> other) {
        if (other.m != this.m || other.n != this.n) {
            return false;
        }
        int c = 0;
        while (c < this.n) {
            int r = 0;
            while (r < this.m) {
                if (!((Number)this.data[r][c]).eq(other.data[r][c])) {
                    return false;
                }
                ++r;
            }
            ++c;
        }
        return true;
    }

    public static void swap(Object[] data, int index_1, int index_2) {
        Object temp = data[index_1];
        data[index_1] = data[index_2];
        data[index_2] = temp;
    }

    public String toString() {
        Vector<T>[] rows;
        String output = "Matrix [Rows: " + this.m + ", Columns: " + this.n + "]\n";
        Vector<T>[] vectorArray = rows = this.rows();
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            Vector<T> r = vectorArray[n2];
            output = String.valueOf(output) + r + '\n';
            ++n2;
        }
        return output;
    }

    public int getRowNum() {
        return this.m;
    }

    public int getColNum() {
        return this.n;
    }

    public boolean inRowEchelonForm() {
        int c_min = 0;
        int r = 0;
        while (r < this.m) {
            int c = 0;
            while (c < c_min) {
                if (!((Number)this.get(r, c)).eq(0)) {
                    return false;
                }
                ++c;
            }
            while (c_min < this.n && ((Number)this.get(r, ++c_min - 1)).eq(0)) {
            }
            ++r;
        }
        return true;
    }

    public boolean hasZeroRow() {
        Vector<T>[] rows = this.rows();
        Number zero = (Number)((Number)rows[0].get(0)).zero();
        Vector<T>[] vectorArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            Vector<T> row = vectorArray[n2];
            if (row.dot(row).eq((Number)zero)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Pair<Matrix<T>, T> cofactor(int minor_r, int minor_c) {
        if (this.m < 2 || this.n < 2) {
            throw new Error("Cannot cofactor a matrice with only 1 row or column");
        }
        boolean sign = (minor_r + minor_c) % 2 == 0;
        Number scalar = sign ? (Number)((Number)this.get(0, 0)).one() : (Number)((Number)((Number)this.get(0, 0)).one()).mult(-1);
        Number[][] output = (Number[][])this.ge_t.Array_2d(this.m - 1, this.n - 1, this.data[0][0]);
        int y = 0;
        int r = 0;
        while (r < this.m) {
            if (r != minor_r) {
                int x = 0;
                int c = 0;
                while (c < this.n) {
                    if (c != minor_c) {
                        output[y][x] = this.data[r][c];
                        ++x;
                    }
                    ++c;
                }
                ++y;
            }
            ++r;
        }
        return new Pair<Matrix, Number>(new Matrix(output), scalar);
    }

    @Override
    public void serializeTo(PrintStream stream) {
        int rowNum = this.getRowNum();
        int colNum = this.getColNum();
        stream.println(rowNum);
        stream.println(colNum);
        int r = 0;
        while (r < rowNum) {
            int c = 0;
            while (c < colNum) {
                T exp = this.get(r, c);
                ((Number)exp).serializeTo(stream);
                ++c;
            }
            ++r;
        }
    }

    @Override
    public String getSerialName() {
        return "Matrix";
    }

    public boolean isTrivial() {
        return this.m == 1 && this.n == 1;
    }

    public boolean canVectorDotWith(Matrix<T> other) {
        int m = this.m;
        int n = other.n;
        return m != n && (m == 1 || n == 1) && m == other.m && this.n == n;
    }
}

