/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Structures;

import BryceMath.Numbers.Number;
import Data_Structures.Structures.UBA;
import java.util.Iterator;
import util.Genarics;

public class Vector<T extends Number<T>>
implements Iterable<T> {
    public UBA<T> data;
    public final int length;
    private T magnitude;
    private boolean magChanged;
    private Genarics<T> ge_T = new Genarics();

    public Vector(T ... input) {
        this.length = input.length;
        this.data = new UBA(this.length);
        T[] TArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            T val = TArray[n2];
            this.data.add(val);
            ++n2;
        }
        this.magChanged = true;
    }

    public Vector(UBA<T> input) {
        this.length = input.size();
        this.data = input.copy();
        this.magChanged = true;
    }

    public Vector<T> add(Vector<T> input) {
        Vector<T> output = new Vector<T>(this.data);
        UBA<T> input_data = super.getData();
        UBA<T> output_data = super.getData();
        int i = 0;
        for (Number val : input_data) {
            output_data.set(i, ((Number)output_data.get(i)).add(val));
            ++i;
        }
        this.magChanged = true;
        return output;
    }

    public Vector<T> sub(Vector<T> input) {
        Vector<T> output = new Vector<T>(this.data);
        UBA<T> input_data = super.getData();
        UBA<T> output_data = super.getData();
        int i = 0;
        for (Number val : input_data) {
            output_data.set(i, ((Number)output_data.get(i)).sub(val));
            ++i;
        }
        this.magChanged = true;
        return output;
    }

    public T dot(Vector<T> input) {
        Number output = (Number)((Number)input.get(0)).zero();
        int i = 0;
        for (Number j : super.getData()) {
            output = output.add(((Number)this.data.get(i)).mult(j));
            ++i;
        }
        return (T)output;
    }

    public Vector<T> mult(T input) {
        Vector<T> output = new Vector<T>(this.data);
        UBA<T> output_data = super.getData();
        int i = 0;
        while (i < this.length) {
            output_data.set(i, (Number)((Number)output_data.get(i)).mult(input));
            ++i;
        }
        output.magnitude = (Number)((Number)this.mag()).mult(input);
        output.magChanged = false;
        return output;
    }

    public Vector<T> mult(int input) {
        Vector<T> output = new Vector<T>(this.data);
        UBA<T> output_data = super.getData();
        int i = 0;
        while (i < this.length) {
            output_data.set(i, (Number)((Number)output_data.get(i)).mult(input));
            ++i;
        }
        output.magnitude = (Number)((Number)this.mag()).mult(input);
        output.magChanged = false;
        return output;
    }

    public Vector<T> div(T input) {
        Vector<T> output = new Vector<T>(this.data);
        UBA<T> output_data = super.getData();
        int i = 0;
        while (i < this.length) {
            output_data.set(i, (Number)((Number)output_data.get(i)).div(input));
            ++i;
        }
        output.magnitude = (Number)((Number)this.mag()).div(input);
        output.magChanged = false;
        return output;
    }

    public Vector<T> cross(Vector<T> o) {
        if (this.length != 3) {
            throw new Error("Vector: Cross Product requires vectors of length 3!");
        }
        Number[] output_data = (Number[])new Object[3];
        output_data[0] = ((Number)this.data.get(1)).mult((Number)o.data.get(2)).sub(((Number)this.data.get(2)).mult((Number)o.data.get(1)));
        output_data[1] = ((Number)this.data.get(2)).mult((Number)o.data.get(0)).sub(((Number)this.data.get(0)).mult((Number)o.data.get(2)));
        output_data[2] = ((Number)this.data.get(0)).mult((Number)o.data.get(1)).sub(((Number)this.data.get(1)).mult((Number)o.data.get(0)));
        return new Vector<T>(this.data);
    }

    private UBA<T> getData() {
        return this.data;
    }

    public T[] toArray() {
        return (Number[])this.data.toArray();
    }

    public T get(int i) {
        return (T)((Number)this.data.get(i));
    }

    public T mag() {
        if (this.magChanged) {
            try {
                this.magnitude = (Number)((Number)this.dot(this)).sqrt();
            }
            catch (Error e) {
                this.magnitude = (Number)((Number)this.get(0)).one();
            }
            this.magChanged = false;
        }
        return this.magnitude;
    }

    public T sqr_mag() {
        if (this.magChanged) {
            return this.dot(this);
        }
        return (T)((Number)((Number)this.magnitude).mult(this.magnitude));
    }

    public Vector<T> norm() {
        if (!this.magChanged && ((Number)this.magnitude).eq(1)) {
            return this;
        }
        Vector<T> out = this.div(this.mag());
        out.magnitude = (Number)((Number)out.get(0)).one();
        return out;
    }

    public Vector<T> reflection(Vector<T> normal) {
        return this.sub(normal.mult(2)).mult(this.dot(normal));
    }

    public void setMagnitude(T m) {
        this.magChanged = false;
        this.magnitude = m;
    }

    public Vector<T> proj(Vector<T> b) {
        return b.mult((Number)((Number)this.dot(b)).div(b.mag()));
    }

    public boolean equals(Vector<T> input) {
        UBA<T> input_data = super.getData();
        return input_data.equals(this.data);
    }

    public boolean equals(Object o) {
        return this.ge_T.xequal(this, o);
    }

    public String toString() {
        String output = "(";
        output = String.valueOf(output) + this.data.get(0);
        int i = 1;
        while (i < this.length) {
            output = String.valueOf(output) + ", " + this.data.get(i);
            ++i;
        }
        output = String.valueOf(output) + ")";
        return output;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }
}

