/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.functions;

import BryceMath.DoubleMath.Vector;
import util.interfaces.Function;

public class CubicSpline
implements Function<Double, Vector> {
    Vector A;
    Vector B;
    Vector C;
    Vector D;

    public CubicSpline(Vector p1, Vector t1, Vector p2, Vector t2) {
        this.A = p1.mult(2.0).sub(p2.mult(2.0)).add(t1).add(t2);
        this.B = p1.mult(-3.0).add(p2.mult(3.0)).sub(t1).sub(t2.mult(2.0));
        this.C = t2;
        this.D = p1;
    }

    @Override
    public Vector eval(Double input) {
        if (input < 0.0 || input > 1.0) {
            throw new Error("Error: Input not in function domain!");
        }
        double x_1 = input;
        double x_2 = x_1 * input;
        double x_3 = x_2 * input;
        return this.A.mult(x_3).add(this.B.mult(x_2)).add(this.C.mult(x_1)).add(this.D);
    }
}

