/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.functions;

import BryceMath.Numbers.Rational;
import BryceMath.Structures.Polynomial;
import util.interfaces.Function;

public class Interpolator
implements Function<Double, Double> {
    public static final int POLY = 0;
    public static final int TRIG = 1;
    private int myMode;
    static Polynomial f1 = new Polynomial(-2, 3, 0, 0);

    public Interpolator(int mode) {
        switch (mode) {
            case 0: {
                this.myMode = 0;
                break;
            }
            case 1: {
                this.myMode = 1;
                break;
            }
            default: {
                throw new Error("Interpolation mode not supported.");
            }
        }
    }

    @Override
    public Rational eval(Rational x) {
        if (x.part_int().toInt() != 0) {
            throw new Error("Intepolator out of bounds.");
        }
        switch (this.myMode) {
            case 0: {
                return f1.eval(x);
            }
            case 1: {
                return new Rational(1L, 2L).sub(new Rational(0.5 * Math.cos(Math.PI * x.toDouble())));
            }
        }
        throw new Error("Interpolation mode not supported.");
    }

    @Override
    public Double eval(Double x) {
        if (x < 0.0 || x > 1.0) {
            throw new Error("Intepolator out of bounds : val = " + x);
        }
        switch (this.myMode) {
            case 0: {
                return f1.eval(new Rational(x)).toDouble();
            }
            case 1: {
                return 0.5 - 0.5 * Math.cos(Math.PI * x);
            }
        }
        throw new Error("Interpolation mode not supported.");
    }
}

