/*
 * Decompiled with CFR 0.152.
 */
package BryceSound;

import Data_Structures.Structures.UBA;

public abstract class soundCalculator {
    protected double volume = 327.0;
    protected int sample_number = -1;
    protected int SAMPLING_RATE = 44100;
    protected int sample = -1;
    protected double frequency = 440.0;
    protected double x = -1.0;
    public static UBA<Double> notes = new UBA();

    public soundCalculator() {
        this.fillNotes();
    }

    public synchronized void fillNotes() {
        if (!notes.isEmpty()) {
            return;
        }
        notes.append((Double[])new Double[]{16.35, 17.32, 18.35, 19.45, 20.6, 21.83, 23.12, 24.5, 25.96, 27.5, 29.14, 30.87});
        int i = 12;
        while (i < 96) {
            notes.add(notes.get(i - 12) * 2.0);
            ++i;
        }
        i = 0;
        while (i < 24) {
            notes.pop_front();
            ++i;
        }
    }

    public short getWaveVal() {
        ++this.sample_number;
        this.sample_number %= this.SAMPLING_RATE;
        if (this.sample_number % this.SAMPLING_RATE == 0) {
            ++this.sample;
        }
        this.x += 1.0;
        this.x %= (double)this.SAMPLING_RATE;
        return this.getVal();
    }

    protected abstract short getVal();

    public void setSampleRate(int rate) {
        this.SAMPLING_RATE = rate;
    }

    public double sin(double frequency, double x, double volume) {
        this.changeFrequency(frequency);
        return volume * Math.sin(x * Math.PI * 2.0 * frequency / (double)this.SAMPLING_RATE);
    }

    public double square(double frequency, double x, double volume) {
        double periodic_size = (double)this.SAMPLING_RATE / frequency;
        double xx = x % periodic_size;
        return xx < periodic_size / 2.0 ? volume : -volume;
    }

    public double sawtooth(double frequency, double x, double volume) {
        double periodic_size = (double)this.SAMPLING_RATE / frequency;
        double xx = x % periodic_size;
        return -volume + 2.0 * volume * xx / periodic_size;
    }

    public double pulse(double frequency, double x, double volume) {
        double periodic_size = (double)this.SAMPLING_RATE / frequency;
        return this.sawtooth(frequency, x, volume) - this.sawtooth(frequency, x + periodic_size / 2.0, volume);
    }

    protected void changeFrequency(double new_f) {
        this.x = this.x * this.frequency / new_f;
        this.frequency = new_f;
    }
}

