/*
 * Decompiled with CFR 0.152.
 */
package BryceSound;

import BryceSound.soundCalculator;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class synthesizer
implements Runnable {
    soundCalculator sc;
    final int SAMPLING_RATE = 44100;
    final int SAMPLE_SIZE = 2;

    public synthesizer(soundCalculator sc) {
        this.sc = sc;
        sc.setSampleRate(44100);
        Thread T = new Thread(this);
        T.start();
    }

    @Override
    public synchronized void run() {
        SourceDataLine line = null;
        double fFreq = 440.0;
        double fCyclePosition = 0.0;
        AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println("Line matching " + info + " is not supported.");
        }
        try {
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            line.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        ByteBuffer cBuf = ByteBuffer.allocate(line.getBufferSize());
        int ctSamplesTotal = 220500;
        int sample_number = 0;
        block4: while (true) {
            double fCycleInc = fFreq / 44100.0;
            cBuf.clear();
            int ctSamplesThisPass = line.available() / 2;
            int i = 0;
            while (i < ctSamplesThisPass) {
                cBuf.putShort(this.sc.getWaveVal());
                fCyclePosition += fCycleInc;
                if (fCyclePosition > 1.0) {
                    fCyclePosition -= 1.0;
                }
                ++sample_number;
                ++i;
            }
            line.write(cBuf.array(), 0, cBuf.position());
            ctSamplesTotal -= ctSamplesThisPass;
            while (true) {
                if (line.getBufferSize() / 2 >= line.available()) continue block4;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            break;
        }
    }
}

