/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.ADTs;

import Data_Structures.ADTs.Sets.SimpleSet;
import Data_Structures.ADTs.Stack;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.SingleLinkedList;
import java.util.Iterator;

public abstract class BST<E extends Comparable<E>, T extends BST<E, T>>
extends Data_Structure<E>
implements SimpleSet<E> {
    protected int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public abstract void add(E var1);

    public abstract BST<E, T> add_static(E var1);

    @Override
    public abstract boolean remove(E var1);

    public abstract BST<E, T> remove_static(E var1);

    public abstract boolean isLeaf();

    public abstract E getRoot();

    @Override
    public abstract boolean contains(E var1);

    protected abstract boolean hasLeftChild();

    protected abstract boolean hasRightChild();

    protected abstract BST<E, T> getLeftChild();

    protected abstract BST<E, T> getRightChild();

    @Override
    public String toString() {
        String sl = this.hasLeftChild() ? this.getLeftChild().toString() : "null";
        String sr = this.hasRightChild() ? this.getRightChild().toString() : "null";
        String sdata = this.getRoot().toString();
        return "N(" + sl + ", " + sdata + ", " + sr + ")";
    }

    @Override
    public abstract Data_Structure<E> clone();

    @Override
    public Iterator<E> iterator() {
        return new Iter(this);
    }

    private class Iter
    implements Iterator<E> {
        Stack<BST<E, T>> Unexplored = new SingleLinkedList();
        Stack<BST<E, T>> parents;

        private Iter(BST<E, T> start) {
            this.Unexplored.push(start);
            this.parents = new SingleLinkedList();
        }

        @Override
        public boolean hasNext() {
            return !this.Unexplored.isEmpty() || !this.parents.isEmpty();
        }

        @Override
        public E next() {
            if (!this.Unexplored.isEmpty()) {
                BST current = this.Unexplored.pop();
                current = this.bottom_left(current);
                this.tagRightChild(current);
                return current.getRoot();
            }
            BST current = this.parents.pop();
            this.tagRightChild(current);
            return current.getRoot();
        }

        private void tagRightChild(BST<E, T> current) {
            if (current.hasRightChild()) {
                this.Unexplored.push(current.getRightChild());
            }
        }

        public BST<E, T> bottom_left(BST<E, T> current) {
            while (current.hasLeftChild()) {
                this.parents.push(current);
                current = current.getLeftChild();
            }
            return current;
        }

        @Override
        public void remove() {
            throw new Error("Not Implemented");
        }
    }
}

