/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.Fast;

import Data_Structures.ADTs.Stack;
import Data_Structures.Structures.Fast.FastNode;
import Data_Structures.Structures.Fast.FastStructure;
import Data_Structures.Structures.Pair;
import java.util.Iterator;

public class FastStack<E>
extends FastStructure
implements Stack<E>,
Iterable<E> {
    private FastNode head = null;

    @Override
    public E pop() {
        if (this.isEmpty()) {
            throw new Error("Cannot Pop from empty stack!");
        }
        Object output = this.head.data;
        FastNode old_head = this.head;
        this.head = this.head.link;
        FastStack.yard_push(old_head);
        return (E)output;
    }

    @Override
    public E top() {
        if (this.isEmpty()) {
            throw new Error("Cannot Peep at the head of an empty stack.");
        }
        return (E)this.head.data;
    }

    @Override
    public void push(E elem) {
        FastNode new_head = FastStack.newNode();
        new_head.data = elem;
        new_head.link = this.head;
        this.head = new_head;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public Stack<E> push_static(E elem) {
        FastStack<E> output = this.shallow_clone();
        output.push(elem);
        return output;
    }

    @Override
    public Pair<E, Stack<E>> pop_static() {
        FastStack<E> output = this.shallow_clone();
        E elem = output.top();
        output.head = output.head.link;
        return new Pair<E, FastStack<E>>(elem, output);
    }

    private FastStack<E> shallow_clone() {
        FastStack<E> output = new FastStack<E>();
        output.head = this.head;
        return output;
    }

    @Override
    public Iterator<E> iterator() {
        return new iter();
    }

    private class iter
    implements Iterator<E> {
        FastNode current;

        private iter() {
            this.current = FastStack.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.link != null;
        }

        @Override
        public E next() {
            this.current = this.current.link;
            return this.current.data;
        }

        @Override
        public void remove() {
            throw new Error("Not Yet Implemented");
        }
    }
}

