/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.Fast;

import Data_Structures.Structures.Fast.FastNode;

public abstract class FastStructure {
    private static FastNode yard_head = null;
    private static int yard_size = 0;
    private static int max_yard_size = 0;

    public abstract boolean isEmpty();

    protected static FastNode newNode() {
        if (yard_head == null) {
            return new FastNode();
        }
        return FastStructure.yard_pop();
    }

    protected static FastNode yard_pop() {
        if (yard_head == null) {
            throw new Error("Cannot Pop from empty yard!");
        }
        FastNode output = yard_head;
        yard_head = FastStructure.yard_head.link;
        --yard_size;
        return output;
    }

    protected static void yard_push(FastNode node) {
        node.data = null;
        if (yard_size == max_yard_size) {
            node.link = null;
            return;
        }
        node.link = yard_head;
        yard_head = node;
        ++yard_size;
    }

    public static void setYardSize(int size) {
        max_yard_size = size;
    }

    public static void fillYard(int size) {
        if (size >= 0) {
            int i = 0;
            while (i < size && i < max_yard_size) {
                FastStructure.yard_push(new FastNode());
                ++i;
            }
            return;
        }
        if (max_yard_size < 0) {
            throw new Error("Cannot add an infinite number of nodes to the yard!");
        }
        FastStructure.forceYardToGivenSize(max_yard_size);
    }

    public static void forceYardToGivenSize(int size) {
        if (size > max_yard_size) {
            max_yard_size = size;
        }
        while (yard_size < size) {
            FastStructure.yard_push(new FastNode());
        }
        while (yard_size > size) {
            FastStructure.yard_pop();
        }
    }

    public static void emptyYard() {
        yard_head = null;
    }

    public static boolean isYardFull() {
        return yard_size == max_yard_size;
    }

    public static boolean isYardEmpty() {
        return yard_size == 0;
    }
}

