/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures;

import BryceMath.Calculations.MathB;
import Data_Structures.ADTs.Sets.SimpleSet;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.List;
import java.util.Iterator;
import util.Genarics;

public class HashTable<E>
extends Data_Structure<E>
implements SimpleSet<E> {
    public static final int MAX_LOAD_PERCENTAGE = 75;
    protected List<E>[] table;
    private int load = 0;
    Genarics<List<E>> ge_chain = new Genarics();

    public HashTable() {
        this.iTable(1);
    }

    public HashTable(int starting_size) {
        this.iTable(starting_size);
    }

    private void iTable(int starting_size) {
        if (starting_size < 1) {
            throw new Error("Error : Hash Table starting size is too small!");
        }
        List bogus = new List();
        this.table = this.ge_chain.Array(starting_size, bogus);
        int i = 0;
        while (i < starting_size) {
            this.table[i] = new List();
            ++i;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.load == 0;
    }

    @Override
    public int size() {
        return this.load;
    }

    public int getTableSize() {
        return this.table.length;
    }

    public void insert(E input) {
        int val = this.hash(input);
        List<E> chain = this.table[val];
        if (chain.contains(input)) {
            return;
        }
        chain.add(input);
        this.proccessInsertion();
    }

    @Override
    public boolean contains(E input) {
        return this.query_and_remove(input, false);
    }

    @Override
    public boolean remove(E input) {
        return this.query_and_remove(input, true);
    }

    private boolean query_and_remove(E input, boolean should_remove) {
        int index = this.hash(input);
        List<E> chain = this.table[index];
        if (!should_remove) {
            return chain.contains(input);
        }
        Iterator<E> iter_chain = chain.iterator();
        while (iter_chain.hasNext()) {
            E elem = iter_chain.next();
            if (!this.equal(input, elem)) continue;
            iter_chain.remove();
            this.proccessRemoval();
            return true;
        }
        return false;
    }

    protected void proccessRemoval() {
        --this.load;
        if (this.under_capacity()) {
            this.resize(this.table.length / 2);
        }
    }

    protected void proccessInsertion() {
        ++this.load;
        if (this.at_capacity()) {
            this.resize(this.table.length * 2);
        }
    }

    protected int hash(E input) {
        if (input == null) {
            return 0;
        }
        return MathB.abs(input.hashCode()) % this.table.length;
    }

    private boolean at_capacity() {
        return this.table.length * 75 / 100 <= this.load - 1;
    }

    private boolean under_capacity() {
        return this.table.length * 25 / 100 > this.load;
    }

    private void resize(int size_new) {
        if (size_new < 1) {
            throw new Error("Error: Data Table must be of a positive size.");
        }
        E[] temp = this.toArray();
        this.table = this.ge_chain.Array(size_new, this.table[0]);
        int i = 0;
        while (i < this.table.length) {
            this.table[i] = new List();
            ++i;
        }
        if (temp == null) {
            return;
        }
        this.load = 0;
        E[] EArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = EArray[n2];
            this.insert(elem);
            ++n2;
        }
    }

    private boolean equal(E elem1, E elem2) {
        return this.ge_e.xequal(elem1, elem2);
    }

    @Override
    public Iterator<E> iterator() {
        return new iter();
    }

    @Override
    public String toString() {
        String output = "\n[HashTable, Size = " + this.size() + "]\n";
        for (E elem : this) {
            output = String.valueOf(output) + elem.toString() + "\n";
        }
        return String.valueOf(output) + "[End of Hash Table]\n";
    }

    @Override
    public HashTable<E> clone() {
        HashTable<E> output = new HashTable<E>(this.table.length);
        for (E elem : this) {
            output.insert(elem);
        }
        return output;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        HashTable input = (HashTable)o;
        int s1 = this.size();
        int s2 = input.size();
        if (s1 == 0 && s2 == 0) {
            return true;
        }
        if (s1 != s2) {
            return false;
        }
        Object example = this.getFirst();
        for (E elem : input) {
            if (elem.getClass() != example.getClass()) {
                return false;
            }
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(E elem) {
        this.insert(elem);
    }

    public void clear() {
        List<E>[] listArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            List<E> L = listArray[n2];
            L.clear();
            ++n2;
        }
        this.load = 0;
    }

    private class iter
    implements Iterator<E> {
        private int elements_seen = 0;
        private int index = 0;
        private Iterator<E> iter_chain = this.getSubIterator(0);

        private Iterator<E> getSubIterator(int index) {
            List chain = HashTable.this.table[index];
            return chain.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.elements_seen < HashTable.this.load;
        }

        @Override
        public E next() {
            while (!this.iter_chain.hasNext()) {
                ++this.index;
                this.iter_chain = this.getSubIterator(this.index);
            }
            ++this.elements_seen;
            return this.iter_chain.next();
        }

        @Override
        public void remove() {
            this.iter_chain.remove();
            HashTable.this.proccessRemoval();
        }
    }
}

