/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.HashingClasses;

import Data_Structures.ADTs.Bunch2;
import Data_Structures.Structures.HashTable;
import Data_Structures.Structures.HashingClasses.Pair;
import Data_Structures.Structures.List;
import java.util.Iterator;
import util.Genarics;

public class AArray<Key, Value>
extends HashTable<Pair<Key, Value>> {
    Genarics<Key> ge_Key = new Genarics();

    public AArray() {
    }

    public AArray(int starting_size) {
        super(starting_size);
    }

    public void update(Key key, Value val) {
        this.insert(key, val);
    }

    public boolean remove_key(Key key) {
        List<Pair<Key, Value>> chain = this.findChain(key);
        Pair<Key, Value> p = this.find(chain, key);
        if (p == null) {
            return false;
        }
        this.remove(chain, key);
        this.proccessRemoval();
        return true;
    }

    public boolean insert(Key key, Value val) {
        List<Pair<Key, Value>> chain = this.findChain(key);
        Pair<Key, Value> p = this.find(chain, key);
        if (p != null) {
            p.updateVal(val);
            return true;
        }
        Pair<Key, Value> input = new Pair<Key, Value>(key, val);
        chain.add(input);
        this.proccessInsertion();
        return true;
    }

    public boolean contains_key(Key key) {
        return this.find(key) != null;
    }

    public Value lookup(Key key) {
        Pair<Key, Value> p = this.find(key);
        if (p != null) {
            return p.getVal();
        }
        return null;
    }

    public List<Key> getKeys() {
        List output = new List();
        for (Pair p : this) {
            if (p == null) {
                output.add(null);
                continue;
            }
            output.add(p.getKey());
        }
        return output;
    }

    public List<Value> getValues() {
        List output = new List();
        for (Pair p : this) {
            if (p == null) {
                output.add(null);
                continue;
            }
            output.add(p.getVal());
        }
        return output;
    }

    private List<Pair<Key, Value>> findChain(Key key) {
        int index = this.hash_key(key);
        return this.table[index];
    }

    private Pair<Key, Value> find(Key key) {
        List<Pair<Key, Value>> chain = this.findChain(key);
        return this.find(chain, key);
    }

    private Pair<Key, Value> find(List<Pair<Key, Value>> chain, Key key) {
        for (Pair<Key, Value> p : chain) {
            if (!this.keys_equal(p.getKey(), key)) continue;
            return p;
        }
        return null;
    }

    private void remove(List<Pair<Key, Value>> chain, Key key) {
        Iterator<Pair<Key, Value>> iter2 = chain.iterator();
        while (iter2.hasNext()) {
            Pair<Key, Value> p = iter2.next();
            if (!p.getKey().equals(key)) continue;
            iter2.remove();
            return;
        }
        throw new Error("Removal should not be called in vain.");
    }

    private int hash_key(Key key) {
        Pair<Key, Object> bogus = new Pair<Key, Object>(key, null);
        return super.hash(bogus);
    }

    private boolean keys_equal(Key elem1, Key elem2) {
        return this.ge_Key.xequal(elem1, elem2);
    }

    @Override
    public AArray<Key, Value> clone() {
        AArray<Key, Value> output = new AArray<Key, Value>(this.table.length);
        for (Pair elem : this) {
            output.insert(elem.clone());
        }
        return output;
    }

    public List<Bunch2<Key, Value>> getPairs() {
        List<Bunch2<Key, Value>> output = new List<Bunch2<Key, Value>>();
        for (Pair p : this) {
            output.add(new Bunch2(p.getKey(), p.getVal()));
        }
        return output;
    }
}

