/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.InDevelopment.Heaps;

import Data_Structures.ADTs.Heap;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.UBA;
import java.util.Iterator;

public class ArrayHeap<E extends Comparable<E>>
extends Data_Structure<E>
implements Heap<E> {
    UBA<E> data;
    static final int D = 3;

    public ArrayHeap() {
        this.data = new UBA();
    }

    public ArrayHeap(int initial_size) {
        this.data = new UBA(initial_size);
    }

    public ArrayHeap(UBA<E> data_in) {
        this.data = data_in.clone();
        this.heapify();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void add(E elem) {
        int len = this.data.size();
        this.data.add(elem);
        this.sift_up(len);
    }

    public E peek_dominating() {
        return (E)((Comparable)this.data.get(0));
    }

    public E extract_dominating() {
        if (this.data.size() == 1) {
            return (E)((Comparable)this.data.rem());
        }
        Comparable output = (Comparable)this.data.get(0);
        Comparable last = (Comparable)this.data.rem();
        this.data.set(0, last);
        this.sift_down(0);
        return (E)output;
    }

    @Override
    public UBA<E> toUBA() {
        return this.data.clone();
    }

    private void heapify() {
        int i = this.data.size() - 1;
        while (i >= 0) {
            this.sift_down(i);
            --i;
        }
    }

    private void sift_down(int index) {
        int size = this.data.size();
        int child_index = this.index_child(index, 1);
        Comparable elem = (Comparable)this.data.get(index);
        while (child_index < size) {
            int min_elem_index = -1;
            Comparable min_elem = elem;
            int i = child_index;
            while (i < child_index + 3 && i < size) {
                Comparable child = (Comparable)this.data.get(i);
                if (child.compareTo(min_elem) < 0) {
                    min_elem = child;
                    min_elem_index = i;
                }
                ++i;
            }
            if (min_elem == elem) {
                return;
            }
            this.min_first(index, min_elem_index);
            index = min_elem_index;
            child_index = this.index_child(index, 1);
        }
    }

    private void sift_up(int index) {
        int parent_index = this.index_parent(index);
        while (index > 0 && this.min_first(parent_index, index)) {
            index = parent_index;
            parent_index = this.index_parent(index);
        }
    }

    private int index_parent(int index) {
        return (index - 1) / 3;
    }

    private int index_child(int index, int child_index) {
        return 3 * index + child_index;
    }

    private boolean min_first(int index1, int index2) {
        Comparable elem2;
        Comparable elem1 = (Comparable)this.data.get(index1);
        if (elem1.compareTo(elem2 = (Comparable)this.data.get(index2)) > 0) {
            this.data.swap(index1, index2);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("\nMinHeap[");
        for (Comparable elem : this) {
            output.append(elem);
            output.append(",\n");
        }
        output.append("]");
        return output.toString();
    }

    @Override
    public ArrayHeap<E> clone() {
        return new ArrayHeap<E>(this.data);
    }

    public UBA<E> toSortedUBA() {
        int len = this.data.size();
        UBA<E> output = new UBA<E>(len);
        Data_Structure heap = this.clone();
        int i = 0;
        while (i < len) {
            output.set(i, ((ArrayHeap)heap).extract_dominating());
            ++i;
        }
        return output;
    }
}

