/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.InDevelopment.Heaps;

import Data_Structures.ADTs.MeldableHeap;
import Data_Structures.Structures.Box;
import Data_Structures.Structures.List;
import Data_Structures.Structures.SingleLinkedList;

public class LeftistHeap<E extends Comparable<E>>
implements MeldableHeap<E, LeftistHeap<E>> {
    final int rank;
    final E data;
    final LeftistHeap<E> left;
    final LeftistHeap<E> right;

    public LeftistHeap(E elem) {
        this.rank = 1;
        this.data = elem;
        this.left = null;
        this.right = null;
    }

    private LeftistHeap(E elem, LeftistHeap<E> left, LeftistHeap<E> right) {
        this.rank = right.rank + 1;
        this.data = elem;
        this.left = left;
        this.right = right;
    }

    @SafeVarargs
    public static <E extends Comparable<E>> LeftistHeap<E> makeHeap(E ... elems) {
        SingleLinkedList<LeftistHeap<E>> Q = new SingleLinkedList<LeftistHeap<E>>();
        E[] EArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            E elem = EArray[n2];
            Q.enq(new LeftistHeap<E>(elem));
            ++n2;
        }
        while (Q.size() > 1) {
            Q.enq(LeftistHeap.meld((LeftistHeap)Q.deq(), (LeftistHeap)Q.deq()));
        }
        LeftistHeap output = (LeftistHeap)Q.deq();
        return output;
    }

    E findMin() {
        return this.data;
    }

    public LeftistHeap<E> meld(LeftistHeap<E> other) {
        return LeftistHeap.meld(this, other);
    }

    public static <E extends Comparable<E>> LeftistHeap<E> meld(LeftistHeap<E> h1, LeftistHeap<E> h2) {
        if (h2 == null) {
            return h1;
        }
        if (h1 == null) {
            return h2;
        }
        return LeftistHeap.mesh(h1, h2);
    }

    private static <E extends Comparable<E>> LeftistHeap<E> mesh(LeftistHeap<E> h1, LeftistHeap<E> h2) {
        LeftistHeap<E> left;
        LeftistHeap<E> right;
        if (h1.data.compareTo(h2.data) > 0) {
            LeftistHeap<E> temp = h1;
            h1 = h2;
            h2 = temp;
        }
        LeftistHeap<E> leftistHeap = right = h1.right == null ? h2 : LeftistHeap.mesh(h1.right, h2);
        if (h1.left.rank < right.rank) {
            left = right;
            right = h1.left;
        } else {
            left = h1.left;
        }
        return new LeftistHeap<E>(h1.data, left, right);
    }

    @Override
    public LeftistHeap<E> insert(E item) {
        LeftistHeap<E> node = new LeftistHeap<E>(item);
        return LeftistHeap.mesh(this, node);
    }

    @Override
    public LeftistHeap<E> deleteMin(Box<E> output) {
        output.val = this.data;
        return this.deleteMin();
    }

    @Override
    public LeftistHeap<E> deleteMin() {
        return LeftistHeap.meld(this.left, this.right);
    }

    @Override
    public E peekMin() {
        return this.data;
    }

    public List<E> listMin(E upper_bound) {
        List output = new List();
        LeftistHeap.listMin(this, upper_bound, output);
        return output;
    }

    private static <E extends Comparable<E>> void listMin(LeftistHeap<E> heap, E upper_bound, List<E> output) {
        if (heap == null || heap.data.compareTo(upper_bound) > 0) {
            return;
        }
        output.add(heap.data);
        LeftistHeap.listMin(heap.left, upper_bound, output);
        LeftistHeap.listMin(heap.right, upper_bound, output);
    }
}

