/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.InDevelopment.Trees;

import Data_Structures.ADTs.BST;

public class AVL<E extends Comparable<E>>
extends BST<E, AVL<E>> {
    private AVL<E> left;
    private E data;
    private AVL<E> right;
    private int height;

    public AVL() {
        this.size = 0;
        this.left = null;
        this.right = null;
        this.height = 0;
    }

    @Override
    public boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    @Override
    public E getRoot() {
        return this.data;
    }

    @Override
    protected boolean hasLeftChild() {
        return this.left != null;
    }

    @Override
    protected boolean hasRightChild() {
        return this.right != null;
    }

    protected AVL<E> getLeftChild() {
        return this.left;
    }

    protected AVL<E> getRightChild() {
        return this.right;
    }

    @Override
    public void add(E elem) {
        if (this.isEmpty()) {
            this.data = elem;
            ++this.size;
            this.height = 1;
            return;
        }
        this.add_helper(elem);
    }

    private void add_helper(E elem) {
        int compare = elem.compareTo(this.data);
        if (compare == 0) {
            return;
        }
        if (compare < 0) {
            if (this.left == null) {
                this.left = this.N(elem);
            } else {
                super.add_helper(elem);
            }
        } else if (this.right == null) {
            this.right = this.N(elem);
        } else {
            super.add_helper(elem);
        }
        ++this.size;
        int hl = this.left != null ? this.left.height : 0;
        int hr = this.right != null ? this.right.height : 0;
        this.height = 1 + Math.max(hl, hr);
        this.balance();
    }

    @Override
    public boolean contains(E elem) {
        if (this.isEmpty()) {
            return false;
        }
        return this.contains_helper(elem);
    }

    private boolean contains_helper(E elem) {
        AVL<E> child;
        if (this.data.equals(elem)) {
            return true;
        }
        AVL<E> aVL = child = elem.compareTo(this.data) < 0 ? this.left : this.right;
        if (child == null) {
            return false;
        }
        return super.contains_helper(elem);
    }

    @Override
    public boolean remove(E elem) {
        if (this.isEmpty()) {
            return false;
        }
        return this.remove_search(elem, null);
    }

    public boolean remove_search(E elem, AVL<E> parent) {
        AVL<E> child;
        if (this.data.equals(elem)) {
            this.remove_remove(parent);
            return true;
        }
        AVL<E> aVL = child = elem.compareTo(this.data) < 0 ? this.left : this.right;
        if (child == null) {
            return false;
        }
        return child.remove_search(elem, this);
    }

    private void remove_remove(AVL<E> parent) {
        if (this.left == null && this.right == null) {
            if (parent != null) {
                if (parent.left == this) {
                    parent.left = null;
                } else {
                    parent.right = null;
                }
            }
            this.data = null;
            this.size = 0;
            return;
        }
        if (this.right == null) {
            if (this.left == null) {
                throw new Error("This should be impossible");
            }
            this.copy_from(this.left);
            return;
        }
        if (this.left == null) {
            this.copy_from(this.right);
            return;
        }
        if (this.right.left == null) {
            AVL<E> l = this.left;
            this.copy_from(this.right);
            this.left = l;
            this.updateHeight();
            this.balance();
            return;
        }
        this.data = super.remove_leftmost(this.right);
        this.updateHeight();
        this.balance();
    }

    private E remove_leftmost(AVL<E> parent) {
        if (this.left == null) {
            parent.left = this.right;
            super.updateHeight();
            return this.data;
        }
        E output = super.remove_leftmost(this);
        --this.size;
        this.balance();
        return output;
    }

    private void copy_from(AVL<E> other) {
        this.data = other.data;
        this.size = other.size;
        this.right = other.right;
        this.left = other.left;
        this.height = other.height;
    }

    private void balance() {
        int balance = this.balanceFactor();
        if (Math.abs(balance) < 2) {
            return;
        }
        if (balance > 0) {
            int left_bal;
            int n = left_bal = this.left != null ? super.balanceFactor() : 0;
            if (left_bal < 0) {
                super.rotateLeft();
            }
            this.rotateRight();
        } else {
            int right_bal;
            int n = right_bal = this.right != null ? super.balanceFactor() : 0;
            if (right_bal > 0) {
                super.rotateRight();
            }
            this.rotateLeft();
        }
    }

    private int balanceFactor() {
        int hl = this.left != null ? this.left.height : 0;
        int hr = this.right != null ? this.right.height : 0;
        return hl - hr;
    }

    private void updateHeight() {
        int h1 = this.left != null ? this.left.height : 0;
        int h2 = this.right != null ? this.right.height : 0;
        this.height = 1 + Math.max(h1, h2);
    }

    private void updateSize() {
        int s1 = this.left != null ? this.left.size : 0;
        int s2 = this.right != null ? this.right.size : 0;
        int mysize = this.data != null ? 1 : 0;
        this.size = mysize + s1 + s2;
    }

    private AVL<E> N(E elem) {
        AVL<E> node = new AVL<E>();
        node.data = elem;
        node.size = 1;
        node.height = 1;
        return node;
    }

    private void rotateRight() {
        E s_left_elem;
        if (this.left == null) {
            throw new Error("Error : Cannot perform right rotations when no left subtree exists.");
        }
        AVL<E> s_left = this.left;
        AVL<E> s_right = this.right;
        boolean b = this.left == null;
        AVL<E> s_leftl = b ? null : s_left.left;
        AVL<E> s_leftr = b ? null : s_left.right;
        E s_elem = this.data;
        this.data = s_left_elem = this.left.data;
        this.left = s_leftl;
        this.right = s_left;
        s_left.data = s_elem;
        s_left.left = s_leftr;
        s_left.right = s_right;
        super.updateHeight();
        this.updateHeight();
        super.updateSize();
        this.updateSize();
    }

    private void rotateLeft() {
        E s_right_elem;
        if (this.right == null) {
            throw new Error("Error : Cannot perform left rotations when no left subtree exists.");
        }
        AVL<E> s_left = this.left;
        AVL<E> s_right = this.right;
        boolean b = this.right == null;
        AVL<E> s_rightl = b ? null : s_right.left;
        AVL<E> s_rightr = b ? null : s_right.right;
        E s_elem = this.data;
        this.data = s_right_elem = this.right.data;
        this.right = s_rightr;
        this.left = s_right;
        s_right.data = s_elem;
        s_right.right = s_rightl;
        s_right.left = s_left;
        super.updateHeight();
        this.updateHeight();
        super.updateSize();
        this.updateSize();
    }

    @Override
    public AVL<E> clone() {
        AVL<E> output = new AVL<E>();
        output.data = this.data;
        output.height = this.height;
        output.size = this.size;
        output.left = this.left != null ? this.left.clone() : null;
        output.right = this.right != null ? this.right.clone() : null;
        return output;
    }

    @Override
    public BST<E, AVL<E>> add_static(E elem) {
        throw new Error("Please use add(), because AVLs are mutable.");
    }

    @Override
    public BST<E, AVL<E>> remove_static(E elem) {
        throw new Error("Please use remove(), because AVLs are mutable.");
    }
}

