/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.InDevelopment;

import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.List;
import Data_Structures.Structures.SingleLinkedList;
import java.util.Iterator;

public class UnionFind<E>
extends Data_Structure<E> {
    AArray<E, Node> nodes = new AArray();

    public void makeset(E elem) {
        if (this.nodes.lookup(elem) == null) {
            Node n = new Node(elem);
            this.nodes.insert(elem, n);
        }
    }

    public void union(E e1, E e2) {
        this.link(this.findNode(e1), this.findNode(e2));
    }

    public E find(E elem) {
        Node output = this.findNode(elem);
        return (E)this.find(output).elem;
    }

    public boolean connected(E e1, E e2) {
        return this.find(e1) == this.find(e2);
    }

    private Node findNode(E elem) {
        Node n = this.nodes.lookup(elem);
        if (n == null) {
            throw new Error("Union Find find() The given input element: " + elem + " was not found.");
        }
        return this.find(n);
    }

    private Node find(Node n) {
        SingleLinkedList<Node> S = new SingleLinkedList<Node>();
        while (n.parent != null) {
            if (n == n.parent) {
                throw new Error("This is Bad");
            }
            S.push(n);
            n = n.parent;
        }
        Node root = n;
        while (!S.isEmpty()) {
            ((Node)S.pop()).parent = root;
        }
        return root;
    }

    private void link(Node n1, Node n2) {
        if (n1 == n2) {
            return;
        }
        if (n1.rank > n2.rank) {
            n2.parent = n1;
            return;
        }
        if (n2.rank > n1.rank) {
            n1.parent = n2;
            return;
        }
        n2.parent = n1;
        ++n1.rank;
    }

    @Override
    public Iterator<E> iterator() {
        return this.nodes.getKeys().iterator();
    }

    @Override
    public void add(E elem) {
        this.makeset(elem);
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        List<List<E>> sets = this.getSets().getValues().removeDuplicates();
        for (List<E> L : sets) {
            output.append("{");
            for (E elem : L) {
                output.append(elem + ", ");
            }
            output.replace(output.length() - 2, output.length(), "}");
        }
        return output.toString();
    }

    public AArray<E, List<E>> getSets() {
        AArray<Object, List<Object>> output = new AArray<Object, List<Object>>();
        List<Node> keys = this.nodes.getValues();
        for (Node n : keys) {
            Node representative = this.find(n);
            Object root_elem = representative.elem;
            List<Object> list = (List<Object>)output.lookup(root_elem);
            if (list == null) {
                list = new List<Object>();
                output.insert(root_elem, list);
            }
            list.add(n.elem);
            if (n == representative) continue;
            output.insert(n.elem, list);
        }
        return output;
    }

    @Override
    public Data_Structure<E> clone() {
        UnionFind<E> UF = new UnionFind<E>();
        List<E> keys = this.nodes.getKeys();
        for (E elem : keys) {
            Node n = this.nodes.lookup(elem);
            UF.nodes.insert(elem, n.clone());
        }
        return UF;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    private class Node {
        private E elem;
        Node parent = null;
        int rank = 0;

        Node(E elem) {
            this.elem = elem;
        }

        protected Node clone() {
            Node output = new Node(this.elem);
            output.rank = this.rank;
            output.parent = this.parent;
            return output;
        }
    }
}

