/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures;

import Data_Structures.ADTs.Queue;
import Data_Structures.ADTs.Stack;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.Pair;
import java.util.Iterator;

public class SingleLinkedList<E>
extends Data_Structure<E>
implements Stack<E>,
Queue<E> {
    Node head;
    Node tail;
    int size;

    public SingleLinkedList() {
        this.clear();
    }

    public void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public E getFirst() {
        return this.head.elem;
    }

    public E getLast() {
        return this.tail.elem;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(E elem) {
        this.push(elem);
    }

    @Override
    public void enq(E elem) {
        Node n = new Node(elem);
        ++this.size;
        if (this.head == null) {
            this.head = n;
            this.tail = n;
            return;
        }
        this.tail.next = n;
        this.tail = n;
    }

    @Override
    public E deq() {
        switch (this.size) {
            case 0: {
                throw new Error("ERROR : Cannot Deq from an Empty SL list!");
            }
            case 1: {
                Object output = this.head.elem;
                this.size = 0;
                this.head = null;
                this.tail = null;
                return output;
            }
        }
        Object output = this.head.elem;
        this.head = this.head.next;
        --this.size;
        return output;
    }

    @Override
    public void push(E elem) {
        Node n = new Node(elem);
        ++this.size;
        if (this.head == null) {
            this.head = n;
            this.tail = n;
            return;
        }
        n.next = this.head;
        this.head = n;
    }

    @Override
    public E pop() {
        return this.deq();
    }

    @Override
    public E top() {
        return this.head.elem;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("\nList [Size = " + this.size + "]\n");
        if (this.isEmpty()) {
            return output + "[Empty]";
        }
        Node n = this.head;
        while (n != null) {
            output.append(n.elem + " <-->\n");
            n = n.next;
        }
        output.append("[End of List]\n");
        return output.toString();
    }

    @Override
    public SingleLinkedList<E> clone() {
        SingleLinkedList<E> other = new SingleLinkedList<E>();
        for (E elem : this) {
            other.add(elem);
        }
        return other;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter();
    }

    @Override
    public Queue<E> enq_static(E elem) {
        throw new Error("Not Implemented");
    }

    @Override
    public Pair<E, Queue<E>> deq_static() {
        throw new Error("Not Implemented");
    }

    @Override
    public Stack<E> push_static(E elem) {
        SingleLinkedList<E> output = this.shallow_clone();
        output.push(elem);
        return output;
    }

    @Override
    public Pair<E, Stack<E>> pop_static() {
        SingleLinkedList<E> output = this.shallow_clone();
        Object elem = output.pop();
        return new Pair(elem, output);
    }

    private SingleLinkedList<E> shallow_clone() {
        SingleLinkedList<E> output = new SingleLinkedList<E>();
        output.head = this.head;
        output.tail = this.tail;
        output.size = this.size;
        return output;
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            throw new Error("Empty list has not element to peek at.");
        }
        return this.head.elem;
    }

    private class Iter
    implements Iterator<E> {
        Node prev;
        Node current;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return SingleLinkedList.this.size != 0 && (this.current == null || this.current.next != null);
        }

        @Override
        public E next() {
            this.prev = this.current;
            this.current = this.current == null ? SingleLinkedList.this.head : this.current.next;
            return this.current.elem;
        }

        @Override
        public void remove() {
            if (SingleLinkedList.this.head == this.current) {
                SingleLinkedList.this.head = SingleLinkedList.this.head.next;
            }
            if (SingleLinkedList.this.tail == this.current) {
                SingleLinkedList.this.tail = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.current.next;
            }
            --SingleLinkedList.this.size;
        }
    }

    private class Node {
        E elem;
        Node next;

        private Node(E data) {
            this.elem = data;
            this.next = null;
        }
    }
}

