/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures;

import Data_Structures.ADTs.Deque;
import Data_Structures.ADTs.Pairable;
import Data_Structures.ADTs.Queue;
import Data_Structures.ADTs.Stack;
import Data_Structures.Operations.Sort;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.Pair;
import java.util.Iterator;

public class UBA<E>
extends Data_Structure<E>
implements Pairable<E>,
Stack<E>,
Queue<E>,
Deque<E> {
    private E[] data;
    int start;
    int size;
    int limit;

    public UBA() {
        this.clear();
    }

    public UBA(int limit_start) {
        this.clear(limit_start);
    }

    private UBA(E[] input, int size_in) {
        this.size = size_in;
        this.start = 0;
        this.limit = input.length;
        this.data = input;
    }

    @Override
    public void add(E elem) {
        if (this.size == this.limit) {
            this.resize(this.limit * 2);
        }
        int index = this.size++;
        this.set(index, elem);
    }

    public void prepend(E elem) {
        if (this.size == this.limit) {
            this.resize(this.limit * 2);
        }
        int index = 0;
        ++this.size;
        this.start = (this.start + this.limit - 1) % this.limit;
        this.set(index, elem);
    }

    public E rem() {
        if (this.size == 0) {
            throw new Error("ERROR UBA: Cannot remove element from empty array.");
        }
        E elem = this.get(this.size - 1);
        this.set(this.size - 1, null);
        --this.size;
        if (this.size < this.limit / 4) {
            this.resize(this.limit / 2);
        }
        return elem;
    }

    @Override
    public void push(E elem) {
        this.add(elem);
    }

    @Override
    public E pop() {
        return this.rem();
    }

    @Override
    public void enq(E elem) {
        this.add(elem);
    }

    @Override
    public E deq() {
        if (this.size == 0) {
            throw new Error("ERROR UBA: Cannot remove element from empty array.");
        }
        E output = this.get(0);
        this.set(0, null);
        this.start = (this.start + 1) % this.limit;
        --this.size;
        if (this.size < this.limit / 4) {
            this.resize(this.limit / 2);
        }
        return output;
    }

    public void set(int index, E elem) {
        if (index >= 0 && index < this.size) {
            this.data[(this.start + index) % this.limit] = elem;
            return;
        }
        throw new Error(" ERROR: UBA: invalid index (" + index + ") for Set.");
    }

    public E get(int index) {
        if (index >= 0 && index < this.size) {
            return this.data[(this.start + index) % this.limit];
        }
        throw new Error("ERROR: UBA: invalid index for get : " + index);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public E getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.get(this.size - 1);
    }

    private E[] getData(int amount) {
        if (amount < this.size) {
            throw new Error("ERROR: Data Array lacks room for data.");
        }
        Object[] output = new Object[amount];
        int i = 0;
        while (i < this.size) {
            output[i] = this.get(i);
            ++i;
        }
        return output;
    }

    private void resize(int new_limit) {
        this.data = this.getData(new_limit);
        this.limit = new_limit;
        this.start = 0;
    }

    public UBA<E> copy() {
        return this.clone();
    }

    @Override
    public UBA<E> clone() {
        E[] temp = this.getData(this.limit);
        return new UBA<E>(temp, this.size);
    }

    public void swap(int i1, int i2) {
        E temp = this.get(i1);
        this.set(i1, this.get(i2));
        this.set(i2, temp);
    }

    public void isort() {
        this.sort(false);
    }

    public void sort() {
        this.sort(true);
    }

    private void sort(boolean msort) {
        Comparable[] temp = this.ge_e.Comparable_Array(this.size);
        int i = 0;
        while (i < this.size) {
            temp[i] = (Comparable)this.get(i);
            ++i;
        }
        if (msort) {
            Sort.msort(temp);
        } else {
            Sort.isort(temp);
        }
        this.start = 0;
        this.data = temp;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("\nUBA[Size = " + this.size + ", Limit = " + this.limit + "]\n\n");
        if (this.size == 0) {
            output.append("[Empty]\n");
        }
        int i = 0;
        while (i < this.size) {
            output.append(this.get(i) + "\n");
            ++i;
        }
        output.append("[UBA END]\n\n");
        return output.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return new iter();
    }

    public void clear() {
        this.limit = 1;
        this.data = new Object[this.limit];
        this.start = 0;
        this.size = 0;
    }

    public void clear(int limit_start) {
        if (limit_start <= 0) {
            throw new Error("The limit must be a positive integer.");
        }
        this.limit = limit_start;
        this.data = new Object[this.limit];
    }

    public E delete_and_shift(int index) {
        if (index == 0) {
            return this.deq();
        }
        if (index == this.size - 1) {
            return this.rem();
        }
        E output = this.get(index);
        int i = index;
        while (i < this.size - 1) {
            this.set(i, this.get(i + 1));
            ++i;
        }
        this.rem();
        return output;
    }

    @Override
    public E peep_back() {
        return this.getLast();
    }

    @Override
    public E peep_front() {
        return this.getFirst();
    }

    @Override
    public E pop_back() {
        return this.pop();
    }

    @Override
    public E pop_front() {
        return this.deq();
    }

    @Override
    public void push_back(E elem) {
        this.push(elem);
    }

    @Override
    public void push_front(E elem) {
        this.prepend(elem);
    }

    @Override
    public E top() {
        return this.getLast();
    }

    @Override
    public Queue<E> enq_static(E elem) {
        throw new Error("Not Implemented");
    }

    @Override
    public Pair<E, Queue<E>> deq_static() {
        throw new Error("Not Implemented");
    }

    @Override
    public Stack<E> push_static(E elem) {
        throw new Error("Not Implemented");
    }

    @Override
    public Pair<E, Stack<E>> pop_static() {
        throw new Error("Not Implemented");
    }

    @Override
    public E peek() {
        return this.getFirst();
    }

    public void frontToBack() {
        E elem = this.deq();
        this.enq(elem);
    }

    public void ensureCapacity(int number) {
        if (number > this.limit) {
            this.resize(2 * number);
            return;
        }
        this.size = number;
    }

    public void fillToIndex(int last_index) {
        this.fillToIndex(null, last_index);
    }

    public void fillToIndex(E elem, int last_index) {
        this.ensureCapacity(last_index + 1);
        while (this.size <= last_index) {
            this.add(elem);
        }
    }

    private class iter
    implements Iterator<E> {
        int index = -1;

        @Override
        public boolean hasNext() {
            return this.index + 1 < UBA.this.size;
        }

        @Override
        public E next() {
            ++this.index;
            Object output = UBA.this.get(this.index);
            return output;
        }

        @Override
        public void remove() {
            if (this.index == 0) {
                UBA.this.deq();
                --this.index;
                return;
            }
            if (this.index == UBA.this.size - 1) {
                UBA.this.rem();
                return;
            }
            throw new Error("Removal of sandwitched UBA elements is not yet supported.");
        }
    }
}

