/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.OBJ2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public abstract class ImageObj
extends OBJ2D {
    public static int NO_IMAGE = -1;
    private BufferedImage[] images;
    private int image_index = 0;
    Color color = null;
    int w = -1;
    int h = -1;
    int image_offset_x = 0;
    int image_offset_y = 0;

    public ImageObj(int x, int y, BufferedImage ... images) {
        super(x, y);
        this.images = images;
        if (images != null && images.length == 0) {
            throw new Error("You probably wanted to use the x, y, w, h constructor.");
        }
        this.image_index = images == null ? NO_IMAGE : 0;
    }

    public ImageObj(int x, int y, int w, int h) {
        super(x, y);
        this.images = null;
        this.w = w;
        this.h = h;
        this.image_index = NO_IMAGE;
    }

    @Override
    public void draw(Graphics g) {
        if (this.color != null) {
            g.setColor(this.color);
            g.fillRect(this.x, this.y, this.getW(), this.getH());
        }
        if (this.image_index != NO_IMAGE) {
            g.drawImage(this.images[this.image_index], this.x + this.image_offset_x, this.y + this.image_offset_y, null);
        }
    }

    @Override
    public abstract void update();

    public void setColor(Color color) {
        this.color = color;
    }

    public void setImage(int index) {
        this.image_index = index;
    }

    @Override
    public int getW() {
        if (this.w != -1) {
            return this.w;
        }
        if (this.image_index != NO_IMAGE) {
            return this.images[this.image_index].getWidth();
        }
        return -1;
    }

    @Override
    public int getH() {
        if (this.h != -1) {
            return this.h;
        }
        if (this.image_index != NO_IMAGE) {
            return this.images[this.image_index].getHeight();
        }
        return -1;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void setH(int h) {
        this.h = h;
    }

    public void setImageOffsetX(int x) {
        this.image_offset_x = x;
    }

    public void setImageOffsetY(int y) {
        this.image_offset_y = y;
    }
}

