/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import BryceMath.Calculations.Colors;
import BryceMath.Calculations.MathB;
import GUI.UI_Button;
import java.awt.Color;
import java.awt.Graphics;
import util.interfaces.Consumer1;

public class UI_Slider
extends UI_Button {
    int num_states = 1;
    int current_state = 0;
    int slider_w = 20;
    private Consumer1<Integer> action_stateChange = null;

    public UI_Slider(int x, int y, int w, int h, int num_states) {
        super(x, y, w, h, "");
        this.num_states = num_states;
        this.setDrawBorders(false);
    }

    public void setOnSlide(Consumer1<Integer> action) {
        this.action_stateChange = action;
    }

    public int getState() {
        return this.current_state;
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        int w = this.getW();
        int h = this.getH();
        int x_end = this.x + w - 1;
        int y_end = this.y + h - 1;
        int y_half = this.y + h / 2;
        g.setColor(Color.black);
        g.drawLine(this.x, this.y, this.x, y_end);
        g.drawLine(x_end, this.y, x_end, y_end);
        g.drawLine(this.x, y_half, x_end, y_half);
        int slider_x = (this.getW() - this.slider_w) * this.current_state / this.num_states;
        g.setColor(Colors.Color_hsv(0.0, 0.0, 20.0));
        g.fillOval(this.x + slider_x, this.y + this.getH() / 4, this.slider_w, this.getH() / 2 - 1);
    }

    @Override
    public void mouseD(int x, int y) {
        super.mouseD(x, y);
        this.current_state = (x - this.slider_w / 2 - this.x) * this.num_states / (this.getW() - this.slider_w);
        this.current_state = MathB.bound(this.current_state, 0, this.num_states);
        if (this.action_stateChange != null) {
            this.action_stateChange.eval(this.current_state);
        }
    }
}

