/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import BryceMath.Calculations.Colors;
import GUI.FontDrawing;
import GUI.ImageObj;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class UI_TextBox
extends ImageObj {
    private String str;
    private Color text_color = Color.BLACK;
    private Font text_font = new Font("TimesRoman", 1, 60);
    private Color border_color = Color.BLACK;
    private boolean draw_borders = true;
    private int text_offset_x = 0;
    private int text_offset_y = 0;

    public UI_TextBox(int x, int y, String str, BufferedImage ... images) {
        super(x, y, images);
        this.str = str;
        this.setColor(Colors.Color_hsv(0.0, 0.0, 80.0));
    }

    public UI_TextBox(int x, int y, int w, int h, String str) {
        super(x, y, w, h);
        this.str = str;
        this.setColor(Colors.Color_hsv(0.0, 0.0, 80.0));
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        if (this.draw_borders) {
            g.setColor(this.border_color);
            g.drawRect(this.x, this.y, this.getW() - 1, this.getH() - 1);
        }
        g.setColor(this.text_color);
        g.setFont(this.text_font);
        FontDrawing.drawText(g, this.str, this, this.text_offset_x, this.text_offset_y);
    }

    @Override
    public void update() {
    }

    public void setFont(Font f) {
        this.text_font = f;
    }

    public void setTextColor(Color c) {
        this.text_color = c;
    }

    public void setText(String message) {
        this.str = message;
    }

    public void setDrawBorders(boolean draw) {
        this.draw_borders = draw;
    }

    public void setTextOffset(int x, int y) {
        this.text_offset_x = x;
        this.text_offset_y = y;
    }
}

