/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs;

import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.HashingClasses.Set;
import Data_Structures.Structures.IterB;
import Data_Structures.Structures.List;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Obj_union;
import Game_Engine.Engine.Objs.View;
import Game_Engine.Engine.Objs.actionLogging.Command;
import Game_Engine.Engine.Objs.actionLogging.obj_cursor;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;

public abstract class Obj_Container
extends Obj
implements Iterable<Obj> {
    private List<Obj> Objs = new List();
    private Set<Obj> objs_hash = new Set(100);
    protected List<View> views;
    protected int viewX;
    protected int viewY;
    public obj_cursor proxy_cursor;
    public static obj_cursor global_proxy_cursor;
    protected boolean keyLog = false;
    public static boolean globalLog;
    private int super_mouse_x;
    private int super_mouse_y;
    int w;
    int h;

    static {
        globalLog = false;
    }

    public Obj_Container() {
    }

    public Obj_Container(double x, double y, int w, int h) {
        super(x, y);
        this.w = w;
        this.h = h;
        this.iVars();
    }

    public Obj_Container(Rectangle r) {
        super(r.getX(), r.getY());
        this.w = r.getW();
        this.h = r.getH();
        this.redraw();
        this.iVars();
    }

    public void iVars() {
        this.restartObjsList();
        this.iViews();
        this.iObjs();
    }

    public void restartObjsList() {
        this.objs_hash = new Set(this.Objs.size() + 1);
        this.Objs.clear();
    }

    public Set<Obj> getObjSet() {
        return this.objs_hash.clone();
    }

    public abstract void iObjs();

    protected abstract void iViews();

    @Override
    public void draw(ImageB i, AffineTransform AT, CountDownLatch calling_latch) {
        if (!this.isVisible()) {
            calling_latch.countDown();
            return;
        }
        drawThread t = new drawThread(i, AT, calling_latch);
        t.run();
    }

    @Override
    public void draw(ImageB i, AffineTransform AT) {
        throw new Error("Obj_Container: draw(image, AT) : please do not ever call this function!");
    }

    public Rectangle getBounds() {
        Rectangle output = this.views.getFirst().getBounds();
        for (View v : this.views) {
            output = output.union(v.getBounds());
        }
        return output;
    }

    @Override
    public void keyP(int key) {
        if (this.keyLog) {
            Command.logMove(this.super_mouse_x, this.super_mouse_y);
            Command.logKeyP(key);
        }
        IterB<Obj> I = this.Objs.getIter();
        while (I.hasNext()) {
            Obj o = (Obj)I.next();
            if (!o.isEnabled()) continue;
            if (o instanceof Obj_Container) {
                Obj_Container o_container = (Obj_Container)o;
                if (o_container.proxy_cursor != null) {
                    o_container.proxy_cursor.keyPSpecial(key);
                    continue;
                }
            }
            o.keyP(key);
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void keyR(int key) {
        if (this.keyLog) {
            Command.logMove(this.super_mouse_x, this.super_mouse_y);
            Command.logKeyR(key);
        }
        IterB<Obj> I = this.Objs.getIter();
        while (I.hasNext()) {
            Obj o = (Obj)I.next();
            if (!o.isEnabled()) continue;
            o.keyR(key);
            if (o.getCeaseIteration() || o.getCeaseIteration()) break;
        }
    }

    @Override
    public void mouseD(int mx, int my) {
        this.updateSuperMouseCoordinates(mx, my);
        mx -= (int)this.getX() - this.getView().getViewX();
        my -= (int)this.getY() - this.viewY;
        for (Obj o : this.Objs) {
            o.resetMouseFlags();
        }
        IterB<Obj> I = this.Objs.getTailIter();
        while (I.hasPrevious()) {
            Obj o = I.previous();
            if (!o.isCollidable() || o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            if (o.mouseCollision(mx, my)) {
                o.mouseD(mx, my);
                break;
            }
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void mouseM(int mx, int my) {
        this.updateSuperMouseCoordinates(mx, my);
        mx -= (int)this.getX() - this.viewX;
        my -= (int)this.getY() - this.viewY;
        for (Obj o : this.Objs) {
            o.resetMouseFlags();
        }
        IterB<Obj> I = this.Objs.getTailIter();
        while (I.hasPrevious()) {
            Obj o = I.previous();
            if (!o.isCollidable() || o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            if (o.mouseCollision(mx, my)) {
                o.mouseM(mx, my);
                break;
            }
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void mouseP(int mx, int my) {
        if (this.keyLog) {
            Command.logMove(mx, my);
            Command.logMouseP();
        }
        this.updateSuperMouseCoordinates(mx, my);
        mx -= (int)this.getX() - this.viewX;
        my -= (int)this.getY() - this.viewY;
        IterB<Obj> I = this.Objs.getTailIter();
        while (I.hasPrevious()) {
            Obj o = I.previous();
            if (!o.isCollidable() || o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            if (o.mouseCollision(mx, my)) {
                o.mouseP(mx, my);
                break;
            }
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void mouseR(int mx, int my) {
        if (this.keyLog) {
            Command.logMove(mx, my);
            Command.logMouseR();
        }
        this.updateSuperMouseCoordinates(mx, my);
        mx -= (int)this.getX() - this.viewX;
        my -= (int)this.getY() - this.viewY;
        IterB<Obj> I = this.Objs.getTailIter();
        while (I.hasPrevious()) {
            Obj o = I.previous();
            if (!o.isCollidable() || o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            if (o.mouseCollision(mx, my)) {
                o.mouseR(mx, my);
                break;
            }
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void global_mouseP() {
        for (Obj o : this.Objs) {
            if (o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            o.global_mouseP();
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void global_mouseR() {
        for (Obj o : this.Objs) {
            if (o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            o.global_mouseR();
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void global_mouseM(int mx, int my) {
        mx -= (int)this.getX() - this.viewX;
        my -= (int)this.getY() - this.viewY;
        for (Obj o : this.Objs) {
            if (o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            o.global_mouseM(mx, my);
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void global_mouseD(int mx, int my) {
        mx -= (int)this.getX() - this.viewX;
        my -= (int)this.getY() - this.viewY;
        for (Obj o : this.Objs) {
            if (o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            o.global_mouseD(mx, my);
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void global_mouseScroll(int amount) {
        for (Obj o : this.Objs) {
            if (o instanceof Obj_Container && ((Obj_Container)o).proxy_cursor != null) continue;
            o.global_mouseScroll(amount);
            if (o.getCeaseIteration()) break;
        }
    }

    @Override
    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        this.Objs.sort();
        IterB<Obj> I = this.Objs.getIter();
        while (I.hasNext()) {
            Obj o = (Obj)I.next();
            if (this.isEnabled()) {
                o.ensureUpdate();
            }
            if (o.dead(this)) {
                I.remove();
                this.objs_hash.rem(o);
            }
            if (o.getCeaseIteration()) break;
        }
        for (Obj o : this.Objs) {
            if (o.isEnabled() && o.isEnabled()) {
                o.endStep();
            }
            o.resetUpdateFlagForNextStep();
        }
        View v = this.views.getFirst();
        this.viewX = v.getViewX();
        this.viewY = v.getViewY();
    }

    @Override
    public void resetMouseFlags() {
        super.resetMouseFlags();
        for (Obj o : this.Objs) {
            o.resetMouseFlags();
        }
    }

    public List<Obj> getObjList() {
        return this.Objs;
    }

    public Obj obj_create(Obj ... objs) {
        Obj output = null;
        Obj[] objArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Obj o = objArray[n2];
            output = this.obj_create(o);
            ++n2;
        }
        return output;
    }

    public Obj obj_create(Obj o) {
        if (this.objs_hash.includes(o)) {
            return o;
        }
        this.objs_hash.set_add(o);
        this.Objs.add(o);
        o.setContainer(this);
        o.ressurect();
        if (!o.getInitialized()) {
            o.initialize();
            o.setInitialized(true);
        }
        if (o instanceof Obj_union) {
            for (Obj o2 : (Obj_union)o) {
                if (this.objs_hash.includes(o2)) continue;
                this.obj_create(o2);
            }
        }
        return o;
    }

    public void logKeys() {
        if (globalLog) {
            throw new Error("Do not log both global and local data in the same session!");
        }
        if (this.keyLog) {
            throw new Error("Only log one source at a time.");
        }
        this.keyLog = true;
        Command.openLogs();
    }

    public void globalLog() {
        if (this.keyLog) {
            throw new Error("Do not log both global and local data in the same session!");
        }
        if (globalLog) {
            throw new Error("You should have no reason to call this function more than once!");
        }
        globalLog = true;
        Command.openLogs();
    }

    protected void createProxyCursor(UBA<Command> program) {
        this.proxy_cursor = new obj_cursor(0.0, 0.0);
        this.proxy_cursor.program(program);
        this.obj_create((Obj)this.proxy_cursor);
    }

    public void killProxyCursor() {
        this.proxy_cursor.kill();
        this.proxy_cursor = null;
    }

    private void updateSuperMouseCoordinates(int mx, int my) {
        this.super_mouse_x = mx;
        this.super_mouse_y = my;
    }

    @Override
    public void setW(int w) {
        this.w = w;
    }

    @Override
    public void setH(int h) {
        this.h = h;
    }

    @Override
    public int getW() {
        return this.w;
    }

    @Override
    public int getH() {
        return this.h;
    }

    public View getView() {
        return this.views.getFirst();
    }

    @Override
    public void die() {
        super.die();
        for (Obj o : this.Objs) {
            o.kill();
        }
    }

    @Override
    public Iterator<Obj> iterator() {
        return this.Objs.iterator();
    }

    public void addH(int inc) {
        this.setH(this.getH() + inc);
    }

    public void addW(int inc) {
        this.setW(this.getW() + inc);
    }

    public void subH(int inc) {
        this.setH(this.getH() - inc);
    }

    public void subW(int inc) {
        this.setW(this.getW() - inc);
    }

    private class drawThread
    extends Thread {
        ImageB image;
        AffineTransform AT;
        CountDownLatch calling_latch;

        private drawThread(ImageB i_in, AffineTransform AT_in, CountDownLatch latch_in) {
            this.image = i_in;
            this.AT = AT_in;
            this.calling_latch = latch_in;
        }

        @Override
        public void run() {
            CountDownLatch latch = new CountDownLatch(Obj_Container.this.views.size());
            for (View v : Obj_Container.this.views) {
                v.draw(this.image, Obj_Container.this.Objs, latch, this.AT);
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.calling_latch.countDown();
        }
    }
}

