/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs;

import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Obj_Container;
import Game_Engine.Engine.Objs.View;
import Game_Engine.Engine.engine.Game_input;
import Game_Engine.Engine.engine.Game_looper;
import Game_Engine.Engine.engine.Game_output;

public abstract class Room
extends Obj_Container {
    private Game_looper looper;
    private Game_input input;
    private Game_output output;
    private boolean running = true;
    public static String room_directory;
    private boolean first_time = true;
    protected Animation_preference animation_preference = Animation_preference.NULL;

    public Room() {
    }

    public Room(Game_output out) {
        this.output = out;
        this.iVars();
    }

    @Override
    public abstract void iObjs();

    @Override
    public void iVars() {
        this.first_time = false;
        this.set_dimensions(this.output.getW(), this.output.getH());
        this.setContainer(this);
        super.iVars();
        this.looper = new Game_looper(this, 60, this.output);
        this.input = new Game_input(this, this.output);
        this.running = true;
    }

    @Override
    protected void iViews() {
        int density = this.getViewDensity();
        int half_w = this.getW() / density;
        int half_h = this.getH() / density;
        this.views = new List();
        int x = 0;
        while (x < density) {
            int y = 0;
            while (y < density) {
                Rectangle r1 = new Rectangle(half_w * x, half_h * y, half_w, half_h);
                this.views.add(new View(r1, r1, half_w, half_h));
                ++y;
            }
            ++x;
        }
    }

    protected int getViewDensity() {
        return 2;
    }

    public void restart() {
        this.stop();
        this.iVars();
    }

    public void start() {
        this.looper.start();
        this.input.start();
        this.running = true;
    }

    public void stop() {
        this.looper.stop();
        this.input.stop();
        this.running = false;
    }

    public void disableInput() {
        this.input.stop();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void set_dimensions(int w, int h) {
        this.setW(w);
        this.setH(h);
    }

    public void goto_room(String name) {
        try {
            this.stop();
            Room r = (Room)Class.forName(String.valueOf(room_directory) + "." + name).newInstance();
            r.output = this.output;
            r.iVars();
            if (global_proxy_cursor != null) {
                r.obj_create((Obj)global_proxy_cursor);
                r.disableInput();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void goto_room(Room r) {
        boolean gui;
        this.stop();
        r.output = this.output;
        if (global_proxy_cursor != null) {
            r.obj_create((Obj)global_proxy_cursor);
            r.disableInput();
        }
        if (r.first_time) {
            r.iVars();
        } else {
            r.start();
        }
        switch (r.animation_preference) {
            case NULL: {
                gui = Game_looper.GUI_DRAW_ENABLED;
                break;
            }
            case GUI: {
                gui = true;
            }
            default: {
                gui = false;
            }
        }
        if (gui) {
            this.enterGuiDrawingMode();
        } else {
            this.enterFullAnimationMode();
        }
    }

    public void enterGuiDrawingMode() {
        this.looper.enterGuiDrawingMode();
    }

    public void enterFullAnimationMode() {
        this.looper.enterFullAnimationMode();
    }

    @Override
    public void addDrawingRegion(Rectangle rect) {
        this.looper.addDrawingRegion(rect);
    }

    protected static enum Animation_preference {
        FULL,
        GUI,
        NULL;

    }
}

