/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs;

import BryceImages.Operations.Drawing;
import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Obj_Container;
import Game_Engine.GUI.Interfaces.Pingable;
import java.awt.geom.AffineTransform;
import java.util.concurrent.CountDownLatch;

public class View
implements Pingable {
    private Rectangle screen;
    private Rectangle view;
    private int worldW;
    private int worldH;
    private boolean flag;

    public View(Rectangle screen, Rectangle view, int w, int h) {
        this.screen = screen;
        this.view = view;
        this.worldW = w;
        this.worldH = h;
    }

    public void draw(ImageB dest, List<Obj> L, CountDownLatch latch, AffineTransform AT) {
        Rectangle offsetBounds = this.screen.offset(AT.getTranslateX(), AT.getTranslateY());
        if ((dest = dest.getSubImage(offsetBounds)) == null) {
            latch.countDown();
            return;
        }
        renderThread r = new renderThread(dest, L, latch, AT);
        r.start();
    }

    public void setViewBounds(Rectangle screen, Rectangle view) {
        if (this.screen.equals(screen) && this.view.equals(view)) {
            return;
        }
        this.screen = screen;
        this.view = view;
        this.mutate();
    }

    public Rectangle getBounds() {
        return this.screen;
    }

    public void setScreenX(int x) {
        if (this.screen.getX() == x) {
            return;
        }
        this.screen.setX(x);
        this.mutate();
    }

    public void setScreenY(int y) {
        if (this.screen.getY() == y) {
            return;
        }
        this.screen.setY(y);
        this.mutate();
    }

    public void setScreenDimensions(int w, int h) {
        this.setScreenW(w);
        this.setScreenH(h);
    }

    public void setScreenW(int w) {
        if (this.screen.getW() == w) {
            return;
        }
        this.screen.setW(w);
        this.mutate();
    }

    public void setScreenH(int h) {
        if (this.screen.getH() == h) {
            return;
        }
        this.screen.setH(h);
        this.mutate();
    }

    public void setViewX(int x) {
        if (this.view.getX() == x) {
            return;
        }
        this.view.setX(x);
        this.mutate();
    }

    public void setViewY(int y) {
        if (this.view.getY() == y) {
            return;
        }
        this.view.setY(y);
        this.mutate();
    }

    public void moveView(int x, int y) {
        this.setViewX(this.getViewX() + x);
        this.setViewY(this.getViewY() + y);
    }

    public void setViewDimensions(int w, int h) {
        this.setViewW(w);
        this.setViewH(h);
    }

    public void setViewW(int w) {
        if (this.view.getW() == w) {
            return;
        }
        this.view.setW(w);
        this.mutate();
    }

    public void setViewH(int h) {
        if (this.view.getH() == h) {
            return;
        }
        this.view.setH(h);
        this.mutate();
    }

    public void setWorldDimensions(int w, int h) {
        this.setWorldW(w);
        this.setWorldH(h);
    }

    public void setWorldW(int w) {
        if (this.worldW == w) {
            return;
        }
        this.worldW = w;
        this.mutate();
    }

    public void setWorldH(int h) {
        if (this.worldH == h) {
            return;
        }
        this.worldH = h;
        this.mutate();
    }

    public int getScreenX() {
        return this.screen.getX();
    }

    public int getScreenY() {
        return this.screen.getY();
    }

    public int getScreenW() {
        return this.screen.getW();
    }

    public int getScreenH() {
        return this.screen.getH();
    }

    public int getViewX() {
        return this.view.getX();
    }

    public int getViewY() {
        return this.view.getY();
    }

    public int getViewW() {
        return this.view.getW();
    }

    public int getViewH() {
        return this.view.getH();
    }

    public int getWorldW() {
        return this.worldW;
    }

    public int getWorldH() {
        return this.worldH;
    }

    @Override
    public boolean flag() {
        if (this.flag) {
            this.flag = false;
            return true;
        }
        return false;
    }

    @Override
    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    private void mutate() {
        this.flag = true;
    }

    private class renderThread
    extends Thread {
        final ImageB dest;
        final List<Obj> L;
        final CountDownLatch latch;
        final AffineTransform AT;

        private renderThread(ImageB dest, List<Obj> L, CountDownLatch latch, AffineTransform AT) {
            this.dest = dest;
            this.L = L;
            this.latch = latch;
            this.AT = Drawing.translate(AT, View.this.screen.getX() - View.this.view.getX(), View.this.screen.getY() - View.this.view.getY());
        }

        @Override
        public void run() {
            for (Obj o : this.L) {
                if (!o.isVisible()) continue;
                this.drawObj(o);
            }
            this.latch.countDown();
        }

        private void drawObj(Obj o) {
            if (!(o instanceof Obj_Container)) {
                o.draw(this.dest, this.AT);
            }
            CountDownLatch tempLatch = new CountDownLatch(1);
            o.draw(this.dest, this.AT, tempLatch);
            try {
                tempLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

