/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs.actionLogging;

import Data_Structures.Structures.List;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.engine.Game_input;
import Game_Engine.Engine.engine.Game_looper;
import java.io.File;
import java.util.Iterator;
import util.FileIO;
import util.KeyParser;

public class Command {
    public static final int M_PRESS = 0;
    public static final int M_RELEASE = 1;
    public static final int M_MOVE = 2;
    public static final int K_PRESS = 3;
    public static final int K_RELEASE = 4;
    public static final int SET_DELAY = 5;
    private final int command;
    private final int x_dest;
    private final int y_dest;
    private final int key;
    public static final File serialFile = FileIO.parseFile("serialKeyLog.txt");
    private static final File javaFile = FileIO.parseFile("javaKeyLog.txt");

    public Command(int val) {
        this.command = val;
        this.x_dest = 0;
        this.y_dest = 0;
        this.key = 0;
    }

    public Command(int val, int input) {
        this.command = val;
        this.x_dest = 0;
        this.y_dest = 0;
        this.key = input;
    }

    public Command(int val, int x, int y) {
        this.command = val;
        this.x_dest = x;
        this.y_dest = y;
        this.key = 30;
    }

    public Command(int val, int x, int y, int delay) {
        this.command = val;
        this.x_dest = x;
        this.y_dest = y;
        this.key = delay;
    }

    public int getCommand() {
        return this.command;
    }

    public int getKey() {
        return this.key;
    }

    public int getDestX() {
        return this.x_dest;
    }

    public int getDestY() {
        return this.y_dest;
    }

    public static void openLogs() {
        FileIO.openFile(serialFile);
        FileIO.openFile(javaFile);
    }

    public static void logKeyP(int key) {
        FileIO.print(serialFile, (Object)"K_PRESS");
        FileIO.print(serialFile, (Object)key);
        FileIO.print(javaFile, (Object)("program.add(new Command(Command.M_MOVE, " + Game_input.mouse_x + ", " + Game_input.mouse_y + "));"));
        FileIO.print(javaFile, (Object)("program.add(new Command(Command.K_PRESS, " + KeyParser.getKeyText(key) + "));"));
    }

    public static void logKeyR(int key) {
        FileIO.print(serialFile, (Object)"K_RELEASE");
        FileIO.print(serialFile, (Object)key);
        FileIO.print(javaFile, (Object)("program.add(new Command(Command.K_RELEASE, " + KeyParser.getKeyText(key) + "));"));
    }

    public static void logMove(int mouse_x, int mouse_y) {
        int delay = Game_looper.getElapsedSteps();
        FileIO.print(serialFile, (Object)"M_MOVE");
        FileIO.print(serialFile, (Object)mouse_x);
        FileIO.print(serialFile, (Object)mouse_y);
        FileIO.print(serialFile, (Object)delay);
        FileIO.print(javaFile, (Object)("program.add(new Command(Command.M_MOVE, " + mouse_x + ", " + mouse_y + ", " + delay + "));"));
    }

    public static void logMouseP() {
        FileIO.print(serialFile, (Object)"M_PRESS");
        FileIO.print(javaFile, (Object)"program.add(new Command(Command.M_PRESS));");
    }

    public static void logMouseR() {
        FileIO.print(serialFile, (Object)"M_RELEASE");
        FileIO.print(javaFile, (Object)"program.add(new Command(Command.M_RELEASE));");
    }

    public static UBA<Command> computeProgramFromFile(File file) {
        List<String> data = FileIO.readFile(file);
        List<Command> output = new List<Command>();
        Iterator<String> iter2 = data.iterator();
        while (iter2.hasNext()) {
            output.add(Command.getNextCommand(iter2));
        }
        return output.toUBA();
    }

    private static Command getNextCommand(Iterator<String> iter2) {
        String command = iter2.next();
        if (command.equals("K_PRESS")) {
            int key = new Integer(iter2.next());
            return new Command(3, key);
        }
        if (command.equals("K_RELEASE")) {
            int key = new Integer(iter2.next());
            return new Command(4, key);
        }
        if (command.equals("M_MOVE")) {
            int x = new Integer(iter2.next());
            int y = new Integer(iter2.next());
            int delay = new Integer(iter2.next());
            return new Command(2, x, y, delay);
        }
        if (command.equals("M_PRESS")) {
            return new Command(0);
        }
        if (command.equals("M_RELEASE")) {
            return new Command(1);
        }
        return null;
    }
}

