/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.Objs;

import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.ImageProccessing.InterpolationVars;

public class obj_glidable
extends Obj {
    protected InterpolationVars interpolator = new InterpolationVars();
    private double x_current;
    private double y_current;
    protected double x_dest;
    protected double y_dest;
    private boolean glide = false;

    public obj_glidable(double x_in, double y_in) {
        super(x_in, y_in);
        this.interpolator.setMaxTime(5);
        this.x_dest = this.getX();
        this.y_dest = this.getY();
    }

    @Override
    protected void update() {
        if (this.glide) {
            this.glide = false;
            this.x_current = this.getX();
            this.y_current = this.getY();
            this.interpolator.reset();
        }
        if (!this.interpolator.done()) {
            double per = this.interpolator.getPercentage();
            double per2 = 1.0 - per;
            if (per == 1.0) {
                this.setX(this.x_dest);
                this.setY(this.y_dest);
            } else {
                this.setX(this.x_dest * per + this.x_current * per2);
                this.setY(this.y_dest * per + this.y_current * per2);
            }
        }
    }

    public void glide(Obj o) {
        this.glide(o.getX(), o.getY());
    }

    public void glide(double x, double y) {
        if (!this.interpolator.done()) {
            return;
        }
        this.glide = true;
        this.x_dest = x;
        this.y_dest = y;
    }

    private void forceGlide(double x, double y) {
        this.glide = true;
        this.x_dest = x;
        this.y_dest = y;
    }

    public boolean setInterpolationTime(int time) {
        if (!this.interpolator.done()) {
            return false;
        }
        this.interpolator.setMaxTime(time);
        return true;
    }

    @Override
    public void revert() {
        if (this.getX() == this.x_start && this.getY() == this.y_start && this.interpolator.done()) {
            return;
        }
        if (this.x_dest != this.x_start || this.y_dest != this.y_start || this.interpolator.done()) {
            this.forceGlide(this.x_start, this.y_start);
        }
    }

    public void setTimeTillDone(int delay_from_here) {
        this.interpolator.stop();
        this.setInterpolationTime(delay_from_here);
        this.glide(this.x_dest, this.y_dest);
    }
}

