/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.Engine.text;

import BryceImages.Operations.Drawing;
import BryceImages.Operations.ImageFactory;
import BryceImages.Rendering.StartRender;
import BryceMath.Calculations.MathB;
import Data_Structures.Structures.Box;
import Data_Structures.Structures.Data_Structure;
import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.List;
import Game_Engine.Engine.text.Symbols.ccDot;
import Game_Engine.Engine.text.ccAlphabet;
import Game_Engine.Engine.text.ccGreekAlphabet;
import Game_Engine.Engine.text.ccLargeBrackets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import util.StringParser;

public class TextManager {
    public static AArray<Symbol, BufferedImage> text = new AArray();
    private static StartRender R = new StartRender(true);
    public static final int TEXT_SIZE = 20;
    public static final String STR_PIXEL = "PIX";
    public static final String g_LAMBDA = "\\l";
    public static final String g_ALPHA = "\\a";
    public static final String g_BETA = "\\b";
    public static final String g_GAMMA = "\\g";
    public static final String g_EPSILON = "\\e";
    public static final String g_THETA = "\\t";
    public static final String g_DELTA = "\\d";
    public static final String DOT = "\\cdot";
    public static final String L_PAREN = "\\(";
    public static final String R_PAREN = "\\)";
    public static final String L_SQUARE_PAREN = "\\[";
    public static final String R_SQUARE_PAREN = "\\]";
    public static final String L_CURLY_PAREN = "\\{";
    public static final String R_CURLY_PAREN = "\\}";

    private static BufferedImage render(Symbol s) {
        BufferedImage output;
        if (text.lookup(s) != null) {
            throw new Error("Do not render the same symbols excessive times!");
        }
        if (s.isCharacter()) {
            output = R.render(new ccAlphabet(s.getChar(), s.getH()));
        } else if (s.string_equal(STR_PIXEL)) {
            output = ImageFactory.ColorRect(Color.black, 1, 1);
        } else if (s.string_equal(g_LAMBDA)) {
            output = R.render(new ccGreekAlphabet('l', s.getH()));
        } else if (s.string_equal(g_ALPHA)) {
            output = R.render(new ccGreekAlphabet('a', s.getH()));
        } else if (s.string_equal(g_BETA)) {
            output = R.render(new ccGreekAlphabet('b', s.getH()));
        } else if (s.string_equal(g_GAMMA)) {
            output = R.render(new ccGreekAlphabet('g', s.getH()));
        } else if (s.string_equal(g_DELTA)) {
            output = R.render(new ccGreekAlphabet('d', s.getH()));
        } else if (s.string_equal(g_EPSILON)) {
            output = R.render(new ccGreekAlphabet('e', s.getH()));
        } else if (s.string_equal(g_THETA)) {
            output = R.render(new ccGreekAlphabet('t', s.getH()));
        } else if (s.string_equal(DOT)) {
            output = R.render(new ccDot(s.getH(), s.getH()));
        } else if (s.string_equal(L_PAREN)) {
            output = R.render(new ccLargeBrackets(s.getH(), '('));
        } else if (s.string_equal(R_PAREN)) {
            output = R.render(new ccLargeBrackets(s.getH(), ')'));
        } else if (s.string_equal(L_SQUARE_PAREN)) {
            output = R.render(new ccLargeBrackets(s.getH(), '['));
        } else if (s.string_equal(R_SQUARE_PAREN)) {
            output = R.render(new ccLargeBrackets(s.getH(), ']'));
        } else if (s.string_equal(L_CURLY_PAREN)) {
            output = R.render(new ccLargeBrackets(s.getH(), '{'));
        } else if (s.string_equal(R_CURLY_PAREN)) {
            output = R.render(new ccLargeBrackets(s.getH(), '}'));
        } else {
            throw new Error(" The String:   " + s.val + "   is not supported yet!");
        }
        text.insert(s, output);
        return output;
    }

    public static void drawTextLeft(Graphics2D g, AffineTransform AT, double x, double y, String str, boolean should_tex) {
        TextManager.drawTextLeft(g, AT, x, y, str, 20, should_tex);
    }

    public static void drawTextLeft(Graphics2D g, AffineTransform AT, double x, double y, String str, int text_size, boolean should_tex) {
        if (str.length() < 1) {
            return;
        }
        int textX = (int)x;
        int textY = (int)y - text_size / 2;
        List<LocationImage> images = TextManager.populateImageList(str, text_size, should_tex);
        TextManager.drawText(g, AT, textX, textY, images, text_size);
    }

    public static void drawTextCenter(Graphics2D g, AffineTransform AT, double x, double y, String str, boolean should_tex) {
        TextManager.drawTextCenter(g, AT, x, y, str, 20, should_tex);
    }

    public static int drawTextCenter(Graphics2D g, AffineTransform AT, double x, double y, String str, int text_size, boolean should_tex) {
        if (str.length() < 1) {
            return (int)x;
        }
        List<LocationImage> images = TextManager.populateImageList(str, text_size, should_tex);
        int textW = TextManager.getLen(images, text_size);
        int textX = (int)x - textW / 2;
        int textY = (int)y - text_size / 2;
        TextManager.drawText(g, AT, textX, textY, images, text_size);
        return textX;
    }

    public static void drawTextRight(Graphics2D g, AffineTransform AT, double x, double y, String str, boolean should_tex) {
        TextManager.drawTextCenter(g, AT, x, y, str, 20, should_tex);
    }

    public static void drawTextRight(Graphics2D g, AffineTransform AT, double x, double y, String str, int text_size, boolean should_tex) {
        if (str.length() < 1) {
            return;
        }
        List<LocationImage> images = TextManager.populateImageList(str, text_size, should_tex);
        int textW = TextManager.getLen(images, text_size);
        int textX = (int)x - textW;
        int textY = (int)y - text_size / 2;
        TextManager.drawText(g, AT, textX, textY, images, text_size);
    }

    private static void drawText(Graphics2D g, AffineTransform AT, int textX, int textY, List<LocationImage> images, int text_size) {
        if (AT != null) {
            textX = (int)((double)textX + AT.getTranslateX());
            textY = (int)((double)textY + AT.getTranslateY());
        }
        for (LocationImage c : images) {
            if (c.image == null) continue;
            Drawing.draw_scaled(g, textX + c.x_offset, textY + c.y_offset, c.image, c.h_scale, c.v_scale);
        }
    }

    public static int getLen(String str, boolean should_tex) {
        return TextManager.getLen(TextManager.populateImageList(str, 20, should_tex), 20);
    }

    public static int getLen(String str, int text_size, boolean should_tex) {
        return TextManager.getLen(TextManager.populateImageList(str, text_size, should_tex), text_size);
    }

    private static int getLen(List<LocationImage> images, int text_size) {
        return images.getLast().x_offset;
    }

    public static int getSpacing(int text_size) {
        return text_size / 10;
    }

    private static List<LocationImage> populateImageList(String str, int size, boolean should_tex) {
        return TextManager.populateImageList(0, 0, str, size, should_tex);
    }

    /*
     * Unable to fully structure code
     */
    private static synchronized List<LocationImage> populateImageList(int x, int y, String str, int size, boolean should_tex) {
        output = new List<LocationImage>();
        iter = StringParser.createIterator(str);
        last = ' ';
        block5: while (iter.hasNext()) {
            c = iter.next().charValue();
            if (!should_tex) ** GOTO lbl-1000
            switch (c) {
                case '_': {
                    x = TextManager.proccessSmall(x, y, iter, output, size, true);
                    break;
                }
                case '^': {
                    x = TextManager.proccessSmall(x, y, iter, output, size, false);
                    break;
                }
                case '\\': {
                    sub_exp = new StringBuilder();
                    if (iter.hasNext()) {
                        c = iter.next().charValue();
                        reachedEnd = false;
                        while (StringParser.isAlphaNumericCharacter(c)) {
                            sub_exp.append(c);
                            if (!iter.hasNext()) {
                                reachedEnd = true;
                                break;
                            }
                            c = iter.next().charValue();
                        }
                        last = c;
                        BigY = y - size / 2 + 1;
                        command = sub_exp.toString();
                        len = command.length();
                        if (len == 0) {
                            command = "" + last;
                        }
                        if (command.equals("frac")) {
                            x = TextManager.parseFraction(x, y, c, iter, output, size);
                        } else if (command.equals("l")) {
                            s = new Symbol("\\l", size);
                            x = TextManager.proccessNormal(x, y, s, output);
                        } else if (command.equals("a")) {
                            s = new Symbol("\\a", size);
                            x = TextManager.proccessNormal(x, y, s, output);
                        } else if (command.equals("b")) {
                            s = new Symbol("\\b", size);
                            x = TextManager.proccessNormal(x, y, s, output);
                        } else if (command.equals("g")) {
                            s = new Symbol("\\g", size);
                            x = TextManager.proccessNormal(x, y, s, output);
                        } else if (command.equals("d")) {
                            s = new Symbol("\\d", size);
                            x = TextManager.proccessNormal(x, y, s, output);
                        } else if (command.equals("t")) {
                            s = new Symbol("\\t", size);
                            x = TextManager.proccessNormal(x, y, s, output);
                        } else if (command.equals("e")) {
                            s = new Symbol("\\e", size);
                            x = TextManager.proccessNormal(x, y, s, output);
                        } else if (command.equals("cdot")) {
                            s = new Symbol("\\cdot", size);
                            x = TextManager.proccessNormal(x, y, s, output);
                        } else if (command.equals("(")) {
                            s = new Symbol("\\(", size * 2);
                            x = TextManager.proccessNormal(x, BigY, s, output);
                        } else if (command.equals(")")) {
                            s = new Symbol("\\)", size * 2);
                            x = TextManager.proccessNormal(x, BigY, s, output);
                        } else if (command.equals("[")) {
                            s = new Symbol("\\[", size * 2);
                            x = TextManager.proccessNormal(x, BigY, s, output);
                        } else if (command.equals("]")) {
                            s = new Symbol("\\]", size * 2);
                            x = TextManager.proccessNormal(x, BigY, s, output);
                        } else if (command.equals("{")) {
                            s = new Symbol("\\{", size * 2);
                            x = TextManager.proccessNormal(x, BigY, s, output);
                        } else if (command.equals("}")) {
                            s = new Symbol("\\}", size * 2);
                            x = TextManager.proccessNormal(x, BigY, s, output);
                        }
                        if (last != ' ' && (len <= 0 || reachedEnd || command.equals("frac"))) continue block5;
                        iter.previous();
                        break;
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    s = new Symbol(c, size);
                    x = TextManager.proccessNormal(x, y, s, output);
                }
            }
        }
        bogus = new LocationImage(null, x, y);
        output.add(bogus);
        return output;
    }

    private static int proccessNormal(int x, int y, Symbol s, List<LocationImage> output) {
        return TextManager.proccessNormal(x, y, 1, 1, s, output);
    }

    private static int proccessNormal(int x, int y, int h_scale, int v_scale, Symbol s, List<LocationImage> output) {
        BufferedImage c_image = text.lookup(s);
        if (c_image == null) {
            c_image = TextManager.render(s);
        }
        LocationImage image_new = new LocationImage(c_image, x, y);
        image_new.v_scale = v_scale;
        image_new.h_scale = h_scale;
        output.add(image_new);
        return x + image_new.getW() + TextManager.getSpacing(s.getH());
    }

    private static int proccessSmall(int x, int y, Iterator<Character> iter2, List<LocationImage> data, int size, boolean sub) {
        int c = 95;
        while (c != 123 && iter2.hasNext()) {
            c = iter2.next().charValue();
        }
        String sub_exp = TextManager.parseBracketedObject(iter2, '{', '}');
        List<LocationImage> sub_images = sub ? TextManager.populateImageList(x + TextManager.getSpacing(size), y + size / 3 + 1, sub_exp, size * 2 / 3, true) : TextManager.populateImageList(x + TextManager.getSpacing(size), y, sub_exp, size * 2 / 3, true);
        int output = sub_images.pop().x_offset;
        data.append((Data_Structure<LocationImage>)sub_images);
        return output;
    }

    private static int parseFraction(int x, int y, char last_char, Iterator<Character> iter2, List<LocationImage> output, int size) {
        if (last_char != '{') {
            StringParser.scanFor(iter2, '{');
        }
        String numerator = TextManager.parseBracketedObject(iter2, '{', '}');
        StringParser.scanFor(iter2, '{');
        String denominator = TextManager.parseBracketedObject(iter2, '{', '}');
        int len_num = TextManager.getLen(numerator, size, true);
        int len_denom = TextManager.getLen(denominator, size, true);
        int len = MathB.max(len_num, len_denom);
        int num_text_x = x + len / 2 - len_num / 2;
        int num_text_y = y - size * 6 / 10 - 1;
        List<LocationImage> output_part = TextManager.populateImageList(num_text_x, num_text_y, numerator, size, true);
        output_part.pop();
        output.append((Data_Structure<LocationImage>)output_part);
        int denom_text_x = x + len / 2 - len_denom / 2;
        int denom_text_y = y + size * 6 / 10 + 1;
        output_part = TextManager.populateImageList(denom_text_x, denom_text_y, denominator, size, true);
        output_part.pop();
        TextManager.proccessNormal(x, denom_text_y - size / 5 - 1, len, size / 8 + 1, new Symbol(STR_PIXEL, size), output_part);
        output.append((Data_Structure<LocationImage>)output_part);
        return x + len;
    }

    private static String parseBracketedObject(Iterator<Character> iter2, char left_bracket, char right_bracket) {
        int parens_depth = 0;
        StringBuilder subExp = new StringBuilder();
        while (iter2.hasNext()) {
            char c = iter2.next().charValue();
            if (c == left_bracket) {
                ++parens_depth;
            }
            if (c == right_bracket) {
                if (parens_depth == 0) break;
                --parens_depth;
            }
            subExp.append("" + c);
        }
        return subExp.toString();
    }

    public static int[] getCharacterOffsets(String s, int size) {
        List<LocationImage> glyphs = TextManager.populateImageList(s, size, false);
        int[] output = new int[glyphs.size()];
        int i = 0;
        for (LocationImage image : glyphs) {
            output[i] = image.x_offset;
            ++i;
        }
        return output;
    }

    public static BufferedImage getGlyph(char c, int size, Box<Integer> h_offset) {
        List<LocationImage> glyphs = TextManager.populateImageList(String.valueOf(c), size, false);
        LocationImage letter = glyphs.getFirst();
        h_offset.val = letter.y_offset;
        return letter.image;
    }

    private static class LocationImage {
        private BufferedImage image;
        private int x_offset;
        private int y_offset;
        private int v_scale = 1;
        private int h_scale = 1;

        public LocationImage(BufferedImage image, int x, int y) {
            this.image = image;
            this.x_offset = x;
            this.y_offset = y;
        }

        public int getW() {
            return this.image.getWidth();
        }
    }

    public static class Symbol {
        private final String val;
        private final int height;

        public Symbol(char c, int h) {
            this.val = "" + c;
            this.height = h;
        }

        public Symbol(String str, int h) {
            this.val = str;
            this.height = h;
        }

        public int hashCode() {
            int code = this.val.hashCode();
            return code + this.height * code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Symbol)) {
                return false;
            }
            Symbol other = (Symbol)o;
            return other.val.equals(this.val) && other.height == this.height;
        }

        public boolean string_equal(String str) {
            return this.val == str;
        }

        public boolean isCharacter() {
            return this.val.length() == 1;
        }

        public char getChar() {
            return this.val.charAt(0);
        }

        public int getH() {
            return this.height;
        }
    }
}

