/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.Input;

import BryceMath.Geometry.Rectangle;
import BryceMath.Numbers.Rational;
import Game_Engine.GUI.Components.Input.gui_InputBox;
import Game_Engine.GUI.Components.Input.gui_IntegerInput;

public class gui_DecimalInput
extends gui_InputBox<Rational> {
    private gui_IntegerInput part_int;
    private gui_IntegerInput part_decimal;
    private boolean decimal = false;
    private boolean changed = false;

    public gui_DecimalInput(double x, double y, int w, int h) {
        super(x, y, w, h);
        this.iVars();
    }

    public gui_DecimalInput(Rectangle rect) {
        super(rect);
        this.iVars();
    }

    private void iVars() {
        this.part_int = new gui_IntegerInput(0.0, 0.0, 0, 0);
        this.part_int.setVisible(false);
        this.part_decimal = new gui_IntegerInput(0.0, 0.0, 0, 0);
        this.part_decimal.setVisible(false);
    }

    @Override
    public void clearInput() {
        this.decimal = false;
        this.part_int.clearInput();
        this.part_decimal.clearInput();
        this.refreshText();
    }

    @Override
    public Rational getInput() {
        return new Rational(this.toString());
    }

    @Override
    public void forceKeyP(int key) {
        switch (key) {
            case 46: {
                this.decimal = true;
                this.refreshText();
                return;
            }
            case 8: {
                if (!this.decimal || this.part_decimal.getInputSize() != 0) break;
                this.decimal = false;
                this.refreshText();
                return;
            }
        }
        if (this.decimal && key != 45) {
            this.part_decimal.forceKeyP(key);
        } else {
            this.part_int.forceKeyP(key);
        }
        if (this.query_changed()) {
            this.refreshText();
        }
    }

    @Override
    public boolean input_changed() {
        boolean b1 = this.part_int.input_changed();
        boolean b2 = this.part_decimal.input_changed();
        if (this.changed || b1 || b2) {
            this.changed = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean query_changed() {
        return this.changed || this.part_int.query_changed() || this.part_decimal.query_changed();
    }

    void addChar(char c) {
        if (this.decimal) {
            this.part_decimal.addChar(c);
            return;
        }
        this.part_int.addChar(c);
    }

    public void refreshText() {
        this.setText(this.toString());
        this.changed = true;
    }

    public int getInputSize() {
        if (!this.decimal) {
            return this.part_int.getInputSize();
        }
        return this.part_int.getInputSize() + 1 + this.part_decimal.getInputSize();
    }

    public String toString() {
        if (this.getInputSize() == 0) {
            return this.part_int.toString();
        }
        if (this.decimal) {
            return String.valueOf(this.part_int.toString()) + '.' + this.part_decimal.toString();
        }
        return this.part_int.toString();
    }

    @Override
    public void update() {
        super.update();
        this.fitToContents();
    }

    public void setDefaultText(String str) {
        this.part_int.setDefaultText(str);
        this.refreshText();
    }

    public void populateInput(double val) {
        String str = "" + val;
        String[] parts = str.split(".");
        this.part_int.populateInput(new Integer(parts[0]));
        this.part_decimal.populateInput(new Integer(parts[1]));
    }
}

